/***********************************************************************/
/*!
 * \file   Lock.cpp
 * \brief  mutex lock
 *************************************************************************
 \verbatim

    PROJECT:        Gen3
    SW-COMPONENT:   Smart Phone Integration
    DESCRIPTION:    TCL mutex handling
    AUTHOR:         ppa1kor
    COPYRIGHT:      &copy; RBEI

    HISTORY:
    Date        | Author                | Modification
    05.10.2013  | ppa1kor               | Initial Version
    09.10.2013  | Shihabudheen P M      | Updated
    15.07.2015  | Sameer Chandra        | Fixed Issues
    13.06.2019  | jun5kor               | removed usage of pthread_mutex

 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/

#include "Lock.h"
#include <stdio.h>
#include <chrono>
//#include <sys/syscall.h> //Uncomment to debug
//#include <unistd.h> //Uncomment to debug

/******************************************************************************
 | defines and macros (scope: module-local)
 |----------------------------------------------------------------------------*/

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_UTILS
      #include "trcGenProj/Header/Lock.cpp.trc.h"
   #endif
#endif
/*************************************************************************
 ** FUNCTION:  Lock::Lock()
 *************************************************************************/
Lock::Lock() : m_ToValue(30)
{
   // TODO Auto-generated constructor stub
}

/*************************************************************************
 ** FUNCTION:  Lock::~Lock()
 *************************************************************************/
Lock::~Lock()
{

}

/*************************************************************************
 ** FUNCTION:  int Lock::s16Lock()
 *************************************************************************/
int Lock::s16Lock()
{
   //ETG_TRACE_USR1(("Lock::s16Lock() entered tid(%d) object(%p)",syscall(SYS_gettid),this)); //Uncomment to debug
   int ret = -1;
   if(0 == m_ToValue)
   {
       m_mutex.lock();
       ret = 0;
   }
   else
   {
       /*The clock tied to timeout_time is used, which means that adjustments of the clock are taken into account.*/
       auto now = std::chrono::steady_clock::now();
       if(m_mutex.try_lock_until(now + std::chrono::seconds(m_ToValue)))
       {
           ret = 0;
       }
       else
       {
           ETG_TRACE_ERRMEM(("Lock::s16Lock() failed to acquire lock!!"));
       }
   }
   return ret;
}

/*************************************************************************
 ** FUNCTION:  void Lock::vUnlock()
 *************************************************************************/
void Lock::vUnlock()
{
    //ETG_TRACE_USR1(("Lock::vUnlock() entered tid(%d) object(%p)",syscall(SYS_gettid),this)); //Uncomment to debug
    m_mutex.unlock();
}

/*************************************************************************
 ** void Lock::vSetTimeout(const unsigned int sec)
 *************************************************************************/
void Lock::vSetTimeout(const unsigned int sec)
{
   m_ToValue = sec;
}

