/*!
*******************************************************************************
* \file              HIDUtils.cpp
* \brief             Utils class Hid Descriptors
*******************************************************************************
\verbatim
PROJECT:        G3G
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    HID Utils class for Hid Descriptors
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
May 30,2019|  ptr4kor                     | Initial Version

\endverbatim
******************************************************************************/

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include "HIDUtils.h"


/******************************************************************************
 | defines and macros (scope: module-local)
 |----------------------------------------------------------------------------*/

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_UTILS
      #include "trcGenProj/Header/HIDUtils.cpp.trc.h"
   #endif
#endif

static const t_U8 scou8HID_USAGE_PAGE     = 0x05;
static const t_U8 scou8HID_COLLECTION     = 0xA1;
static const t_U8 scou8HID_END_COLLECTION = 0xC0;
static const t_U8 scou8HID_REPORT_SIZE    = 0x75;
static const t_U8 scou8HID_INPUT          = 0x81;
static const t_U8 scou8HID_LOGICAL_MIN    = 0x15;
static const t_U8 scou8HID_LOGICAL_MAX    = 0x25;
static const t_U8 scou8HID_REPORT_COUNT   = 0x95;

//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported


/***************************************************************************
** FUNCTION:  HIDUtils::HIDUtils()
***************************************************************************/
HIDUtils::HIDUtils()
{
   ETG_TRACE_USR1(("HIDUtils::HIDUtils"));
   m_vecu8HIDDescriptor.clear();
}

/***************************************************************************
** FUNCTION:  HIDUtils::~HIDUtils()
***************************************************************************/
HIDUtils::~HIDUtils()
{
   ETG_TRACE_USR1(("HIDUtils::~HIDUtils"));
   m_vecu8HIDDescriptor.clear();
}

/***************************************************************************
** FUNCTION: HIDUtils::vAddUsage(const t_U8 cou8Usage)
***************************************************************************/
t_Void HIDUtils::vAddUsage(const t_U8 cou8Usage)
{
   ETG_TRACE_USR1(("HIDUtils::vAddUsage(const t_U8 cou8Usage)"));
   m_vecu8HIDDescriptor.push_back(scou8HID_USAGE);
   m_vecu8HIDDescriptor.push_back(cou8Usage);
}

/***************************************************************************
** FUNCTION: HIDUtils::vAddUsage(const std::vector<t_U8>& corfrvecu8Usage)
***************************************************************************/
t_Void HIDUtils::vAddUsage(const std::vector<t_U8>& corfrvecu8Usage)
{
   ETG_TRACE_USR1(("HIDUtils::vAddUsage(const std::vector<t_U8>& corfrvecu8Usage)"));
   m_vecu8HIDDescriptor.insert(m_vecu8HIDDescriptor.end(),corfrvecu8Usage.begin(),corfrvecu8Usage.end());
}


/***************************************************************************
** FUNCTION: HIDUtils::vAddUsagePage()
***************************************************************************/
t_Void HIDUtils::vAddUsagePage(const t_U8 cou8UsagePage)
{
   ETG_TRACE_USR1(("HIDUtils::vAddUsagePage"));
   m_vecu8HIDDescriptor.push_back(scou8HID_USAGE_PAGE);
   m_vecu8HIDDescriptor.push_back(cou8UsagePage);
}

/***************************************************************************
** FUNCTION: HIDUtils::vStartCollection()
***************************************************************************/
t_Void HIDUtils::vStartCollection(const t_U8 cou8StartCollection)
{
   ETG_TRACE_USR1(("HIDUtils::vStartCollection"));
   m_vecu8HIDDescriptor.push_back(scou8HID_COLLECTION);
   m_vecu8HIDDescriptor.push_back(cou8StartCollection);
}

/***************************************************************************
** FUNCTION: HIDUtils::vAddLogicalMinMax()
***************************************************************************/
t_Void HIDUtils::vAddLogicalMinMax(const t_U8 cou8Min, const t_U8 cou8Max)
{
   ETG_TRACE_USR1(("HIDUtils::vAddLogicalMinMax"));
   m_vecu8HIDDescriptor.push_back(scou8HID_LOGICAL_MIN);
   m_vecu8HIDDescriptor.push_back(cou8Min);
   m_vecu8HIDDescriptor.push_back(scou8HID_LOGICAL_MAX);
   m_vecu8HIDDescriptor.push_back(cou8Max);
}

/***************************************************************************
** FUNCTION: HIDUtils::vAddReportSize()
***************************************************************************/
t_Void HIDUtils::vAddReportSize(const t_U8 cou8ReportSize)
{
   ETG_TRACE_USR1(("HIDUtils::vAddReportSize"));
   m_vecu8HIDDescriptor.push_back(scou8HID_REPORT_SIZE);
   m_vecu8HIDDescriptor.push_back(cou8ReportSize);
}

/***************************************************************************
** FUNCTION: HIDUtils::vAddReportCount()
***************************************************************************/
t_Void HIDUtils::vAddReportCount(const t_U8 cou8ReportCount)
{
   ETG_TRACE_USR1(("HIDUtils::vAddReportCount"));
   m_vecu8HIDDescriptor.push_back(scou8HID_REPORT_COUNT);
   m_vecu8HIDDescriptor.push_back(cou8ReportCount);
}

/***************************************************************************
** FUNCTION: HIDUtils::vAddInput()
***************************************************************************/
t_Void HIDUtils::vAddInput(const t_U8 cou8Input)
{
   ETG_TRACE_USR1(("HIDUtils::vAddInput"));
   m_vecu8HIDDescriptor.push_back(scou8HID_INPUT);
   m_vecu8HIDDescriptor.push_back(cou8Input);
}

/***************************************************************************
** FUNCTION: HIDUtils::vEndCollection()
***************************************************************************/
t_Void HIDUtils::vEndCollection()
{
   ETG_TRACE_USR1(("HIDUtils::vEndCollection"));
   m_vecu8HIDDescriptor.push_back(scou8HID_END_COLLECTION);
}

/***************************************************************************
** FUNCTION: HIDUtils::vGetHIDDescriptor()
***************************************************************************/
t_Void HIDUtils::vGetHIDDescriptor(std::vector<t_U8>& rfrvecu8HIDDescriptor)
{
   ETG_TRACE_USR1(("HIDUtils::vGetHIDDescriptor"));
   rfrvecu8HIDDescriptor = m_vecu8HIDDescriptor;
}

