/*!
*******************************************************************************
* \file              Event.h
* \brief             Event handler
*******************************************************************************
\verbatim
PROJECT:        G3G
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Event  handler
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
02.04.2014 |  Shihabudheen P M            | Initial Version

\endverbatim
******************************************************************************/

#ifndef EVENT_H
#define EVENT_H

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include <pthread.h>
#include "GenericSingleton.h"

/****************************************************************************/
/*!
* \class Event
* \brief Event Handler
*
* This class is used as a helper utility to support the implementation of 
* Events based on the posix lock and signal
****************************************************************************/
class Event : public GenericSingleton<Event>
{
public:
  /***************************************************************************
   *********************************PUBLIC************************************
   ***************************************************************************/

  /***************************************************************************
   ** FUNCTION:  Event::~Event()
   ***************************************************************************/
   /*!
   * \fn     ~Event()
   * \brief  Destructor
   * \sa     Event()
   **************************************************************************/
   virtual ~Event();

  /***************************************************************************
   ** FUNCTION:  Event::Lock()
   ***************************************************************************/
   /*!
   * \fn     Lock()
   * \brief  Lock the mutex
   * \sa     
   **************************************************************************/
   void vLock();

  /***************************************************************************
   ** FUNCTION:  Event::vUnLock()
   ***************************************************************************/
   /*!
   * \fn     vUnLock()
   * \brief  Unlock the mutex
   * \sa    
   **************************************************************************/
   void vUnLock();

  /***************************************************************************
   ** FUNCTION:  Event::vWait()
   ***************************************************************************/
   /*!
   * \fn     vWait()
   * \brief  Wait on a conditional variable
   * \sa     
   **************************************************************************/
   void vWait();

     /***************************************************************************
   ** FUNCTION:  Event::vTimedWait()
   ***************************************************************************/
   /*!
   * \fn     vTimedWait()
   * \brief  Wait on a conditional variable for a particular time
   * \param  u32WaitTime : [IN] Wait time in milli seconds
   * \sa     
   **************************************************************************/
   void vTimedWait(unsigned int u32WaitTime);

  /***************************************************************************
   ** FUNCTION:  Event::vSignal()
   ***************************************************************************/
   /*!
   * \fn     vSignal()
   * \brief  Signal on a conditional variable
   * \sa     
   **************************************************************************/
   void vSignal();

   //! Fried class declarartion to use singleton utility.
   friend class GenericSingleton<Event>;

  /***************************************************************************
   **************************END OF PUBLIC************************************
   ***************************************************************************/
private:

  /***************************************************************************
   *********************************PRIVATE***********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  Event::Event()
   ***************************************************************************/
   /*!
   * \fn     Event()
   * \brief  Constructor
   * \sa     ~Event()
   **************************************************************************/
   Event();

  /***************************************************************************
   ** FUNCTION:  Event::Event()
   ***************************************************************************/
   /*!
   * \fn     Event()
   * \brief  Constructor
   * \param  MutexAttr : [IN] Mutex attribute variable.
   * \sa     ~Event()
   **************************************************************************/
   Event(const pthread_mutexattr_t MutexAttr, const pthread_condattr_t CondAttr);

   //! Mutext varaiable
   pthread_mutex_t m_Mutext;

   //! Conditional variable
   pthread_cond_t  m_CondVar;

  /***************************************************************************
   *********************************END OF PRIVATE****************************
   ***************************************************************************/
};


#endif