/***********************************************************************/
/*!
* \file  spi_tclDynamicConfiguration.h
* \brief  Implementation of the Class spi_tclDynamicConfiguration
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         kmo6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
22.08.2018  | kmo6kor			      | Initial Version
23.08.2018  | BDU6KOR               | added the functions which use datapool object from ConfigReader.h
\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLDYNAMICCONFIGURATION_
#define SPI_TCLDYNAMICCONFIGURATION_

#include <sstream>
#include <string>
#include "Lock.h"
#include "SPITypes.h"
#include "spi_tclDynamicConfigurationBase.h"
#include "spi_tclDynamicConfigurationReaderBase.h"

class spi_tclDynamicConfiguration : public virtual spi_tclDynamicConfigurationBase
{

public:

   /***************************************************************************
   ****************************PUBLIC *********************************
   ***************************************************************************/

   /***************************************************************************
	** FUNCTION:  spi_tclDynamicConfiguration::spi_tclDynamicConfiguration()
	***************************************************************************/
   /*!
	* \fn      spi_tclDynamicConfiguration()
	* \brief   Constructor
	* \param   None
	**************************************************************************/
   spi_tclDynamicConfiguration(spi_tclDynamicConfigurationReaderBase* poDynamicConfigurationReader);

   /***************************************************************************
	** FUNCTION:  spi_tclDynamicConfiguration::~spi_tclDynamicConfiguration()
	***************************************************************************/
   /*!
	* \fn      ~spi_tclDynamicConfiguration()
	* \brief   Destructor
	* \param   None
	**************************************************************************/
   virtual ~spi_tclDynamicConfiguration();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDynamicConfiguration::vSetVehicleManufacturerInformation(...)
   ***************************************************************************/
   /*!
   * \fn      t_Void vSetVehicleManufacturerInformation(const trVehicleManufacturerInformation& corfrVehicleManufacturerInfoAttr)
   * \brief   Method to set the  Vehicle Manufacturer Information
   * \param   [IN] corfrVehicleManufacturerInfoAttr:Vehicle Manufacturer Information
   * \retval  None
   **************************************************************************/
   t_Void vSetVehicleManufacturerInformation(const trVehicleManufacturerInformation& corfrVehicleManufacturerInfoAttr);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDynamicConfiguration::vSetDriveSideInfoToDatapool()
   ***************************************************************************/
   /*!
   * \fn      t_Void vSetDriveSideInfoToDatapool()
   * \brief   Method to set the night mode info
   * \param   enVehicleConfig : [IN] Drive side info.
   * \retval  t_Void
   **************************************************************************/
   t_Void vSetDriveSideInfoToDatapool(tenDriveSideInfo enDriveSideInfo) override;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDynamicConfiguration::vReadScreenConfigs()
   ***************************************************************************/
   /*!
   * \fn      t_Void vReadScreenConfigs()
   * \brief   Method to read screen attributes from KDS/EOL/datapool based on Project
   * \param   NONE
   * \retval  t_Void
   **************************************************************************/
   t_Void vReadScreenConfigs();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDynamicConfiguration::vSetDefaultDisplayAttributes()
   ***************************************************************************/
   /*!
   * \fn      t_Void vSetDefaultDisplayAttributes()
   * \brief   Method to Set the Default Values for the Display Attributes
   * \param   NONE
   * \retval  t_Void
   **************************************************************************/
   t_Void vSetDefaultDisplayAttributes();

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDynamicConfiguration::vGetPixelAspectRatio()
   ***************************************************************************/
   /*!
   * \fn      t_Void vGetPixelAspectRatio()
   * \brief   Method to read the pixel aspect ratio
   * \param   [IN] rfszPixelAspectRatio : The string to be configured with
   *                                       the pixel aspect ratio.
   * \retval  t_Void
   **************************************************************************/
   t_Void vGetPixelAspectRatio(t_String& rfszPixelAspectRatio);

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfiguration::bReadVehicleManufacturerInfofromDatapool()
    ***************************************************************************/
   /*!
    * \fn      bReadVehicleManufacturerInfofromDatapool()
    * \brief   Function to Read Vehicle Manufacturer information
    * \retval  t_Bool
    ***************************************************************************/
   t_Bool bReadVehicleManufacturerInfofromDatapool(trVehicleManufacturerInformation& rfrVehicleManufacturerInformation) override;

   /***************************************************************************
   ** FUNCTION:  t_String spi_tclDynamicConfiguration::szGetSoftwareVersion()
   ***************************************************************************/
   /*!
   * \fn      t_String szGetSoftwareVersion()
   * \brief   Method to get the software version
   * \param   NONE
   * \retval  t_String
   **************************************************************************/
   t_String szGetSoftwareVersion() const;

   /***************************************************************************
   ****************************END OF PUBLIC *********************************
   ***************************************************************************/

private:

   /***************************************************************************
   ****************************PRIVATE *********************************
   ***************************************************************************/
   //! Vehicle Manufacturer Information
   trVehicleManufacturerInformation m_rVehicleManufacturerInformation;

   /***************************************************************************
   ****************************END OF PRIVATE *********************************
   ***************************************************************************/

};
#endif //SPI_TCLDYNAMICCONFIGURATION_
