/*!
 *******************************************************************************
 * \file              spi_tclClockClientHandler.cpp
 * \brief             VD Clock Client handler class
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    VD Clock Client handler class
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        |  Author                       | Modifications
 22.01.2019  |  Rajendra Naik Vadthe         | Initial Version

 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/

#include "spi_tclClockClientHandler.h"
//@todo - Issue - bpstl ambiguous usage should be removed
#include "XFiObjHandler.h"
#include "FIMsgDispatch.h"
using namespace shl::msgHandler;

//Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_TYPES
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_ERRORCODES
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_FUNCTIONIDS
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_SERVICEINFO
#include "clock_fi_if.h"

#include "Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_DATASERVICE
#include "trcGenProj/Header/spi_tclClockClientHandler.cpp.trc.h"
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported	

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
typedef XFiObjHandler<clock_mainfi_tclMsgTimeFormatStatus> spi_tXFiTimeFormatStatus;

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(spi_tclClockClientHandler, ahl_tclBaseWork)
// Add your ON_MESSAGE_SVCDATA() macros here to define which corresponding
// method should be called on receiving a specific message.
ON_MESSAGE_SVCDATA(CLOCK_MAINFI_C_U16_TIMEFORMAT,
         AMT_C_U8_CCAMSG_OPCODE_STATUS,
         vHandleTimeFormatStatus)

END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/***************************************************************************
 *********************************PUBLIC*************************************
 ***************************************************************************/

/*******************************************************************************
 * FUNCTION: spi_tclClockClientHandler::
 *             spi_tclClockClientHandler(ahl_tclBaseOneThreadApp* poMainAppl)
 *******************************************************************************/
spi_tclClockClientHandler::spi_tclClockClientHandler(ahl_tclBaseOneThreadApp* poMainApp)
: ahl_tclBaseOneThreadClientHandler(
         poMainApp, /* Application Pointer          */
         CCA_C_U16_SRV_CLOCK, /* ID of used Service           */
         CLOCK_MAINFI_C_U16_SERVICE_MAJORVERSION, /* MajorVersion of used Service */
         CLOCK_MAINFI_C_U16_SERVICE_MINORVERSION), /* MinorVersion of used Service */
m_poMainApp(poMainApp),
m_bIsServiceAvialable(false),
m_bIsServiceAvialablePending(false),
m_u8CurVDClockTimeFormat(e8VD_CLOCK_TIMEFORMAT_UNKNOWN)
{
   ETG_TRACE_USR1(("spi_tclClockClientHandler::spi_tclClockClientHandler entered "));
}

/*******************************************************************************
 * FUNCTION: spi_tclClockClientHandler::
 *             ~spi_tclClockClientHandler(t_Void)
 *******************************************************************************/
spi_tclClockClientHandler::~spi_tclClockClientHandler()
{
   ETG_TRACE_USR1(("spi_tclClockClientHandler::~spi_tclClockClientHandler entered "));
   m_poMainApp = NULL;
}

/*******************************************************************************
 * FUNCTION: t_Void spi_tclClockClientHandler::vOnServiceAvailable()
 *******************************************************************************/
t_Void spi_tclClockClientHandler::vOnServiceAvailable()
{
   ETG_TRACE_USR1(("spi_tclClockClientHandler::vOnServiceAvailable entered "));
   m_bIsServiceAvialable = true;

   if (m_bIsServiceAvialablePending)
   {
      vRegisterForProperty();
   }
}

/*******************************************************************************
 * FUNCTION: t_Void spi_tclClockClientHandler::vOnServiceUnavailable(
 *******************************************************************************/
t_Void spi_tclClockClientHandler::vOnServiceUnavailable()
{
   ETG_TRACE_USR1(("spi_tclClockClientHandler::vOnServiceUnavailable entered "));
   m_bIsServiceAvialable = false;
}

/***************************************************************************
 * FUNCTION:  t_Void spi_tclClockClientHandler::vRegisterForProperty()
 ***************************************************************************/
t_Void spi_tclClockClientHandler::vRegisterForProperty()
{
   if (m_bIsServiceAvialable)
   {
      ETG_TRACE_USR1(("spi_tclClockClientHandler::vRegisterProperty()"));
      m_bIsServiceAvialablePending = false;
      vAddAutoRegisterForProperty (CLOCK_MAINFI_C_U16_TIMEFORMAT);
   }
   else
   {
      ETG_TRACE_USR1(("spi_tclClockClientHandler::vRegisterProperty() -> ServiceAvialablePending"));
      m_bIsServiceAvialablePending = true;
   }
}   //end of vRegisterForProperty()

/***************************************************************************
 * FUNCTION:  t_Void spi_tclClockClientHandler::vUnregisterForProperty()
 ***************************************************************************/
t_Void spi_tclClockClientHandler::vUnregisterForProperty()
{
   ETG_TRACE_USR1(("spi_tclClockClientHandler :vUnRegisterProperty"));
   // Auto register the device notify connection and disconnection properties
   vRemoveAutoRegisterForProperty (CLOCK_MAINFI_C_U16_TIMEFORMAT);

}   //end of vUnregisterForProperty()

/***************************************************************************************************
 * FUNCTION:  t_Void spi_tclClockClientHandler::vHandleTimeFormatStatus(amt_tclServiceData* poMessage)
 ****************************************************************************************************/
tVoid spi_tclClockClientHandler::vHandleTimeFormatStatus(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("spi_tclClockClientHandler::vHandleTimeFormatStatus() entered"));
   spi_tXFiTimeFormatStatus oTimeFormatStatus(*poMessage, CLOCK_MAINFI_C_U16_SERVICE_MAJORVERSION);

   /*lint -esym(40,fvOnSensorData)fvOnSensorData Undeclared identifier */

   t_U8 u8TimeFormat = e8VD_CLOCK_TIMEFORMAT_UNKNOWN;

   if (true == oTimeFormatStatus.bIsValid())
   {
      u8TimeFormat = static_cast<t_U8>(oTimeFormatStatus.enTimeFormat.enType);
      ETG_TRACE_USR1(("spi_tclClockClientHandler::vHandleTimeFormatStatus m_u8CurVDClockTimeFormat = %d u8TimeFormat = %d ", m_u8CurVDClockTimeFormat, u8TimeFormat));
      //Donot Pass if TimeFormat is not 12 or 24. Also, send update if there is change in timeformat
      // Sending the TimeFormat update to CDB Data Service

      if (e8VD_CLOCK_TIMEFORMAT_12HOUR == u8TimeFormat || e8VD_CLOCK_TIMEFORMAT_24HOUR == u8TimeFormat)
      {
         if (m_u8CurVDClockTimeFormat != u8TimeFormat)
         {
            m_u8CurVDClockTimeFormat = u8TimeFormat;
            ETG_TRACE_USR1(("spi_tclClockClientHandler::vHandleTimeFormatStatus change m_u8CurVDClockTimeFormat = %d u8TimeFormat = %d ", m_u8CurVDClockTimeFormat, u8TimeFormat));
            //! Forward Clock data to subscriber
            if (NULL != m_rClockCallbacks.fvOnClockData)
            {
               m_rClockCallbacks.fvOnClockData(u8TimeFormat);
            }
         }
      }
   }
   else
   {
      ETG_TRACE_ERR(("spi_tclClockClientHandler::vHandleTimeFormatStatus() ERROR:  Message Decode Failed"));
   }

}

/*********************************************************************************************
 ** FUNCTION:   spi_tclClockClientHandler::vRegisterCallbacks(trClockCbs rClockCallbacks)
 **********************************************************************************************/
t_Void spi_tclClockClientHandler::vRegisterCallbacks(trClockCbs rClockCallbacks)
{
   ETG_TRACE_USR1(("spi_tclClockClientHandler::vRegisterCallbacks entered"));
   m_rClockCallbacks = rClockCallbacks;
}

//lint �restore

