/*!
*******************************************************************************
* \file              spi_tclClockClientHandler.h
* \brief             Clock Client handler class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Clock Client handler class 
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                     | Modifications
22.01.2019 |  Rajendra Naik Vadthe       | Initial Version


\endverbatim
******************************************************************************/

#ifndef _SPI_TCL_CLIENTHANDLER_CLOCK_H_
#define _SPI_TCL_CLIENTHANDLER_CLOCK_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"
#include "SPITypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/



/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/**
* \brief   CLOCK_FI Client handler class
*/
class spi_tclClockClientHandler 
   : public ahl_tclBaseOneThreadClientHandler
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclClockClientHandler::spi_tclClockClientHandler(..)
   ***************************************************************************/
   /*!
   * \fn     spi_tclClockClientHandler(ahl_tclBaseOneThreadApp* poMainApp)
   * \brief  Parametrized Constructor
   * \param  poMainApp : [IN] Pointer to main app.
   * \sa
   **************************************************************************/
   spi_tclClockClientHandler(ahl_tclBaseOneThreadApp* poMainApp);

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclClockClientHandler::~spi_tclClockClientHandler()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclClockClientHandler()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclClockClientHandler();

   /***************************************************************************
   * Application specific methods.
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclClockClientHandler::vOnServiceAvailable()
   ***************************************************************************/
   /*!
   * \fn      vOnServiceAvailable()
   * \brief   This function is called by the framework if the service of our server
   *         becomes available, e.g. server has been started.
   * \sa
   **************************************************************************/
   virtual t_Void vOnServiceAvailable();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclClockClientHandler::vOnServiceUnavailable()
   ***************************************************************************/
   /*!
   * \fn      vOnServiceUnavailable()
   * \brief   This function is called by the framework if the service of our server
   *         becomes unavailable, e.g. server has been shut down.
   * \sa
   **************************************************************************/
   virtual t_Void vOnServiceUnavailable();

   /***************************************************************************
   ** Handler function declarations used by message map.
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclClockClientHandler::vRegisterForProperty()
   ***************************************************************************/
   /*!
   * \fn      vRegisterForProperty()
   * \brief   This function is called for Property registration
   * \sa
   **************************************************************************/
   virtual t_Void vRegisterForProperty();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclClockClientHandler::vUnregisterForProperty()
   ***************************************************************************/
   /*!
   * \fn      vUnregisterForProperty()
   * \brief   This function is called for Property unregistration 
   * \sa
   **************************************************************************/
   virtual t_Void vUnregisterForProperty();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclClockClientHandler::vHandleTimeFormatStatus()
   ***************************************************************************/
   /*!
   * \fn      vHandleTimeFormatStatus(amt_tclServiceData* poMessage)
   * \brief   This Property represents VD Clock TimeFormat message obtained from VD Clock Service.
   * \param   poMessage: [IN] Pointer to VD Clock message
   * \sa
   **************************************************************************/
   t_Void vHandleTimeFormatStatus(amt_tclServiceData* poMessage);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclClockClientHandler::vRegisterCallbacks()
   ***************************************************************************/
   /*!
   * \fn      vRegisterCallbacks(trClockCbs rClockCallbacks)
   * \brief   Interface to register for Clock data callbacks.
   * \param   rClockCallbacks: [IN] Callback Structure
   * \sa
   **************************************************************************/
   t_Void vRegisterCallbacks(trClockCbs rClockCallbacks);


   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/
   DECLARE_MSG_MAP(spi_tclClockClientHandler)

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclClockClientHandler::spi_tclClockClientHandler()
   ***************************************************************************/
   /*!
   * \fn     spi_tclClockClientHandler()
   * \brief  Default Constructor, will not be implemented.
   **************************************************************************/
   spi_tclClockClientHandler();

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
   * 'spi_tclClockClientHandler' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   spi_tclClockClientHandler& operator=(const spi_tclClockClientHandler &oClientHandler);

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   /*
    * Main application pointer
    */
   ahl_tclBaseOneThreadApp*   m_poMainApp;
   /*
    * Structure containing callbacks to VDClock_FI data subscriber.
    */
   trClockCbs      m_rClockCallbacks;

   //Flag to check Service Availability
   t_Bool m_bIsServiceAvialable;

    //Flag to check VD Clock Service Availability Pending Status. This will be useful when SPI comes up before VD Clock Service
   t_Bool m_bIsServiceAvialablePending;

   t_U8 m_u8CurVDClockTimeFormat;


   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};

#endif // spi_tclClockClientHandler
