/*!
*******************************************************************************
* \file              spi_tclDiaglogClient.h
* \brief             DIAGLOG Client handler class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    DIAGLOG Client handler class
COPYRIGHT:      &copy; RBEI

HISTORY:
 Date       |  Author                           | Modifications
 14.09.2018 |  Rajendra Naik Vadthe 	   | Initial Version

\endverbatim
******************************************************************************/

#ifndef _SPI_TCLDIAGLOGCLIENT_H_
#define _SPI_TCLDIAGLOGCLIENT_H_

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
//!Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

//!Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

//!Include SPM FI types
#define CCA_S_IMPORT_INTERFACE_GENERIC

#include "SPITypes.h"


/******************************************************************************
| defines and macros and constants(scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
//typedef diaglog_corefi_tclMsgBaseMessage diaglog_FiMsgBase;

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/* Forward Declarations. */

//! \brief:  ITC_Tests for SPI
typedef enum
{
   //ITC Test for USB Open Load
   e8ITC_USB_OPEN_LOAD = 0,
   //ITC Test for Communication Problem
   e8ITC_USB_COMMUNICATION_PROBLEM = 1
} tenITCTest;

//! \brief:  ITC_Tests for SPI
typedef enum
{
   //ITC Test for USB Open Load
   e8ITC_TEST_RESULT_PASSED = 0,
   //ITC Test for Communication Problem
   e8ITC_TEST_RESULT_FAILED,
   e8ITC_TEST_RESULT_NO_RESULT,
   e8ITC_TEST_RESULT_PASSED_DIAGNOSTIC,
   e8ITC_TEST_RESULT_FAILED_DIAGNOSTIC,
   e8ITC_TEST_RESULT_NO_RESULT_DIAGNOSTIC,
   e8ITC_TEST_RESULT_DISABLE,
   e8ITC_TEST_RESULT_ENABLE
} tenITCTestResult;

/*!
* \class spi_tclDiaglogClient
* \brief Diaglog client handler class.
*/
class spi_tclDiaglogClient
   : public ahl_tclBaseOneThreadClientHandler
{

public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiaglogClient::spi_tclDiaglogClient(ahl_tclBaseOneThreadApp...)
   **************************************************************************/
   /*!
   * \fn      spi_tclDiaglogClient(ahl_tclBaseOneThreadApp* poMainAppl)
   * \brief   Overloaded Constructor
   * \param   [IN] poMainAppl : Pointer to main CCA application
   **************************************************************************/
   spi_tclDiaglogClient(ahl_tclBaseOneThreadApp* poMainAppl);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiaglogClient::~spi_tclDiaglogClient()
   **************************************************************************/
   /*!
   * \fn      ~spi_tclDiaglogClient()
   * \brief   Destructor
   **************************************************************************/
   virtual ~spi_tclDiaglogClient();

   /**************************************************************************
   * Overriding ahl_tclBaseOneThreadService methods.
   **************************************************************************/

   /**************************************************************************
   ** FUNCTION:  tVoid spi_tclDiaglogClient::vOnServiceAvailable();
   **************************************************************************/
   /*!
   * \fn      vOnServiceAvailable()
   * \brief   This method is called by the framework if the service of our
   *          server becomes available, e.g. server has been started.
   * \param   None
   **************************************************************************/
   virtual tVoid vOnServiceAvailable();

   /**************************************************************************
   ** FUNCTION:  tVoid spi_tclDiaglogClient::vOnServiceUnavailable();
   **************************************************************************/
   /*!
   * \fn      vOnServiceUnavailable()
   * \brief   This method is called by the framework if the service of our
   *          server becomes unavailable, e.g. server has been shut down.
   * \param   None
   **************************************************************************/
   virtual tVoid vOnServiceUnavailable();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiaglogClient::vRegisterForProperties()
   **************************************************************************/
   /*!
   * \fn      vRegisterForProperties()
   * \brief   Registers for interested properties to SPM.
   **************************************************************************/
   virtual t_Void vRegisterForProperties();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiaglogClient::vUnregisterForProperties()
   **************************************************************************/
   /*!
   * \fn      vUnregisterForProperties()
   * \brief   Registers for interested properties to SPM
   **************************************************************************/
   virtual t_Void vUnregisterForProperties();

   /***************************************************************************
	** FUNCTION: t_Void spi_tclService::vPostDeviceDTCStatus
	***************************************************************************/
   /*!
	* \fn	  vHandleDeviceDTCStatus(tenDTCStatus enDevDTCStatus)
	* \brief  Handles DTC Status.
	*		  The client can retrieve the detailed information
	*		  via the methods provided.
	* \param  [IN] enDevDTCStatus  : enum value which stores DTC status
	**************************************************************************/
   t_Void vHandleDeviceDTCStatus(tenDTCStatus enDevDTCStatus);  

   DECLARE_MSG_MAP(spi_tclDiaglogClient)


private:

   /***************************************************************************
    *********************************PRIVATE************************************
    ***************************************************************************/

   /***************************************************************************
    * ! Handler method declarations used by message map.
    ***************************************************************************/
   /*-----------------------------------------------------------------------------*
    * FUNCTION:  t_Void vHandle_DiaglogSendNextTestResult_Status(amt_tclServiceData* poMessage)*
    * \fn      vHandle_DiaglogSendNextTestResult_Status(amt_tclServiceData* poMessage)
    * \brief   Called by Diaglog Service when property update message is
    *          sent by it to the DiaglogClient.
    * \param   [IN] poMessage : Pointer to message
    *-----------------------------------------------------------------------------*/
   t_Void vHandle_DiaglogSendNextTestResult_Status(amt_tclServiceData* poMessage);
   /***************************************************************************
    ** FUNCTION:  spi_tclDiaglogClient::vSendTestResult(...)
    **************************************************************************/
   /*!
    * \fn      vHandle_SystemState_Status(amt_tclServiceData* poMessage)
    * \brief   Called to Send ITC test results to Diaglog Service.
    * \param   [IN] ITC_test : ITC test
    * \param   [IN] ITC_result : ITC result
    **************************************************************************/
   t_Void vSendTestResult(tenITCTest ITC_test, tenITCTestResult ITC_result);
   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclMPlayClientHandler::vPopulateMessageContext(..
   ***************************************************************************/
   /*!
   * \fn     vPopulateMessageContext(trMsgContext &rMsgContext)
   * \brief  Function to populate the message context
   * \param  rMsgContext : [OUT] Message context
   **************************************************************************/
  t_Void vPopulateMessageContext(trMsgContext &rMsgContext) const;

   /**************************************************************************
   * ! Other methods
   **************************************************************************/

   /**************************************************************************
    ** FUNCTION:  spi_tclDiaglogClient::spi_tclDiaglogClient()
    **************************************************************************/
    /*!
    * \fn      spi_tclDiaglogClient()
    * \brief   Default Constructor, will not be implemented.
    *          NOTE: This is a technique to disable the Default Constructor for
    *          this class. So if an attempt for the constructor is made compiler
    *          complains.
    **************************************************************************/
    spi_tclDiaglogClient();

    /**************************************************************************
     ** FUNCTION:  spi_tclDiaglogClient::spi_tclDiaglogClient(const...
     **************************************************************************/
     /*!
     * \fn      spi_tclDiaglogClient(const spi_tclDiaglogClient& oClient)
     * \brief   Copy Consturctor, will not be implemented.
     *          Avoids Lint Prio 3 warning: Info 1732: new in constructor for
     *          class'spi_tclDiaglogClient' which has no Copy Consturctor.
     *          NOTE: This is a technique to disable the Copy Consturctor for this
     *          class. So if an attempt for the copying is made linker complains.
     **************************************************************************/
     spi_tclDiaglogClient(const spi_tclDiaglogClient& oClient);

   /**************************************************************************
    ** FUNCTION:  spi_tclDiaglogClient::spi_tclDiaglogClient& operator=(...
    **************************************************************************/
    /*!
    * \fn      spi_tclDiaglogClient& operator=(
    *          const spi_tclDiaglogClient& oClient)
    * \brief   Assingment Operater, will not be implemented.
    *          Avoids Lint Prio 3 warning: Info 1732: new in constructor for
    *          class 'spi_tclDiaglogClient' which has no assignment operator.
    *          NOTE: This is a technique to disable the assignment operator for this
    *          class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
    spi_tclDiaglogClient& operator=(const spi_tclDiaglogClient& oClient);

   /***************************************************************************
   * ! Data members
   ***************************************************************************/

   /***************************************************************************
   ** Main Application pointer
   ***************************************************************************/
   ahl_tclBaseOneThreadApp*   m_poMainAppl;
   // Flag to maintain to Current DTC Status
   tenDTCStatus m_enCurDTCStatus;
   //Flag to check Service Availability
   t_Bool m_bIsServiceAvailable;
   //Flag to check registration status
   t_Bool m_bIsRegistrationSuccess;
};

#endif // _SPI_TCLSPMCLIENT_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>
