/***********************************************************************/
/*!
 * \file  spi_tclMySPINCmdVideo.h
 * \brief  Implementation of the Class spi_tclMySPINCmdVideo
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         gri2kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "mySPINTypes.h"
#include "spi_tclMySPINTAVideoIntf.h"
#include "spi_tclMySPINTADataIntf.h"
#include "spi_tclMySPINMsgQInterface.h"
#include "spi_tclMySPINVideoDispatcher.h"
#include "spi_tclMySPINCmdVideo.h"

#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MYSPINWRAPPER
#include "trcGenProj/Header/spi_tclMySPINCmdVideo.cpp.trc.h"
#endif
#endif

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINCmdVideo::spi_tclMySPINCmdVideo()
 ***************************************************************************/
spi_tclMySPINCmdVideo::spi_tclMySPINCmdVideo()
{
   ETG_TRACE_USR1(("spi_tclMySPINCmdVideo::spi_tclMySPINCmdVideo()"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINCmdVideo::~spi_tclMySPINCmdVideo()
 ***************************************************************************/
spi_tclMySPINCmdVideo::~spi_tclMySPINCmdVideo()
{
   ETG_TRACE_USR1(("spi_tclMySPINCmdVideo::~spi_tclMySPINCmdVideo()"));
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclMySPINCmdVideo::bInitialize()
 ***************************************************************************/
t_Bool spi_tclMySPINCmdVideo::bInitialize()
{
   ETG_TRACE_USR1(("spi_tclMySPINCmdVideo::bInitialize()"));
   return true;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINCmdVideo::vUninitialize()
 ***************************************************************************/
t_Void spi_tclMySPINCmdVideo::vUninitialize()
{
   ETG_TRACE_USR1(("spi_tclMySPINCmdVideo::vUninitialize()"));
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINCmdVideo::vSetFrameProperties()
 ***************************************************************************/
t_Void spi_tclMySPINCmdVideo::vSetFrameProperties(t_U32 u32DevID, const trMySpinVideoConfig& corfrVideoConfig)
{
   ETG_TRACE_USR1(("spi_tclMySPINCmdVideo::vSetFrameProperties()"));

   spi_tclMySPINTADataIntf oTADataIntf;
   spi_tclMySPINTAVideoIntf* poMySPINTAVideoIntf = oTADataIntf.poGetTAVideoIntfInst();
   if (NULL != poMySPINTAVideoIntf)
   {
      trMySPINVideoCbs rMySPINVideoCbs;
      memset(&rMySPINVideoCbs, 0, sizeof(rMySPINVideoCbs));
      rMySPINVideoCbs.vFirstFrameRenderedCb = &spi_tclMySPINCmdVideo::vFirstFrameRenderedCallback;
      rMySPINVideoCbs.vLayerManagerInitCb = &spi_tclMySPINCmdVideo::vLayerManagerInitializedCallback;
      rMySPINVideoCbs.vLayerManagerDeinitCb = &spi_tclMySPINCmdVideo::vLayerManagerDeinitializedCallback;

      poMySPINTAVideoIntf->vRegisterVideoCbs(u32DevID, rMySPINVideoCbs);

      MSPIN_PIXEL_FORMAT enMySPINPixelFormat = enGetPixelFormat(corfrVideoConfig.enPixelFormat);
      MSPIN_FRAME_COMPRESSION enMySPINPixelComp = enGetPixelComp(corfrVideoConfig.enPixelCompression);
      MSPIN_FRAME_COMPRESSION enMySPINPreferredPixelComp = enGetPixelComp(corfrVideoConfig.enPreferredCompression);

      poMySPINTAVideoIntf ->vSetFrameProperties(u32DevID,
               corfrVideoConfig.u32LayerId,
               corfrVideoConfig.u32SurfaceId,
               corfrVideoConfig.u32WidthInPixels,
               corfrVideoConfig.u32HeightInPixels,
               corfrVideoConfig.u32WidthInMm,
               corfrVideoConfig.u32HeightInMm,
               enMySPINPixelFormat,
               enMySPINPixelComp,
               enMySPINPreferredPixelComp);
   }//if(NULL != poMySPINTAVideoIntf)
}

/***************************************************************************
 ** FUNCTION: MSPIN_FRAME_COMPRESSION spi_tclMySPINCmdVideo::enGetPixelComp()
 ***************************************************************************/
MSPIN_FRAME_COMPRESSION spi_tclMySPINCmdVideo::enGetPixelComp(tenPixelCompression enPixelComp)
{
   MSPIN_FRAME_COMPRESSION enMySPINPixelComp = MSPIN_FRAME_COMPRESSION_NONE;
   switch (enPixelComp)
   {
      case PIXEL_COMP_ZLIB:
      {
         enMySPINPixelComp = MSPIN_FRAME_COMPRESSION_ZLIB;
      }
         break;
      case PIXEL_COMP_JPEG:
      {
         enMySPINPixelComp = MSPIN_FRAME_COMPRESSION_JPEG;
      }
         break;
      case PIXEL_COMP_UNCOMPRESSED:
      {
         enMySPINPixelComp = MSPIN_FRAME_COMPRESSION_UNCOMPRESSED;
      }
         break;
      case PIXEL_COMP_NONE:
      default:
      {
         //Nothing to do
      }
   }
   return enMySPINPixelComp;
}

/***************************************************************************
 ** FUNCTION: MSPIN_PIXEL_FORMAT spi_tclMySPINCmdVideo::enGetPixelFormat()
 ***************************************************************************/
MSPIN_PIXEL_FORMAT spi_tclMySPINCmdVideo::enGetPixelFormat(tenPixelFormat enPixelFormat)
{
   MSPIN_PIXEL_FORMAT enMySPINPixelFormat = MSPIN_PIXEL_FORMAT_RGB565;

   switch (enPixelFormat)
   {
      case e8_PIXELFORMAT_RGB888:
      {
         enMySPINPixelFormat = MSPIN_PIXEL_FORMAT_RGB888;
      }
         break;
      case e8_PIXELFORMAT_ARGB888:
      {
         enMySPINPixelFormat = MSPIN_PIXEL_FORMAT_ARGB8888;
      }
         break;
      case e8_PIXELFORMAT_RGBA8888:
      {
         enMySPINPixelFormat = MSPIN_PIXEL_FORMAT_RGBA8888;
      }
         break;
      case e8_PIXELFORMAT_RGB565:
      case e8_PIXELFORMAT_UNKNOWN:
      default:
      {
         //Nothing to do
      }
   }
   return enMySPINPixelFormat;
}

/***************************************************************************
 ** FUNCTION: tenErrorCode spi_tclMySPINCmdVideo::enStartVideoPlayback()
 ***************************************************************************/
tenErrorCode spi_tclMySPINCmdVideo::enStartVideoPlayback(t_U32 u32DevID, t_Bool bTriggeredOnLaunch)
{
   ETG_TRACE_USR1(("spi_tclMySPINCmdVideo::enStartVideoPlayback()"));

   tenErrorCode enErrorCode = e8UNKNOWN_ERROR;

   spi_tclMySPINTADataIntf oTADataIntf;
   spi_tclMySPINTAVideoIntf* poMySPINTAVideoIntf = oTADataIntf.poGetTAVideoIntfInst();
   if (NULL != poMySPINTAVideoIntf)
   {
      enErrorCode = poMySPINTAVideoIntf ->enStartVideoPlayback(u32DevID);
      if ((true == bTriggeredOnLaunch) && (e8NO_ERRORS == enErrorCode))
      {
         PlaybackStartOnLaunchMsg oPlaybackStartOnLaunchMsg;
         oPlaybackStartOnLaunchMsg.u32DeviceID = u32DevID;
         spi_tclMySPINMsgQInterface *poMsgQinterface = spi_tclMySPINMsgQInterface::getInstance();
         if (NULL != poMsgQinterface)
         {
            poMsgQinterface->bWriteMsgToQ(&oPlaybackStartOnLaunchMsg, sizeof(oPlaybackStartOnLaunchMsg));
         }
      }
   }

   return enErrorCode;
}

/***************************************************************************
 ** FUNCTION: tenErrorCode spi_tclMySPINCmdVideo::enStopVideoPlayback()
 ***************************************************************************/
tenErrorCode spi_tclMySPINCmdVideo::enStopVideoPlayback(t_U32 u32DevID)
{
   ETG_TRACE_USR1(("spi_tclMySPINCmdVideo::enStopVideoPlayback()"));

   tenErrorCode enErrorCode = e8UNKNOWN_ERROR;

   spi_tclMySPINTADataIntf oTADataIntf;
   spi_tclMySPINTAVideoIntf* poMySPINTAVideoIntf = oTADataIntf.poGetTAVideoIntfInst();
   if (NULL != poMySPINTAVideoIntf)
   {
      enErrorCode = poMySPINTAVideoIntf->enStopVideoPlayback(u32DevID);
      if(e8NO_ERRORS == enErrorCode)
      {
         ETG_TRACE_USR1(("spi_tclMySPINCmdVideo::enStopVideoPlayback(): no errors"));
         PlaybackStoppedMsg oPlaybackStopMsg;
         oPlaybackStopMsg.u32DeviceID = u32DevID;
         spi_tclMySPINMsgQInterface *poMsgQinterface = spi_tclMySPINMsgQInterface::getInstance();
         if (NULL != poMsgQinterface)
         {
            poMsgQinterface->bWriteMsgToQ(&oPlaybackStopMsg, sizeof(oPlaybackStopMsg));
         }
      }
   }//if(NULL != poMySPINTAVideoIntf)

   return enErrorCode;
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINCmdVideo::vSetWaylandTouch()
 ***************************************************************************/
t_Void spi_tclMySPINCmdVideo::vSetWaylandTouch(t_U32 u32DevID, t_Bool bEnableTouch)
{

   ETG_TRACE_USR2(("[DESC]::vSetWaylandTouch-%d", ETG_ENUM(BOOL, bEnableTouch)));

   spi_tclMySPINTADataIntf oTADataIntf;
   spi_tclMySPINTAVideoIntf* poMySPINTAVideoIntf = oTADataIntf.poGetTAVideoIntfInst();
   if (NULL != poMySPINTAVideoIntf)
   {
      poMySPINTAVideoIntf->vSetWaylandTouch(u32DevID, bEnableTouch);
   }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINCmdVideo::vPumpEvents()
 ***************************************************************************/
t_Void spi_tclMySPINCmdVideo::vPumpEvents(t_U32 u32DevID, t_S32 s32TimeOut)
{
   spi_tclMySPINTADataIntf oTADataIntf;
   spi_tclMySPINTAVideoIntf* poMySPINTAVideoIntf = oTADataIntf.poGetTAVideoIntfInst();
   if (NULL != poMySPINTAVideoIntf)
   {
      poMySPINTAVideoIntf->vPumpEvents(u32DevID, s32TimeOut);
   }//if(NULL != poMySPINTAVideoIntf)
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINCmdVideo::vFirstFrameRenderedCallback()
 ***************************************************************************/
t_Void spi_tclMySPINCmdVideo::vFirstFrameRenderedCallback(t_Void *poContext)
{
   ETG_TRACE_USR1(("spi_tclMySPINCmdVideo::vFirstFrameRenderedCallback()"));

   if (NULL != poContext)
   {
      FirstFBRenderedMsg oFirstFBRenderedMsg;
      trMySPINContext* rMySPINContext = static_cast<trMySPINContext*> (poContext);
      oFirstFBRenderedMsg.u32DeviceID = rMySPINContext->u32DeviceHandle;
      spi_tclMySPINMsgQInterface *poMsgQinterface = spi_tclMySPINMsgQInterface::getInstance();

      if (NULL != poMsgQinterface)
      {
         poMsgQinterface->bWriteMsgToQ(&oFirstFBRenderedMsg, sizeof(oFirstFBRenderedMsg));
      }
   }

}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINCmdVideo::vLayerManagerDeinitializedCallback()
 ***************************************************************************/
t_Void spi_tclMySPINCmdVideo::vLayerManagerDeinitializedCallback(t_Void *poContext)
{
   SPI_INTENTIONALLY_UNUSED(poContext)
   ETG_TRACE_USR1(("spi_tclMySPINCmdVideo::vLayerManagerDeinitializedCallback()"));
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINCmdVideo::vLayerManagerInitializedCallback()
 ***************************************************************************/
t_Void spi_tclMySPINCmdVideo::vLayerManagerInitializedCallback(t_Void *poContext)
{
   SPI_INTENTIONALLY_UNUSED(poContext)
   ETG_TRACE_USR1(("spi_tclMySPINCmdVideo::vLayerManagerInitializedCallback()"));
}
//lint -restore
