/***********************************************************************/
/*!
 * \file   spi_tclAAPVideoDispatcher.h
 * \brief  Message Dispatcher for Video Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Video Messages
 AUTHOR:         Shiva Kumar Gurija
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 20.03.2015  | Shiva Kumar Gurija    | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLAAPVIDEODISPATCHER_H_
#define _SPI_TCLAAPVIDEODISPATCHER_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "AAPTypes.h"
#include "RespRegister.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/
class spi_tclMySPINVideoDispatcher;

/****************************************************************************/
/*!
 * \class    MySPINVideoMsgBase
 * \brief    Base Message type for all
 ****************************************************************************/
class MySPINVideoMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  AAPVideoMsgBase::AAPVideoMsgBase
       ***************************************************************************/
      /*!
       * \fn      AAPVideoMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      MySPINVideoMsgBase();

      /***************************************************************************
       ** FUNCTION:  MySPINVideoMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclAAPVideoDispatcher* poDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param   poDispatcher: pointer to Video Message Dispatcher
       * retval   t_Void
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclMySPINVideoDispatcher* poDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  AAPVideoMsgBase::~AAPVideoMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~AAPVideoMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~MySPINVideoMsgBase()
      {
      }

}; //class AAPVideoMsgBase


/****************************************************************************/
/*!
 * \class    FirstFBRenderedMsg
 ****************************************************************************/
class FirstFBRenderedMsg: public MySPINVideoMsgBase
{
   public:

      t_U32 u32DeviceID;

      /***************************************************************************
       ** FUNCTION:  FirstFBRenderedMsg::FirstFBRenderedMsg
       ***************************************************************************/
      /*!
       * \fn      PlaybackFirstFBRenderedMsgStartMsg()
       * \brief   Default constructor
       **************************************************************************/
      FirstFBRenderedMsg() : u32DeviceID(0)
      {
      }

      /***************************************************************************
       ** FUNCTION:  FirstFBRenderedMsg::~FirstFBRenderedMsg
       ***************************************************************************/
      /*!
       * \fn      ~FirstFBRenderedMsg()
       * \brief   FirstFBRenderedMsg
       **************************************************************************/
      virtual ~FirstFBRenderedMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  FirstFBRenderedMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclMySPINVideoDispatcher* poDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poDispatcher: pointer to Video Message Dispatcher
       * retval   t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclMySPINVideoDispatcher* poDispatcher);
}; //class PlaybackStartMsg

/****************************************************************************/
/*!
 * \class    PlaybackStartOnLaunchMsg
 ****************************************************************************/
class PlaybackStartOnLaunchMsg: public MySPINVideoMsgBase
{
   public:

      t_U32 u32DeviceID;
      /***************************************************************************
       ** FUNCTION:  PlaybackStartOnLaunchMsg::PlaybackStartOnLaunchMsg
       ***************************************************************************/
      /*!
       * \fn      PlaybackStartOnLaunchMsg()
       * \brief   Default constructor
       **************************************************************************/
      PlaybackStartOnLaunchMsg() : u32DeviceID(0)
      {
      }

      /***************************************************************************
       ** FUNCTION:  PlaybackStartOnLaunchMsg::~PlaybackStartOnLaunchMsg
       ***************************************************************************/
      /*!
       * \fn      ~PlaybackStartOnLaunchMsg()
       * \brief   PlaybackStartOnLaunchMsg
       **************************************************************************/
      virtual ~PlaybackStartOnLaunchMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  PlaybackStartOnLaunchMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclAAPVideoDispatcher* poDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poDispatcher: pointer to Video Message Dispatcher
       * retval   t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclMySPINVideoDispatcher* poDispatcher);
};//class PlaybackStartOnLaunchMsg

/****************************************************************************/
/*!
 * \class    PlaybackStoppedMsg
 ****************************************************************************/
class PlaybackStoppedMsg: public MySPINVideoMsgBase
{
   public:

      t_U32 u32DeviceID;
      /***************************************************************************
       ** FUNCTION:  PlaybackStoppedMsg::PlaybackStoppedMsg
       ***************************************************************************/
      /*!
       * \fn      PlaybackStoppedMsg()
       * \brief   Default constructor
       **************************************************************************/
      PlaybackStoppedMsg() : u32DeviceID(0)
      {
      }

      /***************************************************************************
       ** FUNCTION:  PlaybackStoppedMsg::~PlaybackStoppedMsg
       ***************************************************************************/
      /*!
       * \fn      ~PlaybackStoppedMsg()
       * \brief   PlaybackStoppedMsg
       **************************************************************************/
      virtual ~PlaybackStoppedMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  PlaybackStoppedMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclAAPVideoDispatcher* poDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poDispatcher: pointer to Video Message Dispatcher
       * retval   t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclMySPINVideoDispatcher* poDispatcher);
};//class PlaybackStoppedMsg


/****************************************************************************/
/*!
 * \class    spi_tclAAPVideoDispatcher
 * \brief    Message Dispatcher for Video Messages
 ****************************************************************************/
class spi_tclMySPINVideoDispatcher
{

   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINVideoDispatcher::spi_tclMySPINVideoDispatcher()
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINVideoDispatcher()
       * \brief   Default Constructor
       * \param   t_Void
       * \sa      ~spi_tclMySPINVideoDispatcher()
       **************************************************************************/
      spi_tclMySPINVideoDispatcher()
      {
      }

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINVideoDispatcher::~spi_tclMySPINVideoDispatcher()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclMySPINVideoDispatcher()
       * \brief   Destructor
       * \param   t_Void
       * \sa      spi_tclMySPINVideoDispatcher()
       **************************************************************************/
      ~spi_tclMySPINVideoDispatcher()
      {
      }

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINVideoDispatcher::vHandleVideoMsg(PlaybackStartMsg..)
       ***************************************************************************/
      /*!
       * \fn      vHandleVideoMsg(PlaybackStartMsg* poPlaybackStart)
       * \brief   Handles Messages of PlaybackStartMsg type
       * \param   poPlaybackStart :Pointer object of type PlaybackStartMsg
       * retval   t_Void
       **************************************************************************/
      t_Void vHandleVideoMsg(PlaybackStartOnLaunchMsg* poPlaybackStart) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINVideoDispatcher::vHandleVideoMsg(FirstFBRenderedMsg..)
       ***************************************************************************/
      /*!
       * \fn      vHandleVideoMsg(FirstFBRenderedMsg* poFirstFBRendered)
       * \brief   Handles Messages of FirstFBRenderedMsg type
       * \param   poFirstFBRendered :Pointer object of type FirstFBRenderedMsg
       * retval   t_Void
       **************************************************************************/
      t_Void vHandleVideoMsg(FirstFBRenderedMsg* poFirstFBRendered) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINVideoDispatcher::vHandleVideoMsg(PlaybackStoppedMsg..)
       ***************************************************************************/
      /*!
       * \fn      vHandleVideoMsg(PlaybackStoppedMsg* poPlaybackStop)
       * \brief   Handles Messages of PlaybackStoppedMsg type
       * \param   poPlaybackStop :Pointer object of type PlaybackStoppedMsg
       * retval   t_Void
       **************************************************************************/
      t_Void vHandleVideoMsg(PlaybackStoppedMsg* poPlaybackStoppedMsg) const;

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINVideoDispatcher(const spi_tclMySPINVideoDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINVideoDispatcher(
       *                             const spi_tclAAPVideoDispatcher& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclAAPVideoDispatcher()
       ***************************************************************************/
      spi_tclMySPINVideoDispatcher(const spi_tclMySPINVideoDispatcher& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINVideoDispatcher& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINVideoDispatcher& operator=(
       *                          const spi_tclMySPINVideoDispatcher& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINVideoDispatcher(const spi_tclMySPINVideoDispatcher& otrSrc)
       ***************************************************************************/
      spi_tclMySPINVideoDispatcher& operator=(const spi_tclMySPINVideoDispatcher& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

}; //class spi_tclAAPVideoDispatcher


#endif //_SPI_TCLAAPVIDEODISPATCHER_H_
///////////////////////////////////////////////////////////////////////////////
// <EOF>
