/***********************************************************************/
/*!
 * \file  spi_tclMySPINCmdVehicleData.h
 * \brief  Implementation of the Class spi_tclMySPINCmdVehicleData
 *************************************************************************
 \verbatim


 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 12.04.2016  | Chaitra Srinivasa     | Adding comments

 \endverbatim
 *************************************************************************/

#include "mySPINTypes.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
typedef std::function<void(t_U32,tenVehicleConfiguration)> tvPostNightMode;
/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

class spi_tclMySPINCmdVehicleData
{

   public:

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVehicleData::spi_tclMySPINCmdVehicleData()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINCmdVehicleData()
       * \brief Constructor
       **************************************************************************/
      spi_tclMySPINCmdVehicleData();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVehicleData::~spi_tclMySPINCmdVehicleData()
       ***************************************************************************/
      /*!
       * \fn    ~spi_tclMySPINCmdVehicleData()
       * \brief Destructor
       **************************************************************************/
      virtual ~spi_tclMySPINCmdVehicleData();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVehicleData::t_Void vSetMovingStatus(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetMovingStatus(t_U32 u32DeviceHandle,
       *                    tenVehicleMovementState enVehicleMovementState)
       * \brief Method set moving status
       * \param u32DeviceHandle: [IN]Device handle
       * \param enVehicleMovementState: [IN]To store vehicle movement status
       * \retval t_Void
       **************************************************************************/
      t_Void vSetMovingStatus(t_U32 u32DeviceHandle, tenVehicleMovementState enVehicleMovementState);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVehicleData::t_Void vSetNightMode(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetNightMode(t_U32 u32DeviceHandle,
       *                         tenVehicleConfiguration enVehicleConfiguration)
       * \brief Method to set night mode
       * \param u32DeviceHandle: [IN]Device handle
       * \param enVehicleConfiguration: [IN]To store vehicle configuration
       * \retval t_Void
       **************************************************************************/
      t_Void vSetNightMode(t_U32 u32DeviceHandle, tenVehicleConfiguration enVehicleConfiguration);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVehicleData::t_Void vSetVehicleBTMACAddress(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetVehicleBTMACAddress(t_U32 u32DeviceHandle,
       *                                       t_String szVehicleBTAddress)
       * \brief Method to set vehicle BT MAC address
       * \param u32DeviceHandle: [IN]Device handle
       * \param szVehicleBTAddress: [IN]String for vehicle BT address
       * \retval t_Void
       **************************************************************************/
      t_Void vSetVehicleBTMACAddress(t_U32 u32DeviceHandle, t_String szVehicleBTAddress);

       /***************************************************************************
        ** FUNCTION:
        ***************************************************************************/
       /*!
        * \fn
        * \brief
        * \param
        * \param
        **************************************************************************/
       t_Void vSendPositionData(t_U32 u32DeviceHandle, t_String szNmeaSentence);

       /***************************************************************************
        ** FUNCTION:
        ***************************************************************************/
       /*!
        * \fn
        * \brief
        * \param
        * \param
        **************************************************************************/
       t_Void vRegisterCallbacks(t_U32 u32DeviceHandle,tvVehicleDataRequestCb VehicleDataRequestCb,t_Bool bIsNativeNavigationEnabled );

       /***************************************************************************
        ** FUNCTION:
        ***************************************************************************/
       /*!
        * \fn
        * \brief
        * \param
        * \param
        **************************************************************************/
       t_Void vSetVehicleManufactureInfo(const t_U32 u32DeviceHandle, t_U16 u16VehicleType, t_String szVehicleManufacturerName, t_String szVehicleManufacturerScope);

   private:

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVehicleData::t_Void vNavigateToCallback()
       ***************************************************************************/
      /*!
       * \fn    t_Void vNavigateToCallback()
       * \brief Call back for navigation purposes
       * \retval t_Void
       **************************************************************************/
      static t_Void vNavigateToCallback();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVehicleData::t_Void vVehicleDataRequestCallback()
       ***************************************************************************/
      /*!
       * \fn    t_Void vVehicleDataRequestCallback()
       * \brief Call back for vehicle data request
       * \retval t_Void
       **************************************************************************/
       static t_Void vVehicleDataRequestCallback(t_Void *poContext, t_Bool request,
          t_U8 u8length, t_U32 *u32keyList);

       //Callback
       static tvVehicleDataRequestCb m_VehicleDataRequestCb;
       //Day/Night mode
       static tenVehicleConfiguration m_enDayNightConfiguration;

       static tvPostNightMode ftvPostNightModeCb;
};

