/***********************************************************************/
/*!
 * \file  spi_tclMySPINTAWrapper.h
 * \brief  Implementation of the Class spi_tclMySPINTAWrapper
 *************************************************************************
 \verbatim


 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 11.04.2016  | Chaitra Srinivasa     | Adding comments

 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLMYSPINTAWRAPPER_H_
#define _SPI_TCLMYSPINTAWRAPPER_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "GenericSingleton.h"
#include "mySPINTypes.h"
#include "mspin_appl_if_adapter.h"
#include "spi_tclMySPINTAVideoIntf.h"
#include "spi_tclMySPINTAConnIntf.h"
#include "spi_tclMySPINTAVehicleDataIntf.h"
#include "spi_tclMySPINTAAudioIntf.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclMySPINTAWrapper
 * \brief Handles Target Adapter Instance Creation & Initialization -  Provides a data
 *         Interface Class to access mySPIN instance. -  Receives Callbacks from TA.
 *
 */
class spi_tclMySPINTAWrapper: public spi_tclMySPINTAVehicleDataIntf,
         public spi_tclMySPINTAVideoIntf,
         public spi_tclMySPINTAConnIntf,
         public spi_tclMySPINTAAudioIntf,
         public GenericSingleton<spi_tclMySPINTAWrapper>
{

   public:

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::~spi_tclMySPINTAWrapper()
       ***************************************************************************/
      /*!
       * \fn    ~spi_tclMySPINTAWrapper()
       * \brief Destructor for spi_tclMySPINTAWrapper class
       **************************************************************************/
      virtual ~spi_tclMySPINTAWrapper();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::tenErrorCode enConnectAoap()
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enConnectAoap(t_U32 u32DeviceHandle,
       *                          const trMySPINDevInfo& corfrDevInfo,
       *                          t_Bool& rfbAudioSupport)
       * \brief Method for connecting AOAP
       * \param u32DeviceHandle: [IN]Device handle
       * \param corfrDevInfo: [IN]Used for storing device info
       * \param rfbAudioSupport: [IN]Used to check whether advanced audio is supported or not
       * \retval tenErrorCode
       **************************************************************************/
      tenErrorCode enConnectAoap(t_U32 u32DeviceHandle, const trMySPINDevInfo& corfrDevInfo, t_Bool& rfbAudioSupport);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::tenErrorCode enConnectiAP2()
       ***************************************************************************/
      /*!
       * \fn     tenErrorCode enConnectiAP2(t_U32 u32DeviceHandle,
       *                          const trMySPINDevInfo& corfrDevInfo,
       *                          const trMySPINAccInfo& corfrAccInfo,
       *                          t_Bool isHostMode)
       * \brief Method used for connecting iAP2
       * \param u32DeviceHandle: [IN]Device handle
       * \param corfrDevInfo: [IN]Used for storing the device info
       * \param corfrAccInfo: [IN]Used for storing the accessory info
       * \retval tenErrorCode
       **************************************************************************/
      tenErrorCode enConnectiAP2(t_U32 u32DeviceHandle, const trMySPINDevInfo& corfrDevInfo,
               const trMySPINAccInfo& corfrAccInfo, t_Bool isHostMode);
      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::tenErrorCode enEAPSessionStart()
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enEAPSessionStart(t_U32 u32DeviceHandle)
       * \brief Method for starting EAP session
       * \param u32DeviceHandle: [IN]Device handle
       * \retval tenErrorCode
       **************************************************************************/
      tenErrorCode enEAPSessionStart(t_U32 u32DeviceHandle);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vEAPSessionStop(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vEAPSessionStop(t_U32 u32DeviceHandle)
       * \brief Method to stop EAP session
       * \param u32DeviceHandle: [IN]Device handle
       * \retval t_Void
       **************************************************************************/
      t_Void vEAPSessionStop(t_U32 u32DeviceHandle);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::tenErrorCode enStartVideoPlayback(...)
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enStartVideoPlayback(t_U32 u32DeviceHandle)
       * \brief Method to start video playbak
       * \param u32DeviceHandle: [IN]Device handle
       * \retval tenErrorCode
       **************************************************************************/
      virtual tenErrorCode enStartVideoPlayback(t_U32 u32DeviceHandle);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::tenErrorCode enStopVideoPlayback(...)
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enStopVideoPlayback(t_U32 u32DeviceHandle)
       * \brief Method to stop video playback
       * \param u32DeviceHandle: [IN]Device handle
       * \retval tenErrorCode
       **************************************************************************/
      virtual tenErrorCode enStopVideoPlayback(t_U32 u32DeviceHandle);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vPumpEvents(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vPumpEvents(t_U32 u32DevID,
       *                           t_S32 s32TimeOut)
       * \brief Method to pump events
       * \param u32DevID: [IN]Device ID
       * \param s32TimeOut: [IN]String for timeout
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vPumpEvents(t_U32 u32DevID, t_S32 s32TimeOut);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vSetWaylandTouch(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetWaylandTouch(t_U32 u32DeviceHandle,
       *                                t_Bool bIsWayland)
       * \brief Method to set wayland touch operation
       * \param u32DeviceHandle: [IN]Device handle
       * \param bIsWayland: [IN]Used to check whether wayland touch operation
       *                    is used or not
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSetWaylandTouch(t_U32 u32DeviceHandle, t_Bool bIsWayland);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vInitMySPIN()
       ***************************************************************************/
      /*!
       * \fn    t_Void vInitMySPIN()
       * \brief Method to initialize MySPIN
       * \retval t_Void
       **************************************************************************/
      t_Void vInitMySPIN();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vRegisterSessionCbs(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vRegisterSessionCbs(t_U32 u32DeviceHandle,
       *                          trMySPINSessionCbs rMySPINSessionCbs)
       * \brief Call back for session registration
       * \param u32DeviceHandle: [IN]Device handle
       * \param rMySPINSessionCbs: [IN]Structure to store MySPIN session
       *                            callback values
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vRegisterSessionCbs(t_U32 u32DeviceHandle, trMySPINSessionCbs rMySPINSessionCbs);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vRegisterVideoCbs()
       ***************************************************************************/
      /*!
       * \fn    t_Void vRegisterVideoCbs(t_U32 u32DeviceHandle,
       *                                 trMySPINVideoCbs rMySPINVideoCbs)
       * \brief Call back for video registration
       * \param u32DeviceHandle: [IN]Device handle
       * \param rMySPINVideoCbs: [IN]Structure to store MySPIN video
       *                            callback values
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vRegisterVideoCbs(t_U32 u32DeviceHandle, trMySPINVideoCbs rMySPINVideoCbs);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vRegisterVehicleDataCbs(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vRegisterVehicleDataCbs(t_U32 u32DeviceHandle,
       *                                    trVehicleDataCbs rVehicleDataCbs)
       * \brief Call back for vehicle data registration
       * \param u32DeviceHandle: [IN]Device handle
       * \param rVehicleDataCbs: [IN]Structure to store vehicle data call back values
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vRegisterVehicleDataCbs(t_U32 u32DeviceHandle, trVehicleDataCbs rVehicleDataCbs,t_Bool bIsNativeNavigationEnabled);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vRegisterAudioCbs()
       ***************************************************************************/
      /*!
       * \fn    t_Void vRegisterAudioCbs(t_U32 u32DeviceHandle,
       *                                 trMYSPINAudioCbs rMYSPINAudioCbs)
       * \brief Call back for audio registration
       * \param u32DeviceHandle: [IN]Device handle
       * \param rMYSPINAudioCbs: [IN]Structure to store audio call back values
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vRegisterAudioCbs(t_U32 u32DeviceHandle, trMYSPINAudioCbs rMYSPINAudioCbs);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vSetHUCapabilities(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetHUCapabilities(t_U32 u32DeviceHandle,
       *                                  tenHeadUnitCaps enHeadUnitCaps)
       * \brief Method to set the head unit capabilities
       * \param u32DeviceHandle: [IN]Device handle
       * \param enHeadUnitCaps: [IN]To store values related to HU capability
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSetHUCapabilities(t_U32 u32DeviceHandle, tenHeadUnitCaps enHeadUnitCaps)
      {
         //TODO add code
      }

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vSetFrameProperties(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetFrameProperties(t_U32 u32DeviceHandle,
       *                                   t_U32 u32LayerId,
       *                                   t_U32 u32SurfaceId,
       *                                   t_U32 u32WidthInPixels,
       *                                   t_U32 u32HeightInPixels,
       *                                   t_U32 u32WidthInMm,
       *                                   t_U32 u32HeightInMm,
       *                                   MSPIN_PIXEL_FORMAT enPixelFormat,
       *                                   MSPIN_FRAME_COMPRESSION  enPixelCompression,
       *                                   t_U32 u32PreferredCompression)
       * \brief Method to set frame properties
       * \param u32DeviceHandle: [IN]Device handle
       * \param u32LayerId: [IN]To store layer ID
       * \param u32SurfaceId: [IN]To store surface ID
       * \param u32WidthInPixels: [IN]To store width in pixels
       * \param u32HeightInPixels: [IN]To store height in pixels
       * \param u32WidthInMm: [IN]To store width in mm
       * \param u32HeightInMm: [IN]To store height in mm
       * \param enPixelFormat: [IN]To store pixel format
       * \param enPixelCompression: [IN]To store pixel compression
       * \param u32PreferredCompression: [IN]To store preferred compression
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSetFrameProperties(t_U32 u32DeviceHandle, t_U32 u32LayerId, t_U32 u32SurfaceId,
               t_U32 u32WidthInPixels, t_U32 u32HeightInPixels, t_U32 u32WidthInMm, t_U32 u32HeightInMm,
               MSPIN_PIXEL_FORMAT enPixelFormat, MSPIN_FRAME_COMPRESSION enPixelCompression,
               t_U32 u32PreferredCompression);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vSetAccessoryPropertiesAoap(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetAccessoryPropertiesAoap(t_U32 u32DeviceHandle,
       *                                 const trMySPINAccInfo& corfrAccInfo)
       * \brief Method to set accessory properties of AOAP
       * \param u32DeviceHandle: [IN]Device handle
       * \param corfrAccInfo: [IN]Used for accessory info
       * \retval t_Void
       **************************************************************************/
      t_Void vSetAccessoryPropertiesAoap(t_U32 u32DeviceHandle, const trMySPINAccInfo& corfrAccInfo);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::tenErrorCode enDisconnectiAP2(...)
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enDisconnectiAP2(t_U32 u32DeviceHandle)
       * \brief Method for disconnecting iAP2
       * \param u32DeviceHandle: [IN]Device handle
       * \retval tenErrorCode
       **************************************************************************/
      tenErrorCode enDisconnectiAP2(t_U32 u32DeviceHandle);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::tenErrorCode enDisconnectAOAP(...)
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enDisconnectAOAP(t_U32 u32DeviceHandle)
       * \brief Method to disconnect AOAP
       * \param u32DeviceHandle: [IN]Device handle
       * \retval tenErrorCode
       **************************************************************************/
      tenErrorCode enDisconnectAOAP(t_U32 u32DeviceHandle);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_U32 u32GetSupportedKeys(...)
       ***************************************************************************/
      /*!
       * \fn    t_U32 u32GetSupportedKeys(t_U32 u32DeviceHandle)
       * \brief Method to get supported keys
       * \param u32DeviceHandle: [IN]Device handle
       * \retval t_U32
       **************************************************************************/
      t_U32 u32GetSupportedKeys(t_U32 u32DeviceHandle);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::vSendKeyEvent(...)
       ***************************************************************************/
      /*!
       * \fn    vSendKeyEvent(t_U32 u32DeviceHandle,
       *                      tenKeyMode enKeyMode,
       *                      tenMySPINKeyCode enMySPINKeyCode)
       * \brief Method to send key event
       * \param u32DeviceHandle: [IN]Device handle
       * \param enKeyMode: [IN]To store key mode
       * \param enMySPINKeyCode: [IN]To store MySPIN key code
       * \retval t_Void
       **************************************************************************/
      t_Void vSendKeyEvent(t_U32 u32DeviceHandle, tenKeyMode enKeyMode, tenMySPINKeyCode enMySPINKeyCode);
      
      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vSendCustomKeyEvent()
       ***************************************************************************/
      /*!
       * \fn    t_Void vSendCustomKeyEvent(t_U32 u32DeviceHandle, 
       *                          tenMySPINCustomKeyMode enCustomKeyMode, 
       *                          tenMySPINCustomKeyCode enMySPINCustomKeyCode)
       * \brief Method for sending custom keys
       * \param u32DeviceHandle: [IN]Device handle
       * \param enCustomKeyMode: [IN]Custom key mode(myspin)
       * \param enMySPINCustomKeyCode: [IN]Custom Key code
       * \retval t_Void
       **************************************************************************/      
      t_Void vSendCustomKeyEvent(t_U32 u32DeviceHandle, 
                                 tenMySPINCustomKeyMode enCustomKeyMode, 
                                 tenMySPINCustomKeyCode enMySPINCustomKeyCode);         

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vSetMovingStatus(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetMovingStatus(t_U32 u32DeviceHandle,
       *                                t_Bool bIsMoving)
       * \brief Method to set moving status
       * \param u32DeviceHandle: [IN]Device handle
       * \param bIsMoving: [IN]To check whether the status is moving or not
       * \retval t_Void
       **************************************************************************/
      t_Void vSetMovingStatus(t_U32 u32DeviceHandle, t_Bool bIsMoving);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vSetNightMode(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetNightMode(t_U32 u32DeviceHandle,
       *                             t_Bool bIsNight)
       * \brief Method to set night mode
       * \param u32DeviceHandle: [IN]Device handle
       * \param bIsNight: [IN]To check whether the mode is night mode or not
       * retval t_Void
       **************************************************************************/
      t_Void vSetNightMode(t_U32 u32DeviceHandle, t_Bool bIsNight);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vSetVehicleBTMACAddress(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetVehicleBTMACAddress(t_U32 u32DeviceHandle,
       *                                       t_String szVehicleBTAddress)
       * \brief Method to set vehicle BT MAC address
       * \param u32DeviceHandle: [IN]Device handle
       * \param szVehicleBTAddress: [IN]String for Vehicle BT address
       * \retval t_Void
       **************************************************************************/
      t_Void vSetVehicleBTMACAddress(t_U32 u32DeviceHandle, t_String szVehicleBTAddress);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vSetVehicleManufactureInfo(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetVehicleManufactureInfo(t_U32 u32DeviceHandle, t_U16 u16VehicleType,
       *                                 t_String szVehicleManufacturerName, t_String szVehicleManufacturerScope)
       * \brief Method to set vehicle manufacturer name
       * \param cou32DevId: [IN]Device handle
       * \param u16VehicleType: [IN]Vehicle alliance type
       * \param szVehicleManufacturerName: [IN]String for Vehicle manufacturer name
       * \param szVehicleManufacturerScope: [IN]String for Vehicle manufacturer scope
       * \retval t_Void
       **************************************************************************/
      t_Void vSetVehicleManufactureInfo(const t_U32 cou32DevId, t_U16 u16VehicleType, t_String szVehicleManufacturerName, t_String szVehicleManufacturerScope);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vUpdateVoiceSessionStatus(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vUpdateVoiceSessionStatus(t_U32 u32DeviceHandle,
       *              tenMySPINVoiceSessionStatus enMySPINVoiceSessionStatus,
       *              tenMySPINVoiceSessionConstraint enMySPINVoiceSessionConstraint)
       * \brief Method to update voice session status
       * \param u32DeviceHandle: [IN]Device handle
       * \param enMySPINVoiceSessionStatus: [IN]To store MySPIN voice session
       *                                      status
       * \param enMySPINVoiceSessionConstraint: [IN]To store MySPIN voice session
       *                                         constraint
       * \retval t_Void
       **************************************************************************/
      t_Void vUpdateVoiceSessionStatus(t_U32 u32DeviceHandle, tenMySPINVoiceSessionStatus enMySPINVoiceSessionStatus,
               tenMySPINVoiceSessionConstraint enMySPINVoiceSessionConstraint);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vSendPositionData(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSendPositionData(t_U32 u32DeviceHandle, t_String szNmeaSentence)
       * \brief Method to send position data
       * \param u32DeviceHandle: [IN]Device handle
       * \param szNmeaSentence: [IN] NMEA Sentence
       * \retval t_Void
       **************************************************************************/
      t_Void vSendPositionData(t_U32 u32DeviceHandle, t_String szNmeaSentence);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vSendVehicleData(...)
       ***************************************************************************/
      /*!
       * \fn t_Void vSendVehicleData(t_U32 u32DeviceHandle, t_U32 u32Type ,t_String szJsonString)
       * \brief Method to send Vehicle Data
       * \param u32DeviceHandle: [IN]Device handle
       * \param u32Type: [IN]Type of vehicle data
       * \param szJsonString :[IN] JSON format string containg vehicle data
       **************************************************************************/
      t_Void vSendVehicleData(t_U32 u32DeviceHandle, t_U32 u32Type, t_String szJsonString);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Void vSetAudioStatus(...)
       ***************************************************************************/
      /*!
       * \fn t_Void vSetAudioStatus(t_U32 u32DeviceHandle, t_U32 u32requestID, tenAudioResponse enAudioResponse)
       * \brief Method to send Vehicle Data
       * \param u32DeviceHandle: [IN]Device handle
       * \param u32requestID: [IN]Request ID
       * \param enAudioResponse :[IN] Audio response
       **************************************************************************/
      t_Void vSetAudioStatus(t_U32 u32DeviceHandle, t_U32 u32requestID, tenAudioResponse enAudioResponse);
      
      //! Base Singleton class
      friend class GenericSingleton<spi_tclMySPINTAWrapper> ;

   private:

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::spi_tclMySPINTAWrapper()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINTAWrapper()
       * \brief Constructor
       **************************************************************************/
      spi_tclMySPINTAWrapper();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::MSPIN_Instance_t* getMySPINInstance(...)
       ***************************************************************************/
      /*!
       * \fn    MSPIN_Instance_t* getMySPINInstance(t_U32 u32DeviceHandle)
       * \brief Method to get MySPIN instance
       * \param u32DeviceHandle: [IN]Device handle
       * \retval MSPIN_Instance_t
       **************************************************************************/
      MSPIN_Instance_t* getMySPINInstance(t_U32 u32DeviceHandle);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::tenErrorCode vSetMySPINError(...)
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode vSetMySPINError(MSPIN_ERROR mySPINError)
       * \brief Method to set MySPIN error
       * \param mySPINError: [IN]To store MySPIN error
       * \retval tenErrorCode
       **************************************************************************/
      tenErrorCode vSetMySPINError(MSPIN_ERROR mySPINError);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAWrapper::t_Bool bIsDeviceConnected(...)
       ***************************************************************************/
      /*!
       * \fn    t_Bool bIsDeviceConnected(t_U32 u32DeviceHandle)
       * \brief Method to check whether the device is disconnected or not
       * \param u32DeviceHandle: [IN]Device handle
       * \retval t_Bool
       **************************************************************************/
      t_Bool bIsDeviceConnected(t_U32 u32DeviceHandle);

      //Pointer to MySPIN instance
      MSPIN_Instance_t* m_poMySPINInstance;

      //Variable for checking initialization
      t_Bool m_bIsInitialized;

      //list maintaining Connected devices.
      std::map<t_U32, trMySPINDevInfo> m_mapConnectedDevices;

      //Maintain a mySPIN context
      trMySPINContext* m_rMySPINContext;

      //MySpin Capabilities
      t_U32  m_MySPINCapabilities;

};
#endif /* _SPI_TCLMYSPINTAVIDEOINTF_H_ */
