/***********************************************************************/
/*!
 * \file  spi_tclMySPINRespSession.h
 * \brief mySPIN Session Output Interface
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    mySPIN Session Output Interface
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                   | Modification
 03.12.2015  | tch5kor                  | Initial Version
 11.04.2016  | Chaitra Srinivasa        | Adding comments

 \endverbatim
 *************************************************************************/

#ifndef SPI_TCLMYSPINRESPSESSION_H_
#define SPI_TCLMYSPINRESPSESSION_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/

#include "RespBase.h"
#include "mySPINTypes.h"
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class spi_tclMySPINRespSession
 * \brief mySPIN Session Output Interface
 *
 * updates all the registered clients, whenever there is
 * an update on mySPIN session
 *
 ****************************************************************************/
class spi_tclMySPINRespSession: public RespBase
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINRespSession::spi_tclMySPINRespSession()
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINRespSession()
       * \brief   Constructor
       * \sa      ~spi_tclMySPINRespSession()
       **************************************************************************/
      spi_tclMySPINRespSession() :
         RespBase(e16MYSPIN_SESSION_REGID)
      {

      }

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINRespSession::~spi_tclMySPINRespSession()
       ***************************************************************************/
      /*!
       * \fn      virtual ~spi_tclMySPINRespSession()
       * \brief   Destructor
       * \param   t_Void
       * \sa      spi_tclMySPINRespSession(RegID enRegId)
       **************************************************************************/
      virtual ~spi_tclMySPINRespSession()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINRespSession::vLauncherAppInactiveCb()
       ***************************************************************************/
      /*!
       * \fn      vLauncherAppInactiveCb
       * \brief   Informs the current state of launcher app
       * \param   bIsInActive : Laumcher App is active or not.
       * \param   u32DeviceHandle : Device Handle
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vLauncherAppInactiveCb(t_Bool bIsInActive)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINRespSession::vAppTransitionCb()
       ***************************************************************************/
      /*!
       * \fn      vAppTransitionCb
       * \brief   Informs the current state of App Transition
       * \param   bIsActive : Transition is active or not.
       * \param   u32DeviceHandle : Device Handle
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vAppTransitionCb(t_Bool bIsInActive)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINRespSession::vInitiateCallCb()
       ***************************************************************************/
      /*!
       * \fn      vInitiateCallCb
       * \brief   Informs the current state of App Transition
       * \param   bIsActive : Transition is active or not.
       * \param   u32DeviceHandle : Device Handle
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vInitiateCallCb(t_String szTelePhoneNum, t_String szDisplayText)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINRespSession::vBTProfileInfoCb()
       ***************************************************************************/
      /*!
       * \fn      vBTProfileInfoCb
       * \brief   Informs the current state of App Transition
       * \param   bIsActive : Transition is active or not.
       * \param   u32DeviceHandle : Device Handle
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vBTProfileInfoCb(const t_U32 cou32DeviceHandle, t_Bool bIsHFP, t_Bool bIsA2DP,
               t_String szFriendlyName = "")
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINRespSession::vVoiceSessionCb()
       ***************************************************************************/
      /*!
       * \fn      vVoiceSessionCb
       * \brief   Informs the request from Phone
       * \param   enMySPINVoiceSessionReq : Voice Session Request
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vVoiceSessionCb(tenMySPINVoiceSessionReq enMySPINVoiceSessionReq)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINRespSession::vMySPINSessionErrorCb(tenErrorCode enErrorCode)
       ***************************************************************************/
      /*!
       * \fn      vMySPINSessionErrorCb
       * \brief   Informs the mySPIN Error from Phone
       * \param   enErrorCode : [IN] Error code
       * \sa
       **************************************************************************/
      virtual t_Void vMySPINSessionErrorCb( const t_U32 cou32DeviceHandle, tenMySPINError enErrorCode)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINRespSession::vMySPINPTTAvailableCb(t_Bool bIsPTTAvail)
       ***************************************************************************/
      /*!
       * \fn      vMySPINPTTAvailableCb
       * \brief   Informs whether mySPIN PTT is available from Phone
       * \param   bIsPTTAvail : PTT available status
       * \sa
       **************************************************************************/
      virtual t_Void vMySPINPTTAvailableCb(t_Bool bIsPTTAvail)
      {
      }      

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINRespSession::vPostBTStateUpdate(t_Bool bIsBTConn)
       ***************************************************************************/
      /*!
       * \fn      vPostBTStateUpdate
       * \brief   Informs whether BT is connected or not
       * \sa
       **************************************************************************/
      virtual t_Void vPostBTStateUpdate()
      {

      }

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINRespSession::spi_tclMySPINRespSession()
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINRespSession(
       *                          const spi_tclMySPINRespSession& corfoSrc))
       * \brief   Parameterized Constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \sa      spi_tclMySPINRespSession(RegID enRegId)
       **************************************************************************/
      spi_tclMySPINRespSession(const spi_tclMySPINRespSession& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINRespSession& operator=( const spi_tclMLV...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINRespSession& operator=(
       *                          const spi_tclMySPINRespSession& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINRespSession(const spi_tclMySPINRespSession& otrSrc)
       ***************************************************************************/
      spi_tclMySPINRespSession& operator=(const spi_tclMySPINRespSession& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

};

#endif /* SPI_TCLMYSPINRESPSESSION_H_ */
