/***********************************************************************/
/*!
 * \file  spi_tclMySPINCmdSession.h
 * \brief  Implementation of the Class spi_tclMySPINCmdSession
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         grikor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 11.04.2016  | Chaitra Srinivasa     | Adding comments

 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLMYSPINCMDSESSION_H_
#define _SPI_TCLMYSPINCMDSESSION_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

class spi_tclMySPINCmdSession
{

   public:

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::spi_tclMySPINCmdSession()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINCmdSession()
       * \brief Constructor for spi_tclMySPINCmdSession class
       **************************************************************************/
      spi_tclMySPINCmdSession();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::~spi_tclMySPINCmdSession()
       ***************************************************************************/
      /*!
       * \fn    ~spi_tclMySPINCmdSession()
       * \brief Destructor for spi_tclMySPINCmdSession class
       **************************************************************************/
      ~spi_tclMySPINCmdSession();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::t_Bool bInitialize()
       ***************************************************************************/
      /*!
       * \fn    t_Bool bInitialize()
       * \brief Method used for initialization
       * \retval t_Bool
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::t_Bool vUnInitialize()
       ***************************************************************************/
      /*!
       * \fn    t_Void vUnInitialize()
       * \brief Method used for uninitialization
       * \retval t_Void
       **************************************************************************/
      t_Void vUnInitialize();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::tenErrorCode enInitMySPINSession(...)
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enInitMySPINSession(t_U32 u32DevId,
       *                                    tenDeviceSubCategory enDevSubCat,
       *                                    const trMySPINDevInfo& corfrDevInfo,
       *                                    const trMySPINAccInfo& corfrAccInfo,
       *                                    t_Bool& rfbDevAudioSupport)
       * \brief Method for initializing MySPIN session
       * \param u32DevId: [IN]Device ID
       * \param enDevSubCat: [IN]Used for storing Device sub category
       * \param corfrDevInfo: [IN]Used for storing device info
       * \param corfrAccInfo: [IN]Used for storing MySPIN accessory info
       * \param rfbDevAudioSupport: [IN]Used for storing value which tells whether
       *                           device audio is supported or not
       * \retval tenErrorCode
       **************************************************************************/
      tenErrorCode enInitMySPINSession(t_U32 u32DevId, tenDeviceSubCategory enDevSubCat,
               const trMySPINDevInfo& corfrDevInfo, const trMySPINAccInfo& corfrAccInfo, t_Bool& rfbDevAudioSupport);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::tenErrorCode enUninitMySPINSession()
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enUninitMySPINSession(t_U32 u32DevId,
       *                                     tenDeviceSubCategory enDevSubCat)
       * \brief Method used to uninitialize the MySPIN session
       * \param u32DevId: [IN]Device ID
       * \param enDevSubCat: [IN]Used for storing device sub catergory
       * \retval tenErrorCode
       **************************************************************************/
      tenErrorCode enUninitMySPINSession(t_U32 u32DevId, tenDeviceSubCategory enDevSubCat);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::tenErrorCode enSessionStart()
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enSessionStart(t_U32 u32DevId,
       *                               tenDeviceSubCategory enDevSubCat)
       * \brief Method for starting a session
       * \param u32DevId: [IN]Device ID
       * \param enDevSubCat: [IN]Used for storing device sub catergory
       * \retval tenErrorCode
       **************************************************************************/
      tenErrorCode enSessionStart(t_U32 u32DevId, tenDeviceSubCategory enDevSubCat);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::t_Void vSessionStop()
       ***************************************************************************/
      /*!
       * \fn    t_Void vSessionStop(t_U32 u32DevId,
       *                         tenDeviceSubCategory enDevSubCat)
       * \brief Method to stop the session
       * \param u32DevId: [IN]Device ID
       * \param enDevSubCat: [IN]Used for storing device sub catergory
       * \retval t_Void
       **************************************************************************/
      t_Void vSessionStop(t_U32 u32DevId, tenDeviceSubCategory enDevSubCat);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::t_Void vUpdateVoiceSessionStatus()
       ***************************************************************************/
      /*!
       * \fn    t_Void vUpdateVoiceSessionStatus(t_U32 u32DevID,
       *                             tenBTVoiceSessionStatus enBTVoiceSessionStatus)
       * \brief Method to update the voice session status
       * \param u32DevId: [IN]Device ID
       * \param enBTVoiceSessionStatus: [IN]Used for storing BT voice session status
       * \retval t_Void
       **************************************************************************/
      t_Void vUpdateVoiceSessionStatus(t_U32 u32DevID, tenBTVoiceSessionStatus enBTVoiceSessionStatus);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::t_Void vGetAppCapability()
       ***************************************************************************/
      /*!
       * \fn    t_Void vGetAppCapability(tenAppCapability enAppCapability)
       * \brief Method to retrieve mySPIN launcher app capability
       * \param enAppCapability: [IN] Application Capability
       * \retval t_Void
       **************************************************************************/
      t_Void vGetAppCapability(tenAppCapability& enAppCapability);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINCmdSession::vSendVREndResponse(...
       ***************************************************************************/
      /*!
       * \fn     vSendVREndResponse()
       * \brief  Method to send VR response to phone
       * \param  u32DeviceHandle: Device ID
       * \param  enBTVoiceSessionStatus: VR session status
       * \param  enVRState: VR state
       * \retval t_Void
       **************************************************************************/
      t_Void vSendVREndResponse(t_U32 u32DeviceHandle,tenBTVoiceSessionStatus enBTVoiceSessionStatus,
                                tenMspinVRStatus enVRState);

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINCmdSession(const spi_tclMySPINCmdSession...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINCmdSession(
       *                             const spi_tclMySPINCmdSession& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       ***************************************************************************/
      spi_tclMySPINCmdSession(const spi_tclMySPINCmdSession& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINCmdSession& operator=( const spi_tcl...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINCmdSession& operator=(
       *                          const spi_tclMySPINCmdSession& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       ***************************************************************************/
      spi_tclMySPINCmdSession& operator=(const spi_tclMySPINCmdSession& otrSrc);

   private:
      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::t_Void vAppInactiveCallback()
       ***************************************************************************/
      /*!
       * \fn    t_Void vAppInactiveCallback(t_Void *poContext,
       *                                    t_Bool bIsInActive)
       * \brief Call back for inactive application
       * \param poContext: [IN]Pointer for context
       * \param bIsInActive: [IN]Used to check whether app is active/inactive
       * \retval t_Void
       **************************************************************************/
      static t_Void vAppInactiveCallback(t_Void *poContext, t_Bool bIsInActive);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::t_Void vAppTransitionStatusCallback()
       ***************************************************************************/
      /*!
       * \fn    t_Void vAppTransitionStatusCallback(t_Void *poContext,
       *                                            t_Bool bIsActive)
       * \brief Call back for app transition status
       * \param poContext: [IN]Pointer for context
       * \param bIsActive: [IN]Used to check whether app is active/inactive
       * \retval t_Void
       **************************************************************************/
      static t_Void vAppTransitionStatusCallback(t_Void *poContext, t_Bool bIsActive);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::t_Void vCustomDataIntCallback()
       ***************************************************************************/
      /*!
       * \fn    t_Void vCustomDataIntCallback(t_Void *poContext,
       *                            MSPIN_PHONEMSGINTTYPE enPhoneStringType,
       *                            t_S64 s64Data)
       * \brief Call back for custom data initialization
       * \param poContext: [IN]Pointer for context
       * \param enPhoneStringType: [IN]Used for storing phone string type
       * \param s64Data: [IN]Used for storing data
       * \retval t_Void
       **************************************************************************/
      static t_Void vCustomDataIntCallback(t_Void *poContext, MSPIN_PHONEMSGINTTYPE enPhoneStringType, t_S64 s64Data);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::t_Void vCustomDataStringCallback()
       ***************************************************************************/
      /*!
       * \fn    t_Void vCustomDataStringCallback(t_Void *poContext,
       *                                  MSPIN_PHONEMSGSTRTYPE enPhoneStringType,
       *                                  MSPIN_STRINGENCODING enEncoding,
       *                                  t_Char *pczData)
       * \brief  Call back for custom data string
       * \param poContext: [IN]Pointer for context
       * \param enPhoneStringType: [IN]Used for storing phone string type
       * \param enEncoding: [IN]Used for storing encoding value
       * \param pczData: [IN]Pointer for storing data
       * \retval t_Void
       **************************************************************************/
      static t_Void vCustomDataStringCallback(t_Void *poContext, MSPIN_PHONEMSGSTRTYPE enPhoneStringType,
               MSPIN_STRINGENCODING enEncoding, t_Char *pczData);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::t_Void vInitiatePhoneCallCallback()
       ***************************************************************************/
      /*!
       * \fn    t_Void vInitiatePhoneCallCallback(t_Void *poContext,
       *                                  t_Char *pczNumberString,
       *                                  t_Char *pczDisplayString)
       * \brief Call back for initializing phone call
       * \param poContext: [IN]Pointer for context
       * \param pczNumberString: [IN]Pointer for number string
       * \param pczDisplayString: [IN]Pointer for display string
       * \retval t_Void
       **************************************************************************/
      static t_Void vInitiatePhoneCallCallback(t_Void *poContext, t_Char *pczNumberString, t_Char *pczDisplayString);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::t_Void vMyspinErrorCallback()
       ***************************************************************************/
      /*!
       * \fn    t_Void vMyspinErrorCallback(t_Void *poContext,
       *                                  MSPIN_ERROR enErrorCode)
       * \brief Call back for MySPIN error
       * \param poContext: [IN]Pointer for context
       * \param enErrorCode: [IN]Used for storing the error code
       * \retval t_Void
       **************************************************************************/
      static t_Void vMyspinErrorCallback(t_Void *poContext, MSPIN_ERROR enErrorCode);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::t_Void PhoneCallStatusCallback()
       ***************************************************************************/
      /*!
       * \fn    t_Void PhoneCallStatusCallback(t_Void *poContext,
       *                                       t_Bool bIsActive)
       * \brief Callback for phone call status
       * \param poContext: [IN]Pointer for context
       * \param bIsActive: [IN]Used for checking whether phone call active or not
       * \retval t_Void
       **************************************************************************/
      static t_Void PhoneCallStatusCallback(t_Void *poContext, t_Bool bIsActive);
      
      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::t_Void vPTTAvailableCallback()
       ***************************************************************************/
      /*!
       * \fn    t_Void vPTTAvailableCallback(t_Void *poContext,
       *                                       t_Bool bIsPttAvail)
       * \brief Callback for PTT available status
       * \param poContext: [IN]Pointer for context
       * \param bIsPttAvail: [IN]Used for checking whether ptt feature is available or not
       * \retval t_Void
       **************************************************************************/      
      static t_Void vPTTAvailableCallback(t_Void *poContext, t_Bool bIsPttAvail);      

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdSession::t_Void vVoiceSessionCallback()
       ***************************************************************************/
      /*!
       * \fn    t_Void vVoiceSessionCallback(t_Void *poContext,
       *                                MSPIN_VOICESESSION_REQUESTTYPE requestType)
       * \brief Call back for voice session
       * \param poContext: [IN]Pointer for context
       * \param requestType: [IN]Used for storing the type of the request
       * \retval t_Void
       **************************************************************************/
      static t_Void vVoiceSessionCallback(t_Void *poContext, MSPIN_VOICESESSION_REQUESTTYPE requestType);

      //BT Voice Session
      tenBTVoiceSessionStatus m_enBTVoiceSessionStatus;

      //Advanced Audio Support
      t_Bool m_bAdvAudioSupported;
      
      tenMySPINError m_enMySPINError;

};

#endif // #ifndef _SPI_TCLMYSPINCMDSESSION_H_
