/***********************************************************************/
/*!
 * \file  spi_tclMySPINCmdInput.h
 * \brief  Implementation of the Class spi_tclMySPINCmdInput
 *************************************************************************
 \verbatim


 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MYSPINWRAPPER
#include "trcGenProj/Header/spi_tclMySPINCmdInput.cpp.trc.h"
#endif
#endif
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
#include "BaseTypes.h"
#include "spi_tclMySPINCmdInput.h"
#include "spi_tclMySPINTAVideoIntf.h"
#include "spi_tclMySPINTADataIntf.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
static trMySPINKeys aMySPINKeys[] { { e32DEV_HOME, e8MSPIN_KEY_HOME } };
static trMySPINCustKeys aMySPINCustKeys[] {{e32DEV_PTT, e8MSPIN_PTT}, {e32TWODKNOB0_SHIFT_UP, e8MSPIN_DPADUP}, {e32TWODKNOB0_SHIFT_DOWN, e8MSPIN_DPADDOWN},
        {e32TWODKNOB0_SHIFT_LEFT, e8MSPIN_DPADLEFT}, {e32TWODKNOB0_SHIFT_RIGHT, e8MSPIN_DPADRIGHT}, {e32DEV_BACKWARD, e8MSPIN_BACKWARD}, {e32DEV_MENU, e8MSPIN_OK}};
/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION: spi_tclMySPINCmdInput::spi_tclMySPINCmdInput()
 ***************************************************************************/
spi_tclMySPINCmdInput::spi_tclMySPINCmdInput()
{

   ETG_TRACE_USR1(("spi_tclMySPINCmdInput::spi_tclMySPINCmdInput()"));

   for (t_U32 u32KeyIndex = 0; u32KeyIndex < ((sizeof(aMySPINKeys)) / sizeof(trMySPINKeys)); ++u32KeyIndex)
   {
      m_MySPINKeyMap.insert(std::pair<tenKeyCode, tenMySPINKeyCode>(aMySPINKeys[u32KeyIndex].enKeyCode,
               aMySPINKeys[u32KeyIndex].enMySPINKeyCode));
   }
   for (t_U32 u32KeyIndex = 0; u32KeyIndex < ((sizeof(aMySPINCustKeys)) / sizeof(trMySPINCustKeys)); ++u32KeyIndex)
   {
      m_MySPINCustomKeyMap.insert(std::pair<tenKeyCode, tenMySPINCustomKeyCode>(aMySPINCustKeys[u32KeyIndex].enKeyCode,
               aMySPINCustKeys[u32KeyIndex].enMySPINCustomKeyCode));
   }
}

/***************************************************************************
 ** FUNCTION: spi_tclMySPINCmdInput::~spi_tclMySPINCmdInput()
 ***************************************************************************/
spi_tclMySPINCmdInput::~spi_tclMySPINCmdInput()
{
   ETG_TRACE_USR1(("spi_tclMySPINCmdInput::~spi_tclMySPINCmdInput()"));
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclMySPINCmdInput::bInitialize()
 ***************************************************************************/
t_Bool spi_tclMySPINCmdInput::bInitialize()
{

   return true;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINCmdInput::vUninitialize()
 ***************************************************************************/
t_Void spi_tclMySPINCmdInput::vUninitialize()
{

}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINCmdInput::vGetSupportedKeys()
 ***************************************************************************/
t_U32 spi_tclMySPINCmdInput::vGetSupportedKeys(t_U32 u32DeviceHandle)
{
   spi_tclMySPINTADataIntf oTADataIntf;

   spi_tclMySPINTAVideoIntf* poMySPINTAVideoIntf = oTADataIntf.poGetTAVideoIntfInst();
   t_U32 u32SupportedKeys = 0;

   if (NULL != poMySPINTAVideoIntf)
   {
      u32SupportedKeys = poMySPINTAVideoIntf->u32GetSupportedKeys(u32DeviceHandle);
   }

   return u32SupportedKeys;
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINCmdInput::vSendKeyEvent()
 ***************************************************************************/
t_Void spi_tclMySPINCmdInput::vSendKeyEvent(t_U32 u32DeviceHandle, tenKeyMode enKeyMode, tenKeyCode enKeyCode)
{
   spi_tclMySPINTADataIntf oTADataIntf;

   spi_tclMySPINTAVideoIntf* poMySPINTAVideoIntf = oTADataIntf.poGetTAVideoIntfInst();

   if (NULL != poMySPINTAVideoIntf)
   {
      std::map<tenKeyCode, tenMySPINKeyCode>::const_iterator itrMySPINKeyCode;
      itrMySPINKeyCode = m_MySPINKeyMap.find(enKeyCode);

      if (m_MySPINKeyMap.end() != itrMySPINKeyCode)
      {
         poMySPINTAVideoIntf->vSendKeyEvent(u32DeviceHandle, enKeyMode, itrMySPINKeyCode->second);
      }
   }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINCmdInput::vSendCustomKeyEvent()
 ***************************************************************************/
t_Void spi_tclMySPINCmdInput::vSendCustomKeyEvent(t_U32 u32DeviceHandle, 
                                                  tenMySPINCustomKeyMode enCustomKeyMode, 
                                                  tenKeyCode enKeyCode)
{
   spi_tclMySPINTADataIntf oTADataIntf;

   spi_tclMySPINTAVideoIntf* poMySPINTAVideoIntf = oTADataIntf.poGetTAVideoIntfInst();

   if (NULL != poMySPINTAVideoIntf)
   {
      std::map<tenKeyCode, tenMySPINCustomKeyCode>::const_iterator itrMySPINKeyCode;
      itrMySPINKeyCode = m_MySPINCustomKeyMap.find(enKeyCode);

      if (m_MySPINCustomKeyMap.end() != itrMySPINKeyCode)
      {
         ETG_TRACE_USR4(("[PARAM]:vSendCustomKeyEvent::vSendCustomKeyEvent() found key %d",itrMySPINKeyCode->second));
         poMySPINTAVideoIntf->vSendCustomKeyEvent(u32DeviceHandle, enCustomKeyMode, itrMySPINKeyCode->second);
      }
   }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINCmdInput::vSendKnobKeyEvent()
 ***************************************************************************/
t_Void spi_tclMySPINCmdInput::vSendKnobKeyEvent(t_U32 u32DeviceHandle, t_S8 s8EncoderDeltaCnt)
{
   spi_tclMySPINTADataIntf oTADataIntf;

   spi_tclMySPINTAVideoIntf* poMySPINTAVideoIntf = oTADataIntf.poGetTAVideoIntfInst();
   if (NULL != poMySPINTAVideoIntf)
   {
       if(s8EncoderDeltaCnt>0)
       {
           for(t_S8 i=1; i<=s8EncoderDeltaCnt; i++)
           {
               poMySPINTAVideoIntf->vSendCustomKeyEvent(u32DeviceHandle, e8MSPIN_CUSTOMDATA_KEYTYPE_CLICK, e8MSPIN_KNOBTICKCW);
           }
       }
       else
       {
           for(t_S8 i=-1; i>=s8EncoderDeltaCnt; i--)
           {
               poMySPINTAVideoIntf->vSendCustomKeyEvent(u32DeviceHandle, e8MSPIN_CUSTOMDATA_KEYTYPE_CLICK, e8MSPIN_KNOBTICKCCW);
           }
       }
   }
}
//lint restore
///////////////////////////////////////////////////////////////////////////////
// <EOF>

