/***********************************************************************/
/*!
* \file  spi_tclAOAPRespDiscoverer.h
* \brief AAP Discoverer Output Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    AAP Discoverer Output Interface
AUTHOR:         gri2kor
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                   | Modification
11.04.2016  | Chaitra Srinivasa        | Adding comments
\endverbatim
*************************************************************************/

#ifndef SPI_TCLAOAPRESPDISCOVERER_H_
#define SPI_TCLAOAPRESPDISCOVERER_H_

#include "RespBase.h"
#include "mySPINTypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclAOAPRespDiscoverer
* \brief 
*
****************************************************************************/
class spi_tclAOAPRespDiscoverer:public RespBase
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclAOAPRespDiscoverer::spi_tclAOAPRespDiscoverer()
   ***************************************************************************/
   /*!
   * \fn      spi_tclAOAPRespDiscoverer()
   * \brief   Constructor
   * \sa      ~spi_tclAOAPRespDiscoverer()
   **************************************************************************/
   spi_tclAOAPRespDiscoverer():RespBase(e16AOAP_DISC_REGID){}

   /***************************************************************************
   ** FUNCTION:  spi_tclAOAPRespDiscoverer::~spi_tclAOAPRespDiscoverer()
   ***************************************************************************/
   /*!
   * \fn      virtual ~spi_tclAOAPRespDiscoverer()
   * \brief   Destructor
   * \param   t_Void
   * \sa      spi_tclAOAPRespDiscoverer(RegID enRegId)
   **************************************************************************/
   virtual ~spi_tclAOAPRespDiscoverer(){}

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAOAPRespDiscoverer::vOnDeviceConnected()
   ***************************************************************************/
   /*!
   * \fn      t_Void vOnDeviceConnected
   * \brief   Method called on device connection
   * \param   corfrMySPINDevInfo: [IN]structure for MySPIN device info
   * \retval  t_Void
   * \sa      
   ***************************************************************************/
   virtual t_Void vOnDeviceConnected(const trMySPINDeviceInfo& corfrMySPINDevInfo){}

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAOAPRespDiscoverer::vOnDeviceDisconnected()
   ***************************************************************************/
   /*!
   * \fn      t_Void vOnDeviceDisconnected
   * \brief   Method called on device disconnection
   * \param   u32DevID: [IN]Device ID
   * \retval  t_Void
   * \sa      
   ***************************************************************************/
   virtual t_Void vOnDeviceDisconnected(t_U32 u32DevID){}

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclAOAPRespDiscoverer::spi_tclAOAPRespDiscoverer()
   ***************************************************************************/
   /*!
   * \fn      spi_tclAOAPRespDiscoverer(
   *                          const spi_tclAOAPRespDiscoverer& corfoSrc))
   * \brief   Parameterized Constructor
   * \param   corfoSrc : [IN] reference to source data interface object
   * \sa      spi_tclAOAPRespDiscoverer(RegID enRegId)
   **************************************************************************/
   spi_tclAOAPRespDiscoverer(const spi_tclAOAPRespDiscoverer& corfoSrc);

   /***************************************************************************
   ** FUNCTION:  spi_tclAOAPRespDiscoverer& operator=( const spi_tclMLV...
   ***************************************************************************/
   /*!
   * \fn      spi_tclAOAPRespDiscoverer& operator=(
   *                          const spi_tclAOAPRespDiscoverer& corfoSrc))
   * \brief   Assignment operator
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclAOAPRespDiscoverer(const spi_tclAOAPRespDiscoverer& otrSrc)
   ***************************************************************************/
   spi_tclAOAPRespDiscoverer& operator=(const spi_tclAOAPRespDiscoverer& corfoSrc);


   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

};

#endif /* SPI_TCLAOAPRESPDISCOVERER_H_ */
