/***********************************************************************/
/*!
 * \file  spi_tclAOAPDiscovererDispatcher.h
 * \brief Message Dispatcher for Discoverer Messages. implemented using
 *       double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Discoverer Messages
 AUTHOR:         gri2kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification


 \endverbatim
 *************************************************************************/
#ifndef SPI_TCLAOAPDISCOVERERDISPATCHER_H_
#define SPI_TCLAOAPDISCOVERERDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "mySPINTypes.h"
#include "RespRegister.h"

/**************Forward Declarations******************************************/
class spi_tclAOAPDiscovererDispatcher;

/****************************************************************************/
/*!
 * \class AOAPDiscMsgBase
 * \brief Base Message type for all Discoverer messages
 ****************************************************************************/
class AOAPDiscMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  AOAPDiscMsgBase::AOAPDiscMsgBase
       ***************************************************************************/
      /*!
       * \fn      MySPINDiscMsgBase()
       * \brief   Default constructor
       **************************************************************************/
       AOAPDiscMsgBase();

      /***************************************************************************
       ** FUNCTION:  AOAPDiscMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclAOAPDiscovererDispatcher* poDiscovererDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param poDiscovererDispatcher : pointer to Message dispatcher for Discoverer
       * \retval t_Void
       **************************************************************************/
       virtual t_Void vDispatchMsg(
               spi_tclAOAPDiscovererDispatcher* poDiscovererDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  AOAPDiscMsgBase::~AOAPDiscMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~AOAPDiscMsgBase()
       * \brief   Destructor
       **************************************************************************/
       virtual ~AOAPDiscMsgBase()
       {

       }

      /***************************************************************************
       ** FUNCTION:  AOAPDiscMsgBase::u32GetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      u32GetDeviceHandle()
       * \brief   returns the device handle
       * \retval t_U32
       **************************************************************************/
       virtual t_U32 u32GetDeviceHandle(){return m_u32DeviceHandle;}

      /***************************************************************************
       ** FUNCTION:  AOAPDiscMsgBase::vSetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn     vSetDeviceHandle()
       * \brief  sets the device handle
       * \retval t_Void
       **************************************************************************/
       virtual t_Void vSetDeviceHandle(const t_U32 cou32DevHndle) {m_u32DeviceHandle = cou32DevHndle;};

   private:
      t_U32 m_u32DeviceHandle;
};


/****************************************************************************/
/*!
 * \class DeviceInfoMsg
 * \brief Discoverer attestation response message
 ****************************************************************************/
class DeviceInfoMsg: public AOAPDiscMsgBase
{
   public:

      trMySPINDeviceInfo *m_prDeviceInfo;

      /***************************************************************************
       ** FUNCTION:  DeviceInfoMsg::DeviceInfoMsg
       ***************************************************************************/
      /*!
       * \fn      DeviceInfoMsg()
       * \brief   Default constructor
       **************************************************************************/
       DeviceInfoMsg();

      /***************************************************************************
       ** FUNCTION:  DeviceInfoMsg::~DeviceInfoMsg
       ***************************************************************************/
      /*!
       * \fn      ~DeviceInfoMsg()
       * \brief   Destructor
       **************************************************************************/
       virtual ~DeviceInfoMsg(){}

      /***************************************************************************
       ** FUNCTION:  DeviceInfoMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclAOAPDiscovererDispatcher* poDiscovererDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  poDiscovererDispatcher : pointer to Message dispatcher for Discoverer
      * \retval t_Void
       **************************************************************************/
       t_Void vDispatchMsg(spi_tclAOAPDiscovererDispatcher* poDiscovererDispatcher);

      /***************************************************************************
       ** FUNCTION:  DeviceInfoMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial data types (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval  t_Void
       **************************************************************************/
       t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  DeviceInfoMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       * \retval  t_Void
       **************************************************************************/
       t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class DeviceDisconnectInfoMsg
 * \brief Discoverer attestation response message
 ****************************************************************************/
class DeviceDisconnectInfoMsg: public AOAPDiscMsgBase
{
   public:


      /***************************************************************************
       ** FUNCTION:  DeviceDisconnectInfoMsg::DeviceDisconnectInfoMsg
       ***************************************************************************/
      /*!
       * \fn      DeviceDisconnectInfoMsg()
       * \brief   Default constructor
       **************************************************************************/
       DeviceDisconnectInfoMsg();

      /***************************************************************************
       ** FUNCTION:  DeviceDisconnectInfoMsg::~DeviceDisconnectInfoMsg
       ***************************************************************************/
      /*!
       * \fn      ~DeviceDisconnectInfoMsg()
       * \brief   Destructor
       **************************************************************************/
       virtual ~DeviceDisconnectInfoMsg(){}

      /***************************************************************************
       ** FUNCTION:  DeviceDisconnectInfoMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclAOAPDiscovererDispatcher* poDiscovererDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poDiscovererDispatcher : pointer to Message dispatcher for Discoverer
       * \retval t_Void
       **************************************************************************/
       t_Void vDispatchMsg(spi_tclAOAPDiscovererDispatcher* poDiscovererDispatcher);

      /***************************************************************************
       ** FUNCTION:  DeviceDisconnectInfoMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial data types (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval  t_Void
       **************************************************************************/
       t_Void vAllocateMsg(){}

      /***************************************************************************
       ** FUNCTION:  DeviceDisconnectInfoMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       * \retval  t_Void
       **************************************************************************/
       t_Void vDeAllocateMsg(){}
};


/****************************************************************************/
/*!
 * \class spi_tclAOAPDiscovererDispatcher
 * \brief Message Dispatcher for Discoverer Messages
 ****************************************************************************/
class spi_tclAOAPDiscovererDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclAOAPDiscovererDispatcher::spi_tclAOAPDiscovererDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclAOAPDiscovererDispatcher()
       * \brief   Default constructor
       **************************************************************************/
       spi_tclAOAPDiscovererDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclAOAPDiscovererDispatcher::~spi_tclAOAPDiscovererDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclAOAPDiscovererDispatcher()
       * \brief   Destructor
       **************************************************************************/
       ~spi_tclAOAPDiscovererDispatcher();


      /***************************************************************************
       ** FUNCTION:  spi_tclAOAPDiscovererDispatcher::vHandleDiscovererMsg(DeviceInfoMsg* poDeviceInfoMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleDiscovererMsg(DeviceInfoMsg* poDeviceInfoMsg)
       * \brief   Handles Messages of DeviceInfoMsg type
       * \param   poLaunchDiscovererMsg : pointer to DeviceInfoMsg.
       * \retval  t_Void
       **************************************************************************/
       t_Void vHandleDiscovererMsg(DeviceInfoMsg* poDeviceInfoMsg)const;

      /***************************************************************************
       ** FUNCTION:  spi_tclAOAPDiscovererDispatcher::vHandleDiscovererMsg(DeviceDisconnectInfoMsg* poDeviceInfoMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleDiscovererMsg(DeviceDisconnectInfoMsg* poDeviceDisconnectInfoMsg)
       * \brief   Handles Messages of DeviceInfoMsg type
       * \param   poLaunchDiscovererMsg : pointer to DeviceInfoMsg.
       * \retval  t_Void
       **************************************************************************/
      t_Void vHandleDiscovererMsg(DeviceDisconnectInfoMsg* poDeviceDisconnectInfoMsg)const;


};

#endif /* SPI_TCLAOAPDISCOVERERDISPATCHER_H_ */
