/***********************************************************************/
/*!
 * \file  spi_tclMySPINTAVideoIntf.h
 * \brief  Implementation of the Class spi_tclMySPINTAVideoIntf
 *************************************************************************
 \verbatim


 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 11.04.2016  | Chaitra Srinivasa     | Adding comments
 \endverbatim
 *************************************************************************/
#include "mySPINTypes.h"
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/
#ifndef _SPI_TCLMYSPINTAVIDEOINTF_H_
#define _SPI_TCLMYSPINTAVIDEOINTF_H_

class spi_tclMySPINTAVideoIntf
{

   public:
      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVideoIntf::tenErrorCode enStartVideoPlayback(...)
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enStartVideoPlayback(t_U32 u32DeviceHandle)
       * \brief Method called to start the video playback
       * \param u32DeviceHandle: [IN]Unique device handle
       * \retval tenErrorCode
       **************************************************************************/
      virtual tenErrorCode enStartVideoPlayback(t_U32 u32DeviceHandle) = 0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVideoIntf::tenErrorCode enStopVideoPlayback(...)
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enStopVideoPlayback(t_U32 u32DeviceHandle)
       * \brief Method called to stop the video playback
       * \param u32DeviceHandle: [IN]Unique device handle
       * \retval tenErrorCode
       **************************************************************************/
      virtual tenErrorCode enStopVideoPlayback(t_U32 u32DeviceHandle)= 0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVideoIntf::t_Void vPumpEvents(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vPumpEvents(t_U32 u32DevID,t_S32 s32TimeOut)
       * \brief Method called to pump the events
       * \param u32DevID: [IN]Device ID
       * \param s32TimeOut: [IN]String for storing time out value
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vPumpEvents(t_U32 u32DevID, t_S32 s32TimeOut)= 0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVideoIntf::t_Void vSendKeyEvent(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSendKeyEvent(t_U32 u32DeviceHandle,
       *                             tenKeyMode enKeyMode,
       *                             tenMySPINKeyCode enMySPINKeyCode)
       * \brief Method used to send a key event
       * \param u32DeviceHandle: [IN]Device handle
       * \param enKeyMode: [IN]To store key mode
       * \param enMySPINKeyCode: [IN]To store MySPIN key code
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSendKeyEvent(t_U32 u32DeviceHandle, tenKeyMode enKeyMode, tenMySPINKeyCode enMySPINKeyCode)= 0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVideoIntf::t_Void vSetWaylandTouch(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetWaylandTouch(t_U32 u32DeviceHandle,
       *                                t_Bool bIsWayland)
       * \brief Method to set the values for Wayland touch
       * \param u32DeviceHandle: [IN]Device handle
       * \param bIsWayland: [IN]Used to store the value of whether wayland touch
       *                        is used or not
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSetWaylandTouch(t_U32 u32DeviceHandle, t_Bool bIsWayland) = 0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVideoIntf::t_Void vSetFrameProperties(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetFrameProperties(t_U32 u32DeviceHandle,
       *                                   t_U32 u32LayerId,
       *                                   t_U32 u32SurfaceId,
       *                                   t_U32 u32WidthInPixels,
       *                                   t_U32 u32HeightInPixels,
       *                                   t_U32 u32WidthInMm,
       *                                   t_U32 u32HeightInMm,
       *                                   MSPIN_PIXEL_FORMAT enPixelFormat,
       *                                   MSPIN_FRAME_COMPRESSION  enPixelCompression,
       *                                   t_U32 u32PreferredCompression)
       * \brief Method used to set the frame properties
       * \param u32DeviceHandle: [IN]Device handle
       * \param u32LayerId: [IN]To store layer ID
       * \param u32SurfaceId: [IN]To store surface ID
       * \param u32WidthInPixels: [IN]To store width in pixels
       * \param u32HeightInPixels: [IN]To store height in pixels
       * \param u32WidthInMm: [IN]To store width in mm
       * \param u32HeightInMm: [IN]To store height in mm
       * \param enPixelFormat: [IN]To store the pixel format
       * \param enPixelCompression: [IN]To store the pixel compression
       * \param u32PreferredCompression: [IN]To store the preferred compression
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSetFrameProperties(t_U32 u32DeviceHandle, t_U32 u32LayerId, t_U32 u32SurfaceId,
               t_U32 u32WidthInPixels, t_U32 u32HeightInPixels, t_U32 u32WidthInMm, t_U32 u32HeightInMm,
               MSPIN_PIXEL_FORMAT enPixelFormat, MSPIN_FRAME_COMPRESSION enPixelCompression,
               t_U32 u32PreferredCompression)=0;
               
      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVideoIntf::t_Void vSendCustomKeyEvent()
       ***************************************************************************/
      /*!
       * \fn    t_Void vSendCustomKeyEvent(t_U32 u32DeviceHandle, 
       *                          tenMySPINCustomKeyMode enCustomKeyMode, 
       *                          tenMySPINCustomKeyCode enMySPINCustomKeyCode)
       * \brief Method for sending custom keys
       * \param u32DeviceHandle: [IN]Device handle
       * \param enCustomKeyMode: [IN]Custom key mode(myspin)
       * \param enMySPINCustomKeyCode: [IN]Custom Key code
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSendCustomKeyEvent(t_U32 u32DeviceHandle, 
                                 tenMySPINCustomKeyMode enCustomKeyMode, 
                                 tenMySPINCustomKeyCode enMySPINCustomKeyCode) = 0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVideoIntf::t_Void vRegisterVideoCbs(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vRegisterVideoCbs(t_U32 u32DeviceHandle,
       *                                 trMySPINVideoCbs rMySPINVideoCbs)
       * \brief Method used to register the video callbacks
       * \param u32DeviceHandle: [IN]Device handle
       * \param rMySPINVideoCbs: [IN]Structure for storing values of MySPIN
       *                          video callbacks
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vRegisterVideoCbs(t_U32 u32DeviceHandle, trMySPINVideoCbs rMySPINVideoCbs) =0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVideoIntf::t_U32 u32GetSupportedKeys (...)
       ***************************************************************************/
      /*!
       * \fn    t_U32 u32GetSupportedKeys(t_U32 u32DeviceHandle)
       * \brief Method to get the supported keys
       * \param u32DeviceHandle: [IN]Device handle
       * \retval t_U32
       **************************************************************************/
      virtual t_U32 u32GetSupportedKeys(t_U32 u32DeviceHandle) =0;

};
#endif /* _SPI_TCLMYSPINTAVIDEOINTF_H_ */
