/***********************************************************************/
/*!
 * \file  spi_tclMySPINTAVideoIntf.h
 * \brief  Implementation of the Class spi_tclMySPINTAVideoIntf
 *************************************************************************
 \verbatim


 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 11.04.2016  | Chaitra Srinivasa     | Adding comments

 \endverbatim
 *************************************************************************/
#include "mySPINTypes.h"
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/
#ifndef SPI_TCLMYSPINTAVEHICLEDATAINTF_H_
#define SPI_TCLMYSPINTAVEHICLEDATAINTF_H_

/*
 * @brief : Interface to all the vehicle data for mySPIN TA wrapper
 */
class spi_tclMySPINTAVehicleDataIntf
{

   public:
      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVehicleDataIntf::t_Void vSetMovingStatus(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetMovingStatus(t_U32 u32DeviceHandle,
       *                                t_Bool bIsMoving)
       * \brief Method tp set the moving status of a vehicle
       * \param u32DeviceHandle: [IN]Device handle
       * \param bIsMoving: [IN]Used to check whether vehicle is moving or not
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSetMovingStatus(t_U32 u32DeviceHandle, t_Bool bIsMoving) = 0;
      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVehicleDataIntf::t_Void vSetNightMode(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetNightMode(t_U32 u32DeviceHandle,
       *                             t_Bool bIsNight)
       * \brief Method to set the mode as night mode
       * \param u32DeviceHandle: [IN]Device handle
       * \param bIsNight: [IN]Used to check whether it is night mode or not
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSetNightMode(t_U32 u32DeviceHandle, t_Bool bIsNight) = 0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVehicleDataIntf::t_Void vSetVehicleBTMACAddress(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetVehicleBTMACAddress(t_U32 u32DeviceHandle,
       *                                       t_String szVehicleBTAddress)
       * \brief Method to set the vehicle's BT address
       * \param u32DeviceHandle: [IN]Device handle
       * \param szVehicleBTAddress: [IN]String for storing vehicle's BT address
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSetVehicleBTMACAddress(t_U32 u32DeviceHandle, t_String szVehicleBTAddress) = 0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVehicleDataIntf::t_Void vSendVehicleData(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSendVehicleData(t_U32 u32DeviceHandle, t_U32 u32Type, t_String szJsonString)
       * \brief Function to send vehicle data to phone
       * \param u32DeviceHandle: Device handle
       * \param u32Type: Value to sent
       * \param szJsonString: String to be sent
       **************************************************************************/
      virtual t_Void vSendVehicleData(t_U32 u32DeviceHandle, t_U32 u32Type, t_String szJsonString) = 0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVehicleDataIntf::t_Void vSendPositionData(...)
       ***************************************************************************/
      /*! 
       * \fn    t_Void vSendPositionData(t_U32 u32DeviceHandle, t_String szNmeaSentence)
       * \brief Function to send position data
       * \param u32DeviceHandle: Device handle
       * \param szNmeaSentence: Nmea sentence 
       **************************************************************************/
      virtual t_Void vSendPositionData(t_U32 u32DeviceHandle, t_String szNmeaSentence) = 0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVehicleDataIntf::t_Void vRegisterVehicleDataCbs(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vRegisterVehicleDataCbs(t_U32 u32DeviceHandle, trVehicleDataCbs 
       *                            rVehicleDataCbs,t_Bool bIsNativeNavigationEnabled)
       * \brief Function to register for vehicle data callbacks
       * \param u32DeviceHandle: Device handle
       * \param rVehicleDataCbs: Structure for vehicle data callbacks
       * \param bIsNativeNavigationEnabled: Native navi enabled or disabled
       **************************************************************************/
      virtual t_Void vRegisterVehicleDataCbs(t_U32 u32DeviceHandle, trVehicleDataCbs rVehicleDataCbs,t_Bool bIsNativeNavigationEnabled) = 0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAVehicleDataIntf::t_Void vSetVehicleManufactureInfo(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetVehicleManufactureInfo(const t_U32 u32DeviceHandle, t_String 
       *                    szVehicleManufacturerName, t_String szVehicleManufacturerScope)
       * \brief Function to send IVI info to phone
       * \param u32DeviceHandle: Device handle
       * \param u16VehicleType : Vehicle type
       * \param szVehicleManufacturerName: Vehicle manufacturer name
       * \param szVehicleManufacturerScope: Vehicle manufacturer scope
       **************************************************************************/
      virtual t_Void vSetVehicleManufactureInfo(const t_U32 u32DeviceHandle, t_U16 u16VehicleType, t_String szVehicleManufacturerName, t_String szVehicleManufacturerScope) =0;
};
#endif /* SPI_TCLMYSPINTAVEHICLEDATAINTF_H_ */
