/***********************************************************************/
/*!
 * \file  spi_tclMySPINTADataIntf.h
 * \brief  Implementation of the Class spi_tclMySPINCmdSession
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         grikor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 11.04.2016  | Chaitra Srinivasa     | Adding comments
 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLMYSPINTADATAINTF_H_
#define _SPI_TCLMYSPINTADATAINTF_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/
class spi_tclMySPINTAVideoIntf;
class spi_tclMySPINTAConnIntf;
class spi_tclMySPINTAVehicleDataIntf;
class spi_tclMySPINTAAudioIntf;

class spi_tclMySPINTADataIntf
{

   public:

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTADataIntf::spi_tclMySPINTADataIntf()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINTADataIntf()
       * \brief Constructor for spi_tclMySPINTADataIntf class
       **************************************************************************/
      spi_tclMySPINTADataIntf();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTADataIntf::~spi_tclMySPINTADataIntf()
       ***************************************************************************/
      /*!
       * \fn    ~spi_tclMySPINTADataIntf()
       * \brief Destructor for spi_tclMySPINTADataIntf()
       **************************************************************************/
      ~spi_tclMySPINTADataIntf();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTADataIntf::spi_tclMySPINTAVideoIntf* poGetTAVideoIntfInst()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINTAVideoIntf* poGetTAVideoIntfInst()
       * \brief Method to get the TA video interface instance
       * \retval spi_tclMySPINTAVideoIntf
       **************************************************************************/
      spi_tclMySPINTAVideoIntf* poGetTAVideoIntfInst();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTADataIntf::spi_tclMySPINTAConnIntf* poGetTAConnIntfInst()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINTAConnIntf* poGetTAConnIntfInst()
       * \brief Method to get the TA connection interface instance
       * \retval spi_tclMySPINTAVideoIntf
       **************************************************************************/
      spi_tclMySPINTAConnIntf* poGetTAConnIntfInst();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTADataIntf::spi_tclMySPINTAVehicleDataIntf* poGetTAVehDataIntfInst()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINTAVehicleDataIntf* poGetTAVehDataIntfInst()
       * \brief Method to get the TA vehicle data interface instance
       * \retval spi_tclMySPINTAVideoIntf
       **************************************************************************/
      spi_tclMySPINTAVehicleDataIntf* poGetTAVehDataIntfInst();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAAudioIntf::spi_tclMySPINTAAudioIntf* poGetTAAudioIntfInst()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINTAAudioIntf* poGetTAAudioIntfInst()
       * \brief Method to get the TA audio interface instance
       * \retval spi_tclMySPINTAVideoIntf
       **************************************************************************/
      spi_tclMySPINTAAudioIntf* poGetTAAudioIntfInst();

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINTADataIntf(const spi_tclMySPINTADataIntf...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINTADataIntf(
       *                             const spi_tclMySPINTADataIntf& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       ***************************************************************************/
      spi_tclMySPINTADataIntf(const spi_tclMySPINTADataIntf& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINTADataIntf& operator=( const spi_tcl...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINTADataIntf& operator=(
       *                          const spi_tclMySPINTADataIntf& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       ***************************************************************************/
      spi_tclMySPINTADataIntf& operator=(const spi_tclMySPINTADataIntf& otrSrc);

};

#endif // #ifndef _SPI_TCLMYSPINTADATAINTF_H_
