/***********************************************************************/
/*!
 * \file  spi_tclMySPINTADataIntf.h
 * \brief
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         gri2kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification

 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "mySPINTypes.h"
#include "spi_tclMySPINTAVideoIntf.h"
#include "spi_tclMySPINTAConnIntf.h"
#include "spi_tclMySPINTAWrapper.h"
#include "spi_tclMySPINTADataIntf.h"

#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MYSPINWRAPPER
#include "trcGenProj/Header/spi_tclMySPINTADataIntf.cpp.trc.h"
#endif
#endif

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINTADataIntf::spi_tclMySPINTADataIntf()
 ***************************************************************************/
spi_tclMySPINTADataIntf::spi_tclMySPINTADataIntf()
{
   //None
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINTADataIntf::~spi_tclMySPINTADataIntf()
 ***************************************************************************/
spi_tclMySPINTADataIntf::~spi_tclMySPINTADataIntf()
{
   //None
}

/***************************************************************************
 ** FUNCTION: spi_tclMySPINTAVideoIntf* spi_tclMySPINTADataIntf::poGetTAVideoIntfInst()
 ***************************************************************************/
spi_tclMySPINTAVideoIntf* spi_tclMySPINTADataIntf::poGetTAVideoIntfInst()
{
   return (spi_tclMySPINTAWrapper::getInstance());
}

/***************************************************************************
 ** FUNCTION: spi_tclMySPINTAConnIntf* spi_tclMySPINTADataIntf::poGetTAConnIntfInst()
 ***************************************************************************/
spi_tclMySPINTAConnIntf* spi_tclMySPINTADataIntf::poGetTAConnIntfInst()
{
   return (spi_tclMySPINTAWrapper::getInstance());
}

/***************************************************************************
 ** FUNCTION: spi_tclMySPINTAVehicleDataIntf* spi_tclMySPINTADataIntf::poGetTAVehDataIntfInst()
 ***************************************************************************/
spi_tclMySPINTAVehicleDataIntf* spi_tclMySPINTADataIntf::poGetTAVehDataIntfInst()
{
   return (spi_tclMySPINTAWrapper::getInstance());
}

/***************************************************************************
 ** FUNCTION: spi_tclMySPINTAVehicleDataIntf* spi_tclMySPINTADataIntf::poGetTAAudioIntfInst()
 ***************************************************************************/
spi_tclMySPINTAAudioIntf* spi_tclMySPINTADataIntf::poGetTAAudioIntfInst()
{
   return (spi_tclMySPINTAWrapper::getInstance());
}
