/***********************************************************************/
/*!
* \file  spi_tclMySPINTAConnIntf.h
* \brief  Implementation of the Class spi_tclMySPINTAConnIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         tch5kor
COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLMYSPINTACONNINTF_H_
#define _SPI_TCLMYSPINTACONNINTF_H_
/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "mySPINTypes.h"


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/



class spi_tclMySPINTAConnIntf
{

public:
      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAConnIntf::t_Void vInitMySPIN()
       ***************************************************************************/
      /*!
       * \fn    t_Void vInitMySPIN()
       * \brief Method to initialize MySPIN
       * \retval t_Void
       **************************************************************************/
       virtual t_Void vInitMySPIN() = 0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAConnIntf::t_Void vRegisterSessionCbs(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vRegisterSessionCbs(t_U32 u32DeviceHandle,
       *                          trMySPINSessionCbs rMySPINSessionCbs)
       * \brief Call back for session registration
       * \param u32DeviceHandle: [IN]Device handle
       * \param rMySPINSessionCbs: [IN]Structure to store MySPIN session
       *                            callback values
       * \retval t_Void
       **************************************************************************/
       virtual t_Void vRegisterSessionCbs(t_U32 u32DeviceHandle, trMySPINSessionCbs rMySPINSessionCbs) = 0;
       
      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAConnIntf::t_Void vSetAccessoryPropertiesAoap(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetAccessoryPropertiesAoap(t_U32 u32DeviceHandle,
       *                                 const trMySPINAccInfo& corfrAccInfo)
       * \brief Method to set accessory properties of AOAP
       * \param u32DeviceHandle: [IN]Device handle
       * \param corfrAccInfo: [IN]Used for accessory info
       * \retval t_Void
       **************************************************************************/
       virtual t_Void vSetAccessoryPropertiesAoap(t_U32 u32DeviceHandle, const trMySPINAccInfo& corfrAccInfo) = 0;         
       
      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAConnIntf::tenErrorCode enDisconnectiAP2(...)
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enDisconnectiAP2(t_U32 u32DeviceHandle)
       * \brief Method for disconnecting iAP2
       * \param u32DeviceHandle: [IN]Device handle
       * \retval tenErrorCode
       **************************************************************************/
       virtual tenErrorCode enDisconnectiAP2(t_U32 u32DeviceHandle) = 0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAConnIntf::tenErrorCode enDisconnectAOAP(...)
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enDisconnectAOAP(t_U32 u32DeviceHandle)
       * \brief Method to disconnect AOAP
       * \param u32DeviceHandle: [IN]Device handle
       * \retval tenErrorCode
       **************************************************************************/
       virtual tenErrorCode enDisconnectAOAP(t_U32 u32DeviceHandle) = 0;     

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAConnIntf::tenErrorCode enEAPSessionStart()
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enEAPSessionStart(t_U32 u32DeviceHandle)
       * \brief Method for starting EAP session
       * \param u32DeviceHandle: [IN]Device handle
       * \retval tenErrorCode
       **************************************************************************/
       virtual tenErrorCode enEAPSessionStart(t_U32 u32DeviceHandle) = 0;      

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAConnIntf::t_Void vEAPSessionStop(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vEAPSessionStop(t_U32 u32DeviceHandle)
       * \brief Method to stop EAP session
       * \param u32DeviceHandle: [IN]Device handle
       * \retval t_Void
       **************************************************************************/
       virtual t_Void vEAPSessionStop(t_U32 u32DeviceHandle) = 0;   
       
      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAConnIntf::tenErrorCode enConnectAoap()
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enConnectAoap(t_U32 u32DeviceHandle,
       *                          const trMySPINDevInfo& corfrDevInfo,
       *                          t_Bool& rfbAudioSupport)
       * \brief Method for connecting AOAP
       * \param u32DeviceHandle: [IN]Device handle
       * \param corfrDevInfo: [IN]Used for storing device info
       * \param rfbAudioSupport: [IN]Used to check whether advanced audio is supported or not
       * \retval tenErrorCode
       **************************************************************************/
       virtual tenErrorCode enConnectAoap(t_U32 u32DeviceHandle, const trMySPINDevInfo& corfrDevInfo, t_Bool& rfbAudioSupport) = 0;

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAConnIntf::tenErrorCode enConnectiAP2()
       ***************************************************************************/
      /*!
       * \fn     tenErrorCode enConnectiAP2(t_U32 u32DeviceHandle,
       *                          const trMySPINDevInfo& corfrDevInfo,
       *                          const trMySPINAccInfo& corfrAccInfo,
       *                          t_Bool isHostMode)
       * \brief Method used for connecting iAP2
       * \param u32DeviceHandle: [IN]Device handle
       * \param corfrDevInfo: [IN]Used for storing the device info
       * \param corfrAccInfo: [IN]Used for storing the accessory info
       * \retval tenErrorCode
       **************************************************************************/
       virtual tenErrorCode enConnectiAP2(t_U32 u32DeviceHandle, const trMySPINDevInfo& corfrDevInfo,
               const trMySPINAccInfo& corfrAccInfo, t_Bool isHostMode) = 0;       

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINTAConnIntf::t_Void vUpdateVoiceSessionStatus(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vUpdateVoiceSessionStatus(t_U32 u32DeviceHandle,
       *              tenMySPINVoiceSessionStatus enMySPINVoiceSessionStatus,
       *              tenMySPINVoiceSessionConstraint enMySPINVoiceSessionConstraint)
       * \brief Method to update voice session status
       * \param u32DeviceHandle: [IN]Device handle
       * \param enMySPINVoiceSessionStatus: [IN]To store MySPIN voice session
       *                                      status
       * \param enMySPINVoiceSessionConstraint: [IN]To store MySPIN voice session
       *                                         constraint
       * \retval t_Void
       **************************************************************************/
       virtual t_Void vUpdateVoiceSessionStatus(t_U32 u32DeviceHandle, tenMySPINVoiceSessionStatus enMySPINVoiceSessionStatus,
               tenMySPINVoiceSessionConstraint enMySPINVoiceSessionConstraint) = 0;       
};
#endif /* _SPI_TCLMYSPINTACONNINTF_H_ */
