/***********************************************************************/
/*!
 * \file  spi_tclMySPINTAAudioIntf.h
 * \brief  Implementation of the Class spi_tclMySPINTAAudioIntf
 *************************************************************************
 \verbatim


 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification


 \endverbatim
 *************************************************************************/
#include "mySPINTypes.h"
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/
#ifndef SPI_TCLMYSPINTAAUDIOINTF_H_
#define SPI_TCLMYSPINTAAUDIOINTF_H_

/*
 * @brief : Interface to all the vehicle data for mySPIN TA wrapper
 */
class spi_tclMySPINTAAudioIntf
{

   public:
      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINTAAudioIntf::vRegisterAudioCbs(t_U32...
       ***************************************************************************/
      /*!
       * \fn     vRegisterAudioCbs(t_U32 u32DeviceHandle, trMYSPINAudioCbs rMYSPINAudioCbs)
       * \brief  Method to register for audio callbacks
       * \param  u32DeviceHandle : Device handle
       * \param  rMYSPINAudioCbs : Structure containing audio callbacks
       **************************************************************************/
      virtual t_Void vRegisterAudioCbs(t_U32 u32DeviceHandle, trMYSPINAudioCbs rMYSPINAudioCbs) = 0;

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINTAAudioIntf::vSetAudioStatus(...
       ***************************************************************************/
      /*!
       * \fn    vSetAudioStatus(t_U32 u32DeviceHandle, t_U32 u32RequestID,
       *               tenAudioResponse enAudioResponse) 
       * \brief Method to set audio status
       * \param u32DeviceHandle : Device handle
       * \param u32RequestID : Request ID
       * \param enAudioResponse : Audio response
       **************************************************************************/
      virtual t_Void vSetAudioStatus(t_U32 u32DeviceHandle, t_U32 u32RequestID,
               tenAudioResponse enAudioResponse) = 0;
};
#endif /* SPI_TCLMYSPINTAAUDIOINTF_H_ */
