/***********************************************************************/
/*!
 * \file  spi_tclMySPINMsgQThreadable.h
 * \brief implements threading based on MsgQthreader for mySPIN Wrappers
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    implements threading based on MsgQthreader for AAP Wrappers
 AUTHOR:         gri2kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification


 \endverbatim
 *************************************************************************/

#include "spi_tclMySPINMsgQThreadable.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclMySPINMsgQThreadable.cpp.trc.h"
#endif
#endif

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINMsgQThreadable::spi_tclMySPINMsgQThreadable()
 ***************************************************************************/
spi_tclMySPINMsgQThreadable::spi_tclMySPINMsgQThreadable()
{
   ETG_TRACE_USR1((" spi_tclMySPINMsgQThreadable::spi_tclMySPINMsgQThreadable() entered "));

   m_poMySPINVideoDispatcher = new spi_tclMySPINVideoDispatcher();
   m_poMySPINSessionDispatcher = new spi_tclMySPINSessionDispatcher();
   m_poMySPINAudioDispatcher = new spi_tclMySPINAudioDispatcher();

   SPI_NORMAL_ASSERT(NULL == m_poMySPINVideoDispatcher);
   SPI_NORMAL_ASSERT(NULL == m_poMySPINSessionDispatcher);

}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINMsgQThreadable::~spi_tclMySPINMsgQThreadable()
 ***************************************************************************/

spi_tclMySPINMsgQThreadable::~spi_tclMySPINMsgQThreadable()
{
   ETG_TRACE_USR1((" spi_tclMySPINMsgQThreadable::~spi_tclMySPINMsgQThreadable() entered "));
   RELEASE_MEM(m_poMySPINVideoDispatcher);
   RELEASE_MEM(m_poMySPINSessionDispatcher);
   RELEASE_MEM(m_poMySPINAudioDispatcher);
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINMsgQThreadable::vExecute
 ***************************************************************************/

t_Void spi_tclMySPINMsgQThreadable::vExecute(tShlMessage *poMessage)
{
   ETG_TRACE_USR1((" spi_tclMySPINMsgQThreadable::vExecute entered"));
   if ((NULL != poMessage) && (NULL != poMessage->pvBuffer))
   {
      trMsgBase *prMsgBase = static_cast<trMsgBase*> (poMessage->pvBuffer);
      if (NULL != prMsgBase)
      {
         t_U32 u32ServiceID = prMsgBase->u32GetServiceID();
         ETG_TRACE_USR1(("ServiceID %d \n", u32ServiceID));

         //! Handle message to corresponding dispatcher based on Service ID
         switch (u32ServiceID)
         {
            case e32MODULEID_MYSPINVIDEO:
            {
               MySPINVideoMsgBase *poVideoMsgBase = static_cast<MySPINVideoMsgBase*> (poMessage->pvBuffer);
               if (NULL != poVideoMsgBase)
               {
                  poVideoMsgBase->vDispatchMsg(m_poMySPINVideoDispatcher);
               }
            }
               break;
            case e32MODULEID_MYSPINSESSION:
            {
               MySPINSessionMsgBase *poSessionMsgBase = static_cast<MySPINSessionMsgBase*> (poMessage->pvBuffer);
               if (NULL != poSessionMsgBase)
               {
                  poSessionMsgBase->vDispatchMsg(m_poMySPINSessionDispatcher);
               }
            }
               break;
            case e32MODULEID_MYSPINAUDIO:
            {
               MySPINAudioMsgBase *poAudioMsgBase = static_cast<MySPINAudioMsgBase*> (poMessage->pvBuffer);
               if (NULL != poAudioMsgBase)
               {
                  poAudioMsgBase->vDispatchMsg(m_poMySPINAudioDispatcher);
               }
            }
               break;
            default:
            {
               ETG_TRACE_ERR(("[ERR]:Unknown ServiceID %d \n", u32ServiceID));
            }
               break;
         }
      }

      t_U8 *pu8Buffer = static_cast<t_PU8> (poMessage->pvBuffer);
      RELEASE_ARRAY_MEM(pu8Buffer);
   }
   RELEASE_MEM(poMessage);
}

/***************************************************************************
 ** FUNCTION:  tShlMessage* spi_tclMySPINMsgQThreadable::poGetMsgBuffer()
 ***************************************************************************/
tShlMessage* spi_tclMySPINMsgQThreadable::poGetMsgBuffer(size_t siBuffer)
{
   ETG_TRACE_USR1((" spi_tclMySPINMsgQThreadable::poGetMsgBuffer entered \n"));
   tShlMessage* poMessage = new tShlMessage;

   if (NULL != poMessage)
   {
      if (0 < siBuffer)
      {
         //! Allocate the requested memory
         poMessage->pvBuffer = new t_U8[siBuffer];
      }
      else
      {
         poMessage->pvBuffer = NULL;
      } // if(0 < siBuffer)

      if (NULL != poMessage->pvBuffer)
      {
         poMessage->size = siBuffer;
      }
      else
      {
         //! Free the message as internal allocation failed.
         delete poMessage;
         poMessage = NULL;
      }
   }

   return poMessage;
}
