/***********************************************************************/
/*!
 * \file  spi_tclMySPINMsgQInterface.h
 * \brief interface for writing data to Q to use the MsgQ based
 *        threading model for mySPIN Wrapper
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    interface for writing data to Q to use the MsgQ based
 threading model for mySPIN Wrapper
 AUTHOR:         gri2kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification


 \endverbatim
 *************************************************************************/

#ifndef SPI_TCLMYSPINMSGQINTERFACE_H_
#define SPI_TCLMYSPINMSGQINTERFACE_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "MsgQThreader.h"
#include "spi_tclMySPINMsgQThreadable.h"
#include "GenericSingleton.h"

using namespace shl::thread;

/****************************************************************************/
/*!
 * \class spi_tclMySPINMsgQInterface
 * \brief interface for writing data to Q to use the MsgQ based
 *        threading model for mySPIN Wrapper
 ****************************************************************************/
class spi_tclMySPINMsgQInterface: public GenericSingleton<spi_tclMySPINMsgQInterface>
{
   public:

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINMsgQInterface::spi_tclMySPINMsgQInterface()
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINMsgQInterface()
       * \brief   Default Constructor
       * \sa      ~spi_tclMySPINMsgQInterface()
       **************************************************************************/
      spi_tclMySPINMsgQInterface();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINMsgQInterface::~spi_tclMySPINMsgQInterface()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclMySPINMsgQInterface()
       * \brief   Destructor
       * \sa      spi_tclMySPINMsgQInterface()
       **************************************************************************/
      ~spi_tclMySPINMsgQInterface();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINMsgQInterface::bWriteMsgToQ
       ***************************************************************************/
      /*!
       * \fn      bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize)
       * \brief   Write Msg to Q for dispatching the message by a seperate thread
       * \param prMsgBase : Pointer to Base Message type
       * \param u32MsgSize :  size of the message to be written to the MsgQ
       * \retval t_Bool
       **************************************************************************/
      t_Bool bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize);

      //! Base Singleton class
      friend class GenericSingleton<spi_tclMySPINMsgQInterface> ;

   private:
   
      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINMsgQInterface(const spi_tclMySPINMsgQInterface...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINMsgQInterface(
       *                             const spi_tclMySPINMsgQInterface& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINMsgQInterface()
       ***************************************************************************/
       spi_tclMySPINMsgQInterface(const spi_tclMySPINMsgQInterface& corfoSrc);


      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINMsgQInterface& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINMsgQInterface& operator=(
       *                          const spi_tclMySPINMsgQInterface& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINMsgQInterface(const spi_tclMySPINMsgQInterface& otrSrc)
       ***************************************************************************/
       spi_tclMySPINMsgQInterface& operator=(const spi_tclMySPINMsgQInterface& corfoSrc);   

      //! Pointer to the overridden MsgQThreadable class
      spi_tclMySPINMsgQThreadable *m_poMySPINMsgQThreadable;

      //! pointer to MsgQThreader
      MsgQThreader *m_poMySPINMsgQThreader;

};

#endif /* SPI_TCLMYSPINMSGQINTERFACE_H_ */
