/***********************************************************************/
/*!
 * \file  spi_tclMySPINMsgQInterface.cpp
 * \brief interface for writing data to Q to use the MsgQ based
 *        threading model for mySPIN Wrapper
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    interface for writing data to Q to use the MsgQ based
 threading model for mySPIN Wrapper
 AUTHOR:         gri2kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification


 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "spi_tclMySPINMsgQInterface.h"
#include "MessageQueue.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclMySPINMsgQInterface.cpp.trc.h"
#endif
#endif

using namespace shl::thread;

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINMsgQInterface::spi_tclMySPINMsgQInterface()
 ***************************************************************************/
spi_tclMySPINMsgQInterface::spi_tclMySPINMsgQInterface() :
   m_poMySPINMsgQThreadable(NULL), m_poMySPINMsgQThreader(NULL)
{
   ETG_TRACE_USR1(("spi_tclMySPINMsgQInterface::spi_tclMySPINMsgQInterface entered "));

   m_poMySPINMsgQThreadable = new spi_tclMySPINMsgQThreadable();
   SPI_NORMAL_ASSERT(NULL == m_poMySPINMsgQThreadable);

   m_poMySPINMsgQThreader = new MsgQThreader(m_poMySPINMsgQThreadable);
   SPI_NORMAL_ASSERT(NULL == m_poMySPINMsgQThreader);

   if (NULL != m_poMySPINMsgQThreader)
   {
      m_poMySPINMsgQThreader->bRunThread();
      m_poMySPINMsgQThreader->vSetThreadName("mySPINRespQ");
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINMsgQInterface::~spi_tclMySPINMsgQInterface()
 ***************************************************************************/
spi_tclMySPINMsgQInterface::~spi_tclMySPINMsgQInterface()
{
   ETG_TRACE_USR1((" spi_tclMySPINMsgQInterface::~spi_tclMySPINMsgQInterface() entered \n"));

   if (NULL != m_poMySPINMsgQThreader)
   {
      //Terminate the Message Queue threader before deleting it.
      MessageQueue *poMsgQ = m_poMySPINMsgQThreader->poGetMessageQueu();
      trMsgBase oMsgQTermMsg;
      poMsgQ->s16Push(static_cast<t_Void*> (&oMsgQTermMsg), 0, 1, e8_TCL_THREAD_TERMINATE_MESSAGE);

      //Wait for the message queue thread to join.
      Threader::vWaitForTermination(m_poMySPINMsgQThreader->pGetThreadID());
   }

   RELEASE_MEM(m_poMySPINMsgQThreader);
   RELEASE_MEM(m_poMySPINMsgQThreadable);
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINMsgQInterface::bWriteMsgToQ
 ***************************************************************************/
t_Bool spi_tclMySPINMsgQInterface::bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize)
{
   ETG_TRACE_USR1((" spi_tclMySPINMsgQInterface::bWriteMsgToQ entered \n"));
   t_Bool bRetQ = false;

   if (NULL != m_poMySPINMsgQThreader)
   {
      //! Get the MsgQ form threader and push the message to Q
      MessageQueue *poMsgQ = m_poMySPINMsgQThreader->poGetMessageQueu();
      if ((NULL != poMsgQ) && (NULL != prMsgBase))
      {
         t_S32 s32RetMsgQ = poMsgQ->s16Push(static_cast<t_Void*> (prMsgBase), u32MsgSize);
         bRetQ = (0 == s32RetMsgQ);
      } // if ((NULL != poMsgQ) && (NULL != prMsgBase))
   } //if (NULL != m_poAAPMsgQThreader)

   if (false == bRetQ)
   {
      ETG_TRACE_ERR(("Write to MsgQ failed  \n"));
   }

   return bRetQ;
}
