/***********************************************************************/
/*!
 * \file  spi_tclMySPINManager.h
 * \brief  Implementation of the Class spi_tclMySPINManager
 *************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         gri2kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 11.04.2016  | Chaitra Srinivasa     | Adding comments

 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLMYSPINMANAGER_H_
#define _SPI_TCLMYSPINMANAGER_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "GenericSingleton.h"
#include "RespRegister.h"
#include "spi_tclMySPINCmdVehicleData.h"
#include "spi_tclMySPINCmdAudio.h"
#include "spi_tclMySPINCmdInput.h"
#include "spi_tclMySPINCmdVideo.h"
#include "spi_tclMySPINCmdSession.h"
#include "spi_tclAOAPCmdDiscoverer.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclMySPINManager
 * \brief Manager class  to provide interface for SPI to interact with
 *        MySPINTAWrapper classes
 *
 */

class spi_tclMySPINManager: public GenericSingleton<spi_tclMySPINManager>
{

   public:

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::~spi_tclMySPINManager()
       ***************************************************************************/
      /*!
       * \fn    ~spi_tclMySPINManager()
       * \brief Destructor for spi_tclMySPINManager class
       **************************************************************************/
      virtual ~spi_tclMySPINManager();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::spi_tclMySPINCmdAudio* poGetAudioInstance()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINCmdAudio* poGetAudioInstance()
       * \brief Method for getting audio instance
       **************************************************************************/
      spi_tclMySPINCmdAudio* poGetAudioInstance();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::spi_tclAOAPCmdDiscoverer* poGetDiscInstance()
       ***************************************************************************/
      /*!
       * \fn    spi_tclAOAPCmdDiscoverer* poGetDiscInstance()
       * \brief Method to get disc instance
       * \retval spi_tclAOAPCmdDiscoverer
       **************************************************************************/
      spi_tclAOAPCmdDiscoverer* poGetDiscInstance();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::spi_tclMySPINCmdInput* poGetInputInstance()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINCmdInput* poGetInputInstance()
       * \brief Method to get input instance
       * \retval spi_tclMySPINCmdInput
       **************************************************************************/
      spi_tclMySPINCmdInput* poGetInputInstance();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::spi_tclMySPINCmdSession* poGetSessionInstance()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINCmdSession* poGetSessionInstance()
       * \brief Method to get session instance
       * \retval spi_tclMySPINCmdSession
       **************************************************************************/
      spi_tclMySPINCmdSession* poGetSessionInstance();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::spi_tclMySPINCmdVehicleData* poGetVehDataInstance()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINCmdVehicleData* poGetVehDataInstance();
       * \brief Method to get vehicle data instance
       * \retval spi_tclMySPINCmdVehicleData
       **************************************************************************/
      spi_tclMySPINCmdVehicleData* poGetVehDataInstance();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::spi_tclMySPINCmdVideo* poGetVideoInstance()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINCmdVideo* poGetVideoInstance()
       * \brief Method to get the video instance
       * \retval spi_tclMySPINCmdVideo
       **************************************************************************/
      spi_tclMySPINCmdVideo* poGetVideoInstance();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::t_Bool bRegisterObject(...)
       ***************************************************************************/
      /*!
       * \fn    t_Bool bRegisterObject(RespBase *poRespBase)
       * \brief Method to register an object
       * \param poRespBase: [IN]
       * \ret   t_Bool
       **************************************************************************/
      t_Bool bRegisterObject(RespBase *poRespBase);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::t_Bool bUnRegisterObject(...)
       ***************************************************************************/
      /*!
       * \fn    t_Bool bUnRegisterObject(RespBase *poRespBase)
       * \brief Method to unregister an object
       * \param poRespBase: [IN]
       * \ret   t_Bool
       **************************************************************************/
      t_Bool bUnRegisterObject(RespBase *poRespBase);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::t_Void vSetDeviceSubCategory();
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetDeviceSubCategory(tenDeviceSubCategory enDeviceSubCategory)
       * \brief Method to set the device's sub category
       * \param enDeviceSubCategory: [IN]Used to store the value of device's sub
       *                             category
       *  \ret  t_Void
       **************************************************************************/
      static inline t_Void vSetDeviceSubCategory(tenDeviceSubCategory enDeviceSubCategory)
      {
         m_enDeviceSubCategory = enDeviceSubCategory;
      }

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::t_Void vGetDeviceSubCategory();
       ***************************************************************************/
      /*!
       * \fn    t_Void vGetDeviceSubCategory(tenDeviceSubCategory& enDeviceSubCategory)
       * \brief Method to get the device's sub category
       * \param enDeviceSubCategory: [IN]Used to store the value of device's sub
       *                             category
       * \ret  t_Void
       **************************************************************************/
      static inline t_Void vGetDeviceSubCategory(tenDeviceSubCategory& enDeviceSubCategory)
      {
         enDeviceSubCategory = m_enDeviceSubCategory;
      }

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::t_Void vSetSessionStatus();
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetSessionStatus(tenSessionStatus enSessionStatus)
       * \brief Method to set the session status
       * \param enSessionStatus: [IN]Used to store the session status
       * \ret  t_Void
       **************************************************************************/
      static inline t_Void vSetSessionStatus(tenSessionStatus enSessionStatus)
      {
         m_enSessionStatus = enSessionStatus;
      }

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::t_Void vGetSessionStatus();
       ***************************************************************************/
      /*!
       * \fn    t_Void vGetSessionStatus(tenSessionStatus& enSessionStatus)
       * \brief Method to get the session status
       * \param enSessionStatus: [IN]Used to store the session status
       * \ret  t_Void
       **************************************************************************/
      static inline t_Void vGetSessionStatus(tenSessionStatus& enSessionStatus)
      {
         enSessionStatus = m_enSessionStatus;
      }

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::t_Void vSetBTConnInfo()
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetBTConnInfo(const t_U32 cou32DeviceHandle, t_Bool bIsHFP, t_String szBTAddr)
       * \brief Method to set the BT connection info
       * \param cou32DeviceHandle: [IN]Device handle
       * \param bIsHFP : HFP connection status
       * \param szBTAddr : BT mac address
       * \param rfszBTDeviceName : BT device name       
       * \ret  t_Void
       **************************************************************************/
      static inline t_Void vSetBTConnInfo(const t_U32 cou32DeviceHandle, t_Bool bIsHFP, 
                                          t_String szBTAddr)
      {
          m_u32DeviceHandle = cou32DeviceHandle;
          m_bIsHFP = bIsHFP;
          m_szBTAddr = szBTAddr;
      }
      
      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::t_Void vGetBTConnInfo()
       ***************************************************************************/
      /*!
       * \fn    t_Void vGetBTConnInfo(t_U32 &rfu32DeviceHandle, t_Bool& rfbIsHFP, t_String& rfszBTAddr)
       * \brief Method to get the BT connection info
       * \param cou32DeviceHandle: [IN]Device handle
       * \param bIsHFP : HFP connection status
       * \param rfszBTAddr : BT mac address
       * \param rfszBTDeviceName : BT device name
       * \ret  t_Void
       **************************************************************************/
      static inline t_Void vGetBTConnInfo(t_U32 u32DeviceHandle, t_Bool &rfbIsHFP, 
                                          t_String& rfszBTAddr)
      {
          if (m_u32DeviceHandle == u32DeviceHandle)
          {
              rfbIsHFP = m_bIsHFP;
              rfszBTAddr = m_szBTAddr;
          }
      }      
      
      //! Base Singleton class
      friend class GenericSingleton<spi_tclMySPINManager>;

   private:

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINManager::spi_tclMySPINManager()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINManager()
       * \brief Constructor of spi_tclMySPINManager class
       **************************************************************************/
      spi_tclMySPINManager();
	  
      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINManager(const spi_tclMySPINManager...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINManager(
       *                             const spi_tclMySPINManager& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINManager()
       ***************************************************************************/
       spi_tclMySPINManager(const spi_tclMySPINManager& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINManager& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINManager& operator=(
       *                          const spi_tclMySPINManager& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINManager(const spi_tclMySPINManager& otrSrc)
       ***************************************************************************/
       spi_tclMySPINManager& operator=(const spi_tclMySPINManager& corfoSrc); 	  

      //! Discoverer command class pointer
      spi_tclAOAPCmdDiscoverer* m_poCmdDiscoverer;

      //! Audio command class pointer
      spi_tclMySPINCmdAudio* m_poCmdAudio;

      //! Input command class pointer
      spi_tclMySPINCmdInput* m_poCmdInput;

      //! Session command class pointer
      spi_tclMySPINCmdSession* m_poCmdSession;

      //! Vehicle data command class pointer
      spi_tclMySPINCmdVehicleData* m_poCmdVehicleData;

      //! Video command class pointer
      spi_tclMySPINCmdVideo* m_poCmdVideo;

      //!Device Subcategory of mySPIN device
      static tenDeviceSubCategory m_enDeviceSubCategory;

      //!Current Session State of mySPIN
      static tenSessionStatus m_enSessionStatus;
      
      //! Device handle
      static t_U32 m_u32DeviceHandle;
      
      //! HFP connection status
      static t_Bool m_bIsHFP;
      
      //! BT mac address
      static t_String m_szBTAddr;

};
#endif /* _SPI_TCLMYSPINMANAGER_H_ */
