/***********************************************************************/
/*!
 * \file   spi_tclMySPINRespAudio.h
 * \brief  Target Adapter Call backs output interface
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Audio Commands response interface
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 27.07.2016  | tch5kor               | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLMYSPINRESPAUDIO_H_
#define _SPI_TCLMYSPINRESPAUDIO_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "mySPINTypes.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class  spi_tclMySPINRespVideo
 * \brief
 *****************************************************************************/
class spi_tclMySPINRespAudio: public RespBase
{

   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINRespAudio::spi_tclMySPINRespAudio()
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINRespAudio()
       * \brief   Default Constructor
       * \sa      ~spi_tclMySPINRespAudio()
       **************************************************************************/
      spi_tclMySPINRespAudio() :
         RespBase(e16MYSPIN_AUDIO_REGID)
      {
      }

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINRespAudio::~spi_tclMySPINRespAudio()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclMySPINRespAudio()
       * \brief   Destructor
       * \sa      spi_tclMySPINRespAudio()
       **************************************************************************/
      virtual ~spi_tclMySPINRespAudio()
      {
      }
      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINAudioResourceMngr::vAudioRequestCb(...
       ***************************************************************************/
      /*!
       * \fn     vAudioRequestCb(t_U32 u32DeviceId)
       * \brief  Callback for audio request from phone
       * \param  [u32DeviceId]: Unique device Id
       * \parma
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vAudioRequestCb(t_U32 u32DeviceId, tenAudioCtrlCommand enCommand, t_U32 u32RequestID,
               tenMySPINAudioType enType)
      {

      }

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINAudioResourceMngr::vVRStreamErrorCb(...
       ***************************************************************************/
      /*!
       * \fn     vVRStreamErrorCb(t_U32 u32DeviceId)
       * \brief  Callback for VR Stream error from phone
       * \param  [enError]: Error number
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vVRStreamErrorCb(t_U32 u32DevHandle, tenMySPINVRStreamError enError)
      {

      }

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINRespAudio(const spi_tclMySPINRespAudio...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINRespAudio(const spi_tclMySPINRespAudio& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINRespAudio()
       ***************************************************************************/
      spi_tclMySPINRespAudio(const spi_tclMySPINRespAudio& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINRespAudio& operator=( const spi_tclMySPINRespAudio...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINRespAudio& operator=(const spi_tclMySPINRespAudio& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINRespAudio(const spi_tclMySPINRespVideo& otrSrc)
       ***************************************************************************/
      spi_tclMySPINRespAudio& operator=(const spi_tclMySPINRespAudio& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

}; //class spi_tclMySPINRespVideo

#endif //_SPI_TCLMYSPINPRESPVIDEO_H_
///////////////////////////////////////////////////////////////////////////////
// <EOF>
