/***********************************************************************/
/*!
 * \file  spi_tclMySPINAudioDispatcher.h
 * \brief Message Dispatcher for Audio Messages. implemented using
 *       double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Audio Messages
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 29.06.2015  | tch5kor               | Initial Version


 \endverbatim
 *************************************************************************/
#ifndef SPI_TCLMYSPINAUDIODISPATCHER_H_
#define SPI_TCLMYSPINAUDIODISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "mySPINTypes.h"
#include "RespRegister.h"

/**************Forward Declarations******************************************/
class spi_tclMySPINAudioDispatcher;

/****************************************************************************/
/*!
 * \class MySPINAudioMsgBase
 * \brief Base Message type for all Session messages
 ****************************************************************************/
class MySPINAudioMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  MySPINAudioMsgBase::MySPINAudioMsgBase
       ***************************************************************************/
      /*!
       * \fn      MySPINAudioMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      MySPINAudioMsgBase();

      /***************************************************************************
       ** FUNCTION:  MySPINAudioMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param poSessionDispatcher : pointer to Message dispatcher for Session
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclMySPINAudioDispatcher* poSessionDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  MySPINAudioMsgBase::~MySPINAudioMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~MySPINAudioMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~MySPINAudioMsgBase()
      {

      }

      /***************************************************************************
       ** FUNCTION:  MySPINAudioMsgBase::u32GetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      u32GetDeviceHandle()
       * \brief   returns the device handle
       * \retval t_U32
       **************************************************************************/
      virtual t_U32 u32GetDeviceHandle()
      {
         return m_u32DeviceHandle;
      }

      /***************************************************************************
       ** FUNCTION:  MySPINAudioMsgBase::vSetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      vSetDeviceHandle()
       * \brief   sets the device handle
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSetDeviceHandle(const t_U32 cou32DevHndle)
      {
         m_u32DeviceHandle = cou32DevHndle;
      }
      ;

   private:
      t_U32 m_u32DeviceHandle;
};

/****************************************************************************/
/*!
 * \class MySPINAudioCmdMsg
 * \brief Audio Request response message
 ****************************************************************************/
class MySPINAudioCmdMsg: public MySPINAudioMsgBase
{
   public:
	   //! Audio Command
      tenAudioCtrlCommand m_enCommand;

	   //! Request ID
	   t_U32 m_u32RequestID;

	   //! Audio type
	   tenMySPINAudioType m_enAudioType;

      /***************************************************************************
       ** FUNCTION:  MySPINAudioCmdMsg::MySPINAudioCmdMsg
       ***************************************************************************/
      /*!
       * \fn      MySPINAudioCmdMsg()
       * \brief   Default constructor
       **************************************************************************/
	   MySPINAudioCmdMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINAudioCmdMsg::~MySPINAudioCmdMsg
       ***************************************************************************/
      /*!
       * \fn      ~MySPINAudioCmdMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~MySPINAudioCmdMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  MySPINAudioCmdMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclMySPINAudioDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       * \retval t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclMySPINAudioDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  MySPINAudioCmdMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINAudioCmdMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       * \retval t_Void
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class MySPINVRStreamErrorMsg
 * \brief VR Stream error message
 ****************************************************************************/
class MySPINVRStreamErrorMsg: public MySPINAudioMsgBase
{
   public:
       //! Error number
       tenMySPINVRStreamError m_enError;

      /***************************************************************************
       ** FUNCTION:  MySPINVRStreamErrorMsg::MySPINVRStreamErrorMsg
       ***************************************************************************/
      /*!
       * \fn      MySPINVRStreamErrorMsg()
       * \brief   Default constructor
       **************************************************************************/
       MySPINVRStreamErrorMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINVRStreamErrorMsg::~MySPINVRStreamErrorMsg
       ***************************************************************************/
      /*!
       * \fn      ~MySPINVRStreamErrorMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~MySPINVRStreamErrorMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  MySPINVRStreamErrorMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclMySPINAudioDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       * \retval t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclMySPINAudioDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  MySPINVRStreamErrorMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINVRStreamErrorMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       * \retval t_Void
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class spi_tclMySPINSessionDispatcher
 * \brief Message Dispatcher for Session Messages
 ****************************************************************************/
class spi_tclMySPINAudioDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAudioDispatcher::spi_tclMySPINAudioDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINAudioDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclMySPINAudioDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAudioDispatcher::~spi_tclMySPINAudioDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclMySPINAudioDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclMySPINAudioDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAudioDispatcher::vHandleSessionMsg(MySPINAudioCmdMsg* poMySPINAudioCmdMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(MySPINAudioCmdMsg* poMySPINAudioCmdMsg)
       * \brief   Handles Messages of MySPINAudioCmdMsg type
       * \param   poMySPINAudioCmdMsg : pointer to MySPINAudioCmdMsg.
       * \retval  t_Void
       **************************************************************************/
      t_Void vHandleSessionMsg(MySPINAudioCmdMsg* poMySPINAudioCmdMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAudioDispatcher::vHandleSessionMsg(MySPINVRStreamErrorMsg* poMySPINVRStreamErrorMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(MySPINVRStreamErrorMsg* poMySPINVRStreamErrorMsg)
       * \brief   Handles Messages of MySPINVRStreamErrorMsg type
       * \param   poMySPINVRStreamErrorMsg : pointer to MySPINVRStreamErrorMsg.
       * \retval  t_Void
       **************************************************************************/
      t_Void vHandleSessionMsg(MySPINVRStreamErrorMsg* poMySPINVRStreamErrorMsg) const;
};

#endif /* SPI_TCLMYSPINAUDIODISPATCHER_H_ */
