/***********************************************************************/
/*!
* \file   mySPINTypes.h
* \brief  to define the types required for mySPIN
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:
AUTHOR:         grikor
COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification

\endverbatim
*************************************************************************/


#ifndef MYSPINTYPES_H
#define MYSPINTYPES_H

#include "SPITypes.h"
#include "mspin_appl_if_adapter.h"
#define MYSPIN_CONN_HNDLRS 3

struct trMySPINSessionCbs
{
   t_Void (*vAppInactiveCb)(t_Void *poContext,t_Bool bIsInActive);
   t_Void (*vAppTransitionCb)(t_Void *poContext, t_Bool bIsActive);
   t_Void (*vInitiatePhoneCallCb)(t_Void *poContext,t_Char *pczNumberString,t_Char *pczDisplayString);
   t_Void (*vErrorCb)(t_Void *poContext, MSPIN_ERROR enErrorCode);
   t_Void (*vPhoneCallStatusCallback)(t_Void *poContext, t_Bool bIsActive);
   t_Void (*vCustomDataStringCallback)(t_Void *poContext,MSPIN_PHONEMSGSTRTYPE enPhoneStringType,
      MSPIN_STRINGENCODING enEncoding,t_Char *pczData);
   t_Void (*vCustomDataIntCallback)(t_Void *poContext,MSPIN_PHONEMSGINTTYPE enPhoneStringType,t_S64 s64Data);
   t_Void(*vVoiceSessionCallback)(t_Void *pocontext, MSPIN_VOICESESSION_REQUESTTYPE requestType);
   t_Void(*vPTTAvailableCallback)(t_Void *poContext, t_Bool bIsPttAvail);
};

struct trMySPINVideoCbs
{
   t_Void (*vFirstFrameRenderedCb)(t_Void *poContext);
   t_Void (*vLayerManagerDeinitCb)(t_Void *poContext);
   t_Void (*vLayerManagerInitCb)(t_Void *poContext);
};

struct trMYSPINAudioCbs
{
   t_Void (*vAudioRequestCb)(t_Void *context, MSPIN_AUDIOCONTROL command, t_U32 requestID, MSPIN_AUDIOTYPE type);
};

struct trVehicleDataCbs
{
   t_Void (*vVehicleDataRequestCb)(t_Void *poContext, t_Bool request, t_U8 u8length, t_U32 *u32keyList);
   t_Void (*vNavigateToCallback)(t_Void *poContext, char *displayString, MSPIN_NAVIGATETOTYPE type,
            double longitude, double latitude, MSPIN_LocationStrings_t *locationDesciption);
};


struct trMySPINDevInfo
{
   t_U32 u32VendorID;
   t_U32 u32ProductID;
   t_String szSerial;
};

struct trMySPINAccInfo
{
   t_String szVendorName;
   t_String szModel;
   t_String szDescription;
   t_String szVersion;
   t_String szUri;
   t_String szSerial;
   t_String szWriteDevice;
   t_String szReadDevice;
   t_Bool bHostmode;
   t_Bool bAudioSupport;
};


enum tenPixelCompression
{
   PIXEL_COMP_NONE =0 ,
   PIXEL_COMP_ZLIB = 1,
   PIXEL_COMP_JPEG = 2,
   PIXEL_COMP_UNCOMPRESSED =3
};

struct trMySpinVideoConfig
{
   t_U32 u32LayerId;
   t_U32 u32SurfaceId;
   t_U32 u32WidthInPixels;
   t_U32 u32HeightInPixels;
   t_U32 u32WidthInMm;
   t_U32 u32HeightInMm;
   tenPixelFormat enPixelFormat;
   tenPixelCompression enPixelCompression;
   tenPixelCompression enPreferredCompression;
};

enum tenHeadUnitCaps
{
   e32PhoneCapablity = 1,
   e32NaviCapability = 2,
   e32PhoneNaviCapable = 3
};

struct trMySPINContext{
   t_U32 u32DeviceHandle;
   tenDeviceSubCategory enDeviceSubCategory;
   tenSessionStatus enSessionStatus;
   t_Bool bIsBTConnected;
   t_Bool bIsPTTAvail;
   trMySPINContext():u32DeviceHandle(0),
                     enDeviceSubCategory(e8DEVTYPE_UNKNWON),
                     enSessionStatus(e8_SESSION_UNKNOWN),
                     bIsBTConnected(false),
                     bIsPTTAvail(false)
   {

   }
};

typedef enum
{
   e32MODULEID_AOAPDISCOVERER = 1,
   e32MODULEID_MYSPINVIDEO = 2,
   e32MODULEID_MYSPINSESSION = 3,
   e32MODULEID_MYSPINAUDIO = 4
} tenMySPINModuleID;

struct trMySpinAudioConfig
{
   t_String szEncoding;
   t_String szInputDev;
   t_U32 u32bitRate;
   t_U32 u32sampleRate;
   t_U8 u8Channels;
   t_U8 u8SampleWidth;
   t_U8 u8SampleDepth;
   t_Bool bIsSigned;
   t_Bool bHasIndianNess;
   t_String szAddress;
   t_String szPlayerAddress;

   trMySpinAudioConfig():u32bitRate(0),u32sampleRate(0),
                         u8Channels(0),u8SampleWidth(0),u8SampleDepth(0),
                         bIsSigned(0),bHasIndianNess(false)
   {

   }
};

typedef enum
{
   DBUS_PROXY_INVALID      = 0,
   DBUS_PROXY_FOR_BTALPS_AUDIO,
   DBUS_PROXY_FOR_AVP,
   DBUS_PROXY_FOR_AVP_PLAYER
} tenProxyType;

typedef enum
{
   e8MSPIN_KEY_HOME
} tenMySPINKeyCode;

typedef enum
{
    e8MSPIN_CUSTOMDATA_KEYTYPE_UNKNOWN = 0,
    e8MSPIN_CUSTOMDATA_KEYTYPE_PRESS = 1,
    e8MSPIN_CUSTOMDATA_KEYTYPE_RELEASE = 2,
    e8MSPIN_CUSTOMDATA_KEYTYPE_LONGPRESS = 3,
    e8MSPIN_CUSTOMDATA_KEYTYPE_CLICK = 4,
    e8MSPIN_CUSTOMDATA_KEYTYPE_DOUBLECLICK = 5    
}tenMySPINCustomKeyMode;

typedef enum
{
   e8MSPIN_PTT = 1,
   e8MSPIN_OK = 12,
   e8MSPIN_BACKWARD = 14,
   e8MSPIN_KNOBTICKCW = 20,
   e8MSPIN_KNOBTICKCCW = 21,
   e8MSPIN_DPADUP = 30,
   e8MSPIN_DPADDOWN = 31,
   e8MSPIN_DPADLEFT = 32,
   e8MSPIN_DPADRIGHT = 33
} tenMySPINCustomKeyCode; 

enum tenMySPINVoiceSessionReq
{
    e8VOICESESSION_REQUEST_START_MIC_AND_SPEAKERS = 0,
    e8VOICESESSION_REQUEST_START_MIC_ONLY = 1,
    e8VOICESESSION_REQUEST_ACTIVE = 2,
    e8VOICESESSION_REQUEST_END_USER_EVENT = 3,
    e8VOICESESSION_REQUEST_END_REAL_CALL_EVENT = 4,
    e8VOICESESSION_REQUEST_UNKNOWN = 5
};
enum tenMySPINVoiceSessionStatus
{
   e8VOICESESSION_STATUS_UNAVAILABLE = 0,
   e8VOICESESSION_STATUS_IDLE = 1,
   e8VOICESESSION_STATUS_START_REQUESTED = 2,
   e8VOICESESSION_STATUS_ACTIVE = 3,
   e8VOICESESSION_STATUS_END_REQUESTED = 4,
   e8VOICESESSION_STATUS_ONGOING = 5
};
enum tenMySPINVoiceSessionConstraint
{
   e8VOICESESSION_STATUS_CONSTRAINT_NONE = 0,
   e8VOICESESSION_STATUS_CONSTRAINT_NOHFP = 1,
   e8VOICESESSION_STATUS_CONSTRAINT_VOICEALREADYACTIVE = 2,
   e8VOICESESSION_STATUS_CONSTRAINT_SCOTIMEOUT = 3
};

typedef std::function<void(t_U32)>
         tvBluetoothConStat;

typedef std::function<void(t_U32,t_Bool, t_U8)> tvVehicleDataRequestCb;

enum tenIVIAudioType
{
   e8_AudioType_UNKNOWN = 0,
   e8_AudioType_MAIN,
   e8_AudioType_TRANSIENT
};

enum tenAudioCtrlCommand
{
   e8COMMAND_REQUEST = 1,
   e8COMMAND_RELEASE = 5
};

enum tenMySPINAudioType
{
   e8_AUDIOTYPE_IGNORE = 1,
   e8_AUDIOTYPE_SILENT = 2,
   e8_AUDIOTYPE_MAIN = 3,
   e8_AUDIOTYPE_CHIME = 4,
   e8_AUDIOTYPE_ANNOUNCEMENT = 5,
   e8_AUDIOTYPE_CRITICALANNOUNCEMENT = 6
};

enum tenAudioResponse
{
   e8_REQUEST_INVALID = 0,
   e8_REQUEST_REJECT = 2,
   e8_REQUEST_OPEN = 3,
   e8_REQUEST_SUSPEND = 4,
   e8_REQUEST_CLOSE = 6
};

enum tenCmdState
{
   e8_STATE_NEW = 0,
   e8_STATE_PROCESSING,
   e8_STATE_ACTIVE,
   e8_STATE_PRE_ACTIVATED,
   e8_STATE_SUSPENDED,
   e8_STATE_CLOSED,
   e8_STATE_INACTIVATED
};

enum tenAppCapability
{
   e8_CAPABILITY_NONE = 0,
   e8_CAPABILITY_AUDIO_HANDLING = 2,
   e8_CAPABILITY_ALL = 3
};

enum tenMySPINBTMediaKey
{
    e8_CMD_UNUSED = 0,
    e8_CMD_PLAY,
    e8_CMD_STOP,
    e8_CMD_PAUSE,
    e8_CMD_NEXTTRACK,
    e8_CMD_PREVTRACK,
    e8_CMD_FORWARD,
    e8_CMD_REWIND,
    e8_CMD_RESERVED1,
    e8_CMD_RESERVED2,
    e8_CMD_MEDIASUSPEND,
    e8_CMD_MEDIARESUME
};

enum tenMySPINVRStreamError
{
    e8MYSPIN_VR_STREAM_ERROR_UNKNOWN = 0,
    e8MYSPIN_VR_STREAM_ERROR_NOMEM = 1
};

struct trMySPINAudioCmd
{
   t_U32 u32DeviceHandle;
   tenAudioCtrlCommand enCommand;
   tenMySPINAudioType enAudioType;
   t_U32 u32RequestID;
   tenAudioResponse enAudioResponse;
   tenAudioDir enAudioDir;
   tenCmdState  enState;

   trMySPINAudioCmd() :
                     u32DeviceHandle(0),
                     enCommand(e8COMMAND_REQUEST),
                     enAudioType(e8_AUDIOTYPE_IGNORE),
                     u32RequestID(0),
                     enAudioResponse(e8_REQUEST_INVALID),
                     enAudioDir(e8AUD_INVALID),
                     enState(e8_STATE_NEW)
   {

   }
};

typedef std::pair<tenAudioCtrlCommand,tenMySPINAudioType> tMySPINcmdAudioTypePair;

typedef std::pair<tMySPINcmdAudioTypePair,tenIVIAudioType> tMySPINAudioReqTuple;

typedef std::pair<tenAudioResponse,tenAudioDir> tMySPINResponseAudDirpair;

typedef std::pair<tMySPINAudioReqTuple,tMySPINResponseAudDirpair> tMySPINResponseLookUpPair;

typedef std::function<void(trMySPINAudioCmd)> tfvAudioCmdCb;

typedef std::function<void(tenDuckingType)> tfvAudioDuckCb;

struct trmySPINAudioCbs
{
   tfvAudioCmdCb fvRequestLaunchAudioCb;
   tfvAudioCmdCb fvRequestTerminateAudioCb;

   trmySPINAudioCbs():fvRequestLaunchAudioCb(NULL),
                      fvRequestTerminateAudioCb(NULL)
      {

      }
};

struct trmySPINAudioDuckCb
{
    tfvAudioDuckCb fvAudioDuckingCb;

    trmySPINAudioDuckCb():fvAudioDuckingCb(NULL)
    {
    }
};

 struct trAudioState
{
   t_Bool isActive;
   t_U32  u32RequestID;

   trAudioState():isActive(false),u32RequestID(0)
   {

   }
};

struct trMySPINUSBDeviceInfo
{
	 t_U32 u32VendorID;
     t_U32 u32ProductID;
     t_String szSerialNumber;
     t_String   szProduct;
     t_String   szmanufacturer;
     t_U32    u32DeviceNumber;
     t_String szSystemPath;
     t_U32    u32Interface;
     t_Bool   bIsAOAPSupported;
     t_Bool   bIsOTGPort;

     trMySPINUSBDeviceInfo():u32VendorID(0), u32ProductID(0),u32DeviceNumber(0), u32Interface(0),
                             bIsAOAPSupported(false),bIsOTGPort(false)

     {

     }
};

enum tenMspinVideoResponse
{
   e8MSPIN_RESP_INVALID = 0,
   e8MSPIN_RESP_ACCEPT = 1,
   e8MSPIN_RESP_DENY = 2,
};

enum tenMspinVideoFocusState
{
   e8MSPIN_VIDEOFOCUSSTATE_UNKNOWN = 0,
   e8MSPIN_VIDEOFOCUSSTATE_GAIN = 1,
   e8MSPIN_VIDEOFOCUSSTATE_GAIN_TRANSIENT = 2,
   e8MSPIN_VIDEOFOCUSSTATE_LOSS = 3,
   e8MSPIN_VIDEOFOCUSSTATE_LOSS_TRANSIENT = 4
};

//It is used to hold the data mentioned in the config file,
//to derive the current HU Video focus state based on the context & display flag
struct trMspinAccVideoFocusNoti
{
   tenDisplayContext enAccDispCntxt;
   //This state is set, when HMI requests for Video Focus
   tenMspinVideoFocusState enAccFocusReqType;
   //This state is set, when HMI releases for Video Focus
   tenMspinVideoFocusState enAccFocusRelType;

   trMspinAccVideoFocusNoti& operator=(const trMspinAccVideoFocusNoti& corfrMspinAccVideoFocusNoti)
   {
      if(&corfrMspinAccVideoFocusNoti != this)
      {
         enAccDispCntxt = corfrMspinAccVideoFocusNoti.enAccDispCntxt;
         enAccFocusReqType = corfrMspinAccVideoFocusNoti.enAccFocusReqType;
         enAccFocusRelType = corfrMspinAccVideoFocusNoti.enAccFocusRelType;
      } //if(&corfrMspinAccVideoFocusNoti != this)
      return *this;
   }
};

struct trMySPINDeviceInfo
{
   trMySPINUSBDeviceInfo rUSBDeviceInfo;
   tenDeviceCategory enDeviceCategory;
   tenDeviceSubCategory enDevSubCat;
   t_U32 u32DeviceHandle;
};

struct trMspinVideoFocusState
{
   //Current MD Focus State
   tenMspinVideoFocusState enCurMDFocusState;
   //Accessory or MD Requested Focus State
   tenMspinVideoFocusState enReqFocusState;
   //New MD Focus State
   tenMspinVideoFocusState enUpdatedMDFocusState;

   trMspinVideoFocusState& operator=(const trMspinVideoFocusState& corfrMspinVideoFocusState)
   {
      if( &corfrMspinVideoFocusState != this )
      {
         enCurMDFocusState = corfrMspinVideoFocusState.enCurMDFocusState;
         enReqFocusState = corfrMspinVideoFocusState.enReqFocusState;
         enUpdatedMDFocusState = corfrMspinVideoFocusState.enUpdatedMDFocusState;
      }   //if( &corfrMspinVideoFocusState != this )
      return *this;
   }
};

struct trMspinMDVideoFocusReq
{
   //Current Accessory display context
   tenDisplayContext enAccDispCntxt;
   tenMspinVideoResponse enMDFocusReqResp_StateLoss;
   tenMspinVideoResponse enMDFocusReqResp_StateLossTransient;

   trMspinMDVideoFocusReq& operator=(const trMspinMDVideoFocusReq& corfrMspinMDVideoFocusReq)
   {
      if( &corfrMspinMDVideoFocusReq != this )
      {
         enAccDispCntxt = corfrMspinMDVideoFocusReq.enAccDispCntxt;
         enMDFocusReqResp_StateLoss = corfrMspinMDVideoFocusReq.enMDFocusReqResp_StateLoss;
         enMDFocusReqResp_StateLossTransient = corfrMspinMDVideoFocusReq.enMDFocusReqResp_StateLossTransient;
      }   //if( &corfrMspinMDVideoFocusReq != this )
      return *this;
   }
};

enum tenMspinVideoFocus
{
   e8MSPIN_VIDEOFOCUS_UNKNOWN = 0,
   e8MSPIN_VIDEOFOCUS_PROJECTED = 1,
   e8MSPIN_VIDEOFOCUS_NATIVE = 2
};

typedef std::function<void(const trMySPINDeviceInfo&,tenDeviceConnectionStatus)> tfvSetDeviceStatus;

enum tenAudioTransType
{
   e8AUDIOTRANSPORT_UNKNWON = 0,
   e8AUDIOTRANSPORT_BT = 1,
   e8AUDIOTRANSPORT_USB = 2
};

enum tenAudioStreamError
{
   e8NOERROR = 0,
   e8STREAMERROR
};

enum tenHFPStatus
{
   e8MSPIN_HFP_UNKNOWN = 0,
   e8MSPIN_HFP_DISCONNECTED = 1,
   e8MSPIN_HFP_CONNECTED = 2
};

enum tenA2DPStatus
{
   e8MSPIN_A2DP_UNKNOWN = 0,
   e8MSPIN_A2DP_DISCONNECTED = 1,
   e8MSPIN_A2DP_CONNECTED = 2
};

enum tenMspinVRStatus
{
   e8MSPIN_VR_UNKNOWN = 0,
   e8MSPIN_VR_ACTIVATING = 1,
   e8MSPIN_VR_ACTIVATED = 2,
   e8MSPIN_VR_ENDED = 3
};

struct trBTDeviceInfo
{
   t_Bool bIsA2DP;
   t_Bool bIsHFP;
   t_String szFriendlyName;
};

enum tenMySPINError
{
    e8MSPIN_SUCCESS = 0,
    e8MSPIN_ERROR_CONNECTION_START = 1,
    e8MSPIN_ERROR_CORE = 2,
    e8MSPIN_ERROR_LAYERMANAGER = 3,
    e8MSPIN_ERROR_GENERAL = 4,
    e8MSPIN_ERROR_CONNECTION_TIMEOUT = 5,
    e8MSPIN_ERROR_CONNECTION_EOF_ZERO = 6,
    e8MSPIN_ERROR_PROTOCOL_STOP = 7,
    e8MSPIN_ERROR_Z_DATA_ERROR = 8,
    e8MSPIN_ERROR_MEM_ALLOC = 9,
    e8MSPIN_ERROR_FRAME_SIZE_MISMATCH = 10,
    e8MSPIN_ERROR_PROTOCOL_SETUP = 11,
    e8MSPIN_ERROR_RECEIVER_START_FAILED = 12,
    e8MSPIN_ERROR_MESSAGE_PROCESSING_FAILED = 13,
    e8MSPIN_ERROR_NOT_IMPLEMENTED = 14,
    e8MSPIN_ERROR_INVALID_PARAMETER = 15,
    e8MSPIN_ERROR_NULL_HANDLE = 16,
    e8MSPIN_ERROR_NOT_SUPPORTED = 17,
    e8MSPIN_ERROR_NOT_READY = 18,
    e8MSPIN_ERROR_JPEG = 19,
    e8MSPIN_ERROR_INITIALIZATION_ABORT = 20,
    e8MSPIN_ERROR_NETWORK_NOT_REACHABLE = 21,
    e8MSPIN_ERROR_CONNECTION_REFUSED = 22,
    e8MSPIN_ERROR_NOT_FOUND = 23,
    e8MSPIN_ERROR_ALREADY_RUNNING = 24,
    e8MSPIN_ERROR_NOT_ALLOWED = 25,
    e8MSPIN_ERROR_UNKNOWN = 26
};
#endif
//ifndef
