/***********************************************************************/
/*!
 * \file    spi_tclMySPINResourceMngr.cpp
 * \brief   AAP Resource Manager
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    AAP Resource Manager
 AUTHOR:         Shiva Kumar Gurija
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 04.11.2015  | Shiva Kumar Gurija    | Initial Version

 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "spi_tclResorceMngrDefines.h"
#include "spi_tclMySPINVideoResourceMngr.h"
#include "spi_tclMySPINAudioResourceMngr.h"
#include "spi_tclMySPINManager.h"
#include "spi_tclMySPINResourceMngr.h"
#include "spi_tclExtCompManager.h"
#include "spi_tclExtCmdTelephone.h"
#include "spi_tclFactory.h"
#include "spi_tclMediator.h"
#include "spi_tclAudio.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_RSRCMNGR
#include "trcGenProj/Header/spi_tclMySPINResourceMngr.cpp.trc.h"
#endif
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/
static t_U32 su32CurSelectedDevId = 0;

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINResourceMngr::spi_tclMySPINResourceMngr()
 ***************************************************************************/
spi_tclMySPINResourceMngr::spi_tclMySPINResourceMngr():m_enVRState(e8MSPIN_VR_UNKNOWN) 
{
   ETG_TRACE_USR1(("spi_tclMySPINResourceMngr() entered "));

   m_poVideoRsrcMngr = new (std::nothrow) spi_tclMySPINVideoResourceMngr(this);
   SPI_NORMAL_ASSERT(NULL == m_poVideoRsrcMngr);

   m_poAudioResrcMgr = new (std::nothrow) spi_tclMySPINAudioResourceMngr(this);
   SPI_NORMAL_ASSERT(NULL == m_poAudioResrcMgr);

   m_rDeviceAppStates.enSpeechAppState = e8SPI_SPEECH_UNKNOWN;
   m_rDeviceAppStates.enPhoneAppState  = e8SPI_PHONE_UNKNOWN;
   m_rDeviceAppStates.enNavAppState    = e8SPI_NAV_UNKNOWN;
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINResourceMngr::~spi_tclMySPINResourceMngr()
 ***************************************************************************/
spi_tclMySPINResourceMngr::~spi_tclMySPINResourceMngr()
{
   ETG_TRACE_USR1(("~spi_tclMySPINResourceMngr() entered"));

   RELEASE_MEM(m_poVideoRsrcMngr);
   RELEASE_MEM(m_poAudioResrcMgr);
   m_enVRState = e8MSPIN_VR_UNKNOWN; 

}

/***************************************************************************
 ** FUNCTION:  t_Void  spi_tclMySPINResourceMngr::vRegRsrcMngrCallBack()
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vRegRsrcMngrCallBack(trRsrcMngrCallback rRsrcMngrCallback)
{
   ETG_TRACE_USR1(("spi_tclMySPINResourceMngr::vRegRsrcMngrCallBack entered"));
   m_rRsrcMngrCb = rRsrcMngrCallback;
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINResourceMngr::vRegisterCallbacks
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vRegisterCallbacks()
{
   ETG_TRACE_USR1((" spi_tclMySPINResourceMngr::vRegisterCallbacks() Entered"));
   //! Register for callbacks
   trDeviceDisconnectCb rDeviceDisconnectCb;
   rDeviceDisconnectCb.fvDeviceDisconnectCb = std::bind(&spi_tclMySPINResourceMngr::vDeviceDisconStatusCb,
                                                        this,
                                                        SPI_FUNC_PLACEHOLDERS_1);
   spi_tclMediator* poMediator = spi_tclMediator::getInstance();
   if (NULL != poMediator)
   {      
      poMediator->vRegisterCallbacks(rDeviceDisconnectCb);
   } // if (NULL != m_poMediator)

}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINResourceMngr::vDeviceDisconStatusCb
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vDeviceDisconStatusCb(const t_U32 cou32DeviceHandle)
{
    if(NULL != m_poVideoRsrcMngr)
    {
        m_poVideoRsrcMngr->vDeviceDisconStatusCb(cou32DeviceHandle);
    }
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclResourceMngrBase::bInitialize()
 ***************************************************************************/
t_Bool spi_tclMySPINResourceMngr::bInitialize()
{
   ETG_TRACE_USR1(("spi_tclMySPINResourceMngr::bInitialize entered"));

   spi_tclMySPINManager *poMySPINManager = spi_tclMySPINManager::getInstance();
   if (NULL != poMySPINManager)
   {
      poMySPINManager->bRegisterObject((spi_tclMySPINRespSession*) this);
   }

   /*lint -esym(40,fvDeviceDispCntxt)fvDeviceDispCntxt Undeclared identifier */
   /*lint -esym(40,_1) _1 identifier */
   /*lint -esym(40,fvSessionStatus)fvSessionStatus Undeclared identifier */
   /*lint -esym(40,_2) _2 Undeclared identifier */

   vRegisterCallbacks(); 

   t_Bool bRet = false;
   if ((NULL != m_poVideoRsrcMngr) && (NULL != m_poAudioResrcMgr))
   {
      if ((true == m_poVideoRsrcMngr->bInitialize()) && (true == m_poAudioResrcMgr->bInitialize()))
      {
         trMySPINRsrcMngrCallback rMySPINRsrcMngrCb;

         rMySPINRsrcMngrCb.fvDeviceDispCntxt = std::bind(&spi_tclMySPINResourceMngr::vUpdateDeviceDisplayCntxt,
                  this,
                  std::placeholders::_1,
                  std::placeholders::_2);

         rMySPINRsrcMngrCb.fvSessionStatus = std::bind(&spi_tclMySPINResourceMngr::vOnSessionStatusInfo,
                  this,
                  std::placeholders::_1);

         rMySPINRsrcMngrCb.fvMySPINInitiateCall = std::bind(&spi_tclMySPINResourceMngr::vInitiateCall,
                  this,
                  std::placeholders::_1,
                  std::placeholders::_2);

         m_poVideoRsrcMngr->vRegForCallbacks(rMySPINRsrcMngrCb);

         bRet = true;
      }
   }
   return bRet;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINResourceMngr::vUninitialize()
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vUnInitialize()
{
   if (NULL != m_poVideoRsrcMngr)
   {
      m_poVideoRsrcMngr->vUnInitialize();
   }
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINResourceMngr::vSetAccessoryDisplayContext()
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vSetAccessoryDisplayContext(const t_U32 cou32DevId, t_Bool bDisplayFlag,
         tenDisplayContext enDisplayContext, const trUserContext& rfrcUsrCntxt)
{
   ETG_TRACE_USR1(("spi_tclMySPINResourceMngr::vSetAccessoryDisplayContext"));
   SPI_INTENTIONALLY_UNUSED(rfrcUsrCntxt);

   if (NULL != m_poVideoRsrcMngr)
   {
      m_poVideoRsrcMngr->vSetAccessoryDisplayContext(cou32DevId, bDisplayFlag, enDisplayContext);
   }
}

/***************************************************************************
** FUNCTION: t_Void spi_tclMySPINResourceMngr::vSelectDevice()
***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vSelectDevice(const trSelectDeviceRequest& corfrSelectReq)
{
   if (NULL != m_poVideoRsrcMngr)
   {
      m_poVideoRsrcMngr->vSelectDevice(corfrSelectReq);
   }    
}

/***************************************************************************
 ** FUNCTION:  t_Void  spi_tclMySPINResourceMngr::vOnSPISelectDeviceResult()
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vOnSPISelectDeviceResult(t_U32 u32DevID, tenDeviceConnectionReq enDeviceConnReq,
         tenResponseCode enRespCode, tenErrorCode enErrorCode)
{
   ETG_TRACE_USR1(("spi_tclMySPINResourceMngr::vOnSPISelectDeviceResult"));

   if((e8DEVCONNREQ_SELECT == enDeviceConnReq) && (e8SUCCESS == enRespCode))
   {
       su32CurSelectedDevId = u32DevID;
   }
   //!Reset the Application states once myspin device is disconnected/deselected
   else
   {
      vUpdateSpeechAppState(e8SPI_SPEECH_END);
      if((e8MSPIN_VR_ACTIVATED == m_enVRState) || (e8MSPIN_VR_ACTIVATING == m_enVRState))
      {
           spi_tclExtCompManager *poExtCompMgr = spi_tclExtCompManager::getInstance();
           spi_tclExtCmdTelephoneIntf *poExtCmdTelephoneIntf = NULL;
           if(NULL != poExtCompMgr)
           {
               poExtCmdTelephoneIntf = poExtCompMgr->poGetCmdTelephoneIntfInst();
               if(NULL != poExtCmdTelephoneIntf)
               {
                   t_String szBTAddress;
                   t_Bool bIsHFP;
                   spi_tclMySPINManager::vGetBTConnInfo(su32CurSelectedDevId, bIsHFP, szBTAddress);
                   poExtCmdTelephoneIntf->vDeActivateExtVR(szBTAddress);
               }
           }
      }
      m_enVRState = e8MSPIN_VR_UNKNOWN;
      su32CurSelectedDevId = 0;
   }   
   
   if (NULL != m_poVideoRsrcMngr)
   {
      m_poVideoRsrcMngr->vOnSPISelectDeviceResult(u32DevID, enDeviceConnReq, enRespCode, enErrorCode);
   }
   if(NULL != m_poAudioResrcMgr)
   {
      m_poAudioResrcMgr->vOnSPISelectDeviceResult(u32DevID, enDeviceConnReq, enRespCode, enErrorCode);
   }
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINResourceMngr::vUpdateDeviceDisplayCntxt()
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vUpdateDeviceDisplayCntxt(t_Bool bDisplayFlag, tenDisplayContextReason enDisplayContextReason)
{
   /*lint -esym(40,fvPostDeviceDisplayContext) fvPostDeviceDisplayContext is not declared */
   ETG_TRACE_USR2(("[DESC]::vUpdateDeviceDisplayCntxt:bDisplayFlag-%d", ETG_ENUM(BOOL, bDisplayFlag)));

   if (NULL != m_rRsrcMngrCb.fvPostDeviceDisplayContext)
   {
      trUserContext rUsrCntxt;
      (m_rRsrcMngrCb.fvPostDeviceDisplayContext)(bDisplayFlag, enDisplayContextReason, tenDiPOEntity::e8DIPO_ENTITY_NA, rUsrCntxt);
   }//if(NULL != m_rRsrcMngrCb.fvDeviceDispCntxt)
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclMySPINResourceMngr::vOnSessionStatusInfo()
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vOnSessionStatusInfo(tenSessionStatus enSessionStatus)
{
   /*lint -esym(40,fvUpdateSessionStatus)fvUpdateSessionStatus Undeclared identifier */
   ETG_TRACE_USR2(("[DESC]::vOnSessionStatusInfo enSessionStatus = %d\n", ETG_ENUM(SESSION_STATUS, enSessionStatus)));
   if (NULL != m_rRsrcMngrCb.fvUpdateSessionStatus)
   {
      (m_rRsrcMngrCb.fvUpdateSessionStatus)(su32CurSelectedDevId, e8DEV_TYPE_MYSPIN, enSessionStatus);
   }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vSetAccessoryDisplayMode(t_U32...
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vSetAccessoryDisplayMode(const t_U32 cu32DeviceHandle, const trDisplayContext corDisplayContext,
         const trDisplayConstraint corDisplayConstraint, const tenDisplayInfo coenDisplayInfo)
{
   ETG_TRACE_USR1(("spi_tclMySPINResourceMngr::vSetAccessoryDisplayMode()"));

   if (NULL != m_poVideoRsrcMngr)
   {
      m_poVideoRsrcMngr->vSetAccessoryDisplayMode(cu32DeviceHandle,
               corDisplayContext,
               corDisplayConstraint,
               coenDisplayInfo);
   }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vInitiateCall(t_U32...
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vInitiateCall(t_String szTelephoneNumber, t_String szDisplayText)

{
   ETG_TRACE_USR1(("spi_tclMySPINResourceMngr::vInitiateCall()"));
   // if (NULL != m_rRsrcMngrCb.fvInitiateCall)
   // {
      // (m_rRsrcMngrCb.fvInitiateCall)(su32CurSelectedDevId, szTelephoneNumber, szDisplayText);
   // }
   spi_tclExtCompManager *poExtCompMgr = spi_tclExtCompManager::getInstance();
   spi_tclExtCmdTelephoneIntf *poExtCmdTelephoneIntf = NULL;
   if(NULL != poExtCompMgr)
   {
       poExtCmdTelephoneIntf = poExtCompMgr->poGetCmdTelephoneIntfInst();
       if(NULL != poExtCmdTelephoneIntf)
       {
           poExtCmdTelephoneIntf->vDialExtended(szTelephoneNumber,szDisplayText,
                                                e8ECNR_NOCHANGE);
       }
   }
}
/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vVoiceSessionCb(t_U32...
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vVoiceSessionCb(tenMySPINVoiceSessionReq enMySPINVoiceSessionReq)

{
   ETG_TRACE_USR1(("spi_tclMySPINResourceMngr::vVoiceSessionCb()"));

   t_Bool bIsHFP = false;
   t_String szBTAddress;
   
   spi_tclExtCompManager *poExtCompMgr = spi_tclExtCompManager::getInstance();
   spi_tclExtCmdTelephoneIntf *poExtCmdTelephoneIntf = NULL;
   if(NULL != poExtCompMgr)
   {
       poExtCmdTelephoneIntf = poExtCompMgr->poGetCmdTelephoneIntfInst();
   }
   spi_tclMySPINManager::vGetBTConnInfo(su32CurSelectedDevId, bIsHFP, szBTAddress);
   tenSpeechAppState enSpeechAppState = e8SPI_SPEECH_UNKNOWN;
   if(false == bIsHFP)
   {
       vUpdateVoiceSessionStatus(e8BTVOICESESSION_STATUS_UNAVAILABLE);
       m_enVRState = e8MSPIN_VR_ENDED;
   }
   else if((e8VOICESESSION_REQUEST_END_USER_EVENT == enMySPINVoiceSessionReq) ||
            (e8VOICESESSION_REQUEST_END_REAL_CALL_EVENT == enMySPINVoiceSessionReq))
   {
       enSpeechAppState = e8SPI_SPEECH_END;
       if(NULL != poExtCmdTelephoneIntf)
       {
            poExtCmdTelephoneIntf->vDeActivateExtVR(szBTAddress);
       }
       m_enVRState = e8MSPIN_VR_ENDED;
   }
   else if((e8VOICESESSION_REQUEST_START_MIC_AND_SPEAKERS == enMySPINVoiceSessionReq) ||
            (e8VOICESESSION_REQUEST_START_MIC_ONLY == enMySPINVoiceSessionReq))
   {
       if(NULL != poExtCmdTelephoneIntf)
       {
            poExtCmdTelephoneIntf->vActivateExtVR(szBTAddress);
       }
       m_enVRState = e8MSPIN_VR_ACTIVATING;
       enSpeechAppState = e8SPI_SPEECH_SPEAKING;
   }
   
   if(true == bIsHFP)
   {
       vUpdateSpeechAppState(enSpeechAppState);
   }
   
   if (NULL != m_poAudioResrcMgr)
   {
      m_poAudioResrcMgr->vSetMspinVRStatus(m_enVRState);
   }

}
/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vUpdateVoiceSessionStatus(t_U32...
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vUpdateVoiceSessionStatus(tenBTVoiceSessionStatus enBTVoiceSessionStatus)
{
   spi_tclMySPINManager *poMySPINManager = spi_tclMySPINManager::getInstance();

   if (NULL != poMySPINManager)
   {
      spi_tclMySPINCmdSession* poMySPINCmdSession = poMySPINManager->poGetSessionInstance();

      if (NULL != poMySPINCmdSession)
      {
         poMySPINCmdSession->vUpdateVoiceSessionStatus(su32CurSelectedDevId, enBTVoiceSessionStatus);
      }
   }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vSetAccessoryAudioContext(t_U32...
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vSetAccessoryAudioContext(const t_U32 cou32DevId,
         const tenAudioContext coenAudioCntxt, t_Bool bReqFlag, const trUserContext& rfrcUsrCntxt)
{
   ETG_TRACE_USR1(("spi_tclMySPINResourceMngr::vSetAccessoryAudioContext"));
   SPI_INTENTIONALLY_UNUSED(rfrcUsrCntxt);

   if (NULL != m_poAudioResrcMgr)
   {
      m_poAudioResrcMgr->vSetAccessoryAudioContext(cou32DevId, coenAudioCntxt, bReqFlag);
   }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vSetAccessoryAppState(...
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vSetAccessoryAppState(tenSpeechAppState enSpeechAppState, 
                                                        tenPhoneAppState enPhoneAppState,
                                                        tenNavAppState enNavAppState, 
                                                        const trUserContext& rfrUserContext)
{
   ETG_TRACE_USR1(("spi_tclMySPINResourceMngr::vSetAccessoryAppState : NAV = %d, PHONE = %d, SPEECH = %d ",
               ETG_ENUM(NAV_APP_STATE,enNavAppState), ETG_ENUM(PHONE_APP_STATE,enPhoneAppState), ETG_ENUM(SPEECH_APP_STATE,enSpeechAppState)));
   SPI_INTENTIONALLY_UNUSED(rfrUserContext);
   // if((e8SPI_SPEECH_SPEAKING == enSpeechAppState) && (e8SPI_SPEECH_SPEAKING == m_rDeviceAppStates.enSpeechAppState))
   // {
       // vUpdateVoiceSessionStatus(e8BTVOICESESSION_STATUS_IDLE);
   // }
   // else
   // {
       // m_rDeviceAppStates.enSpeechAppState = e8SPI_SPEECH_UNKNOWN;
   // }
   
   // if((e8SPI_NAV_ACTIVE == enNavAppState) && (e8SPI_NAV_ACTIVE == m_rDeviceAppStates.enNavAppState) )
   // {
       // // vUpdateVoiceSessionStatus(e8BTVOICESESSION_STATUS_IDLE);
       // // Implementation to be added
   // }
   // else
   // {
       // m_rDeviceAppStates.enNavAppState = e8SPI_NAV_NOT_ACTIVE;
   // }

   if (NULL != m_poAudioResrcMgr)
   {
       m_poAudioResrcMgr->vSetAccessoryAppState(enPhoneAppState);
   }

}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vOnExtVRStateUpdate(tenExtVRState...
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vOnExtVRStateUpdate(t_String szBTAddress,
                                                      tenExtVRState enExtVRState,
                                                      tenVRErrorCode enVRErrorCode)
{
   ETG_TRACE_USR1(("spi_tclMySPINResourceMngr::vOnExtVRStateUpdate entered enExtVRState: %d, enVRErrorCode: %d, "
                   "m_enVRState: %d ", enExtVRState, enVRErrorCode, m_enVRState));
   if(0 != su32CurSelectedDevId)
   {
       tenSpeechAppState enSpeechAppState = e8SPI_SPEECH_UNKNOWN;
       tenBTVoiceSessionStatus enBTVoiceSessionStatus = e8BTVOICESESSION_STATUS_NONE;
       if(e8NO_ERROR == enVRErrorCode)
       {
           if(e8_EXT_VR_STATE_READY == enExtVRState)
           {
               if(m_enVRState == e8MSPIN_VR_ACTIVATING)
               {
                   enSpeechAppState = e8SPI_SPEECH_SPEAKING;
                   enBTVoiceSessionStatus = e8BTVOICESESSION_STATUS_REQUEST_ACCEPTED;
               }
           }
           else if(e8_EXT_VR_STATE_ACTIVE == enExtVRState)
           {
               enSpeechAppState = e8SPI_SPEECH_SPEAKING;
               vUpdateVoiceSessionStatus(e8BTVOICESESSION_STATUS_ACTIVE);
               m_enVRState = e8MSPIN_VR_ACTIVATED;
           }
           else
           {
               enSpeechAppState = e8SPI_SPEECH_END;
               m_enVRState = e8MSPIN_VR_ENDED;
               enBTVoiceSessionStatus  = e8BTVOICESESSION_STATUS_IDLE;
           }
       }
       else if(e8ERROR_PHONE_CALL_ACTIVE == enVRErrorCode)
       {
           enSpeechAppState = e8SPI_SPEECH_END;
           m_enVRState = e8MSPIN_VR_ENDED;
           enBTVoiceSessionStatus = e8BTVOICESESSION_STATUS_UNAVAILABLE;
       }
       else
       {
           enSpeechAppState = e8SPI_SPEECH_END;
           m_enVRState = e8MSPIN_VR_ENDED;
           //Status updated as unavailable as this error is common error received for errors like audio allocation failure,
           //SCO channel could not be opened due to some error etc which are not recoverable.
           enBTVoiceSessionStatus = e8BTVOICESESSION_STATUS_UNAVAILABLE; 
           vUpdateSpeechAppState(enSpeechAppState);
       }

       t_Bool bIsHFP;
       t_String szBTAddress;
       spi_tclMySPINManager::vGetBTConnInfo(su32CurSelectedDevId, bIsHFP, szBTAddress);
       if(e8MSPIN_VR_ACTIVATED != m_enVRState)
       {
           if(true == bIsHFP)
           {
               vUpdateVoiceSessionStatus(enBTVoiceSessionStatus);
           }
       }

       if(e8BTVOICESESSION_STATUS_UNAVAILABLE == enBTVoiceSessionStatus)
       {
           vUpdateSpeechAppState(enSpeechAppState);
       }
       
       if (NULL != m_poAudioResrcMgr)
       {
          m_poAudioResrcMgr->vSetMspinVRStatus(m_enVRState);
       }
    }
}

/***************************************************************************
 ** FUNCTION: tenMspinVRStatus spi_tclMySPINResourceMngr::enGetVRState()
 ***************************************************************************/
tenMspinVRStatus spi_tclMySPINResourceMngr::enGetVRState()
{
   ETG_TRACE_USR1(("spi_tclMySPINResourceMngr::enGetVRState entered m_enVRState: %d ",m_enVRState));
    return m_enVRState;
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vSetVRState()
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vSetVRState(tenMspinVRStatus enVRState)
{
    m_enVRState = enVRState;
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vUpdateSpeechAppState()
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vUpdateSpeechAppState(tenSpeechAppState enSpeechAppState)
{
    if((NULL != m_rRsrcMngrCb.fvPostDeviceAppState) && (NULL != m_rRsrcMngrCb.fvSetDeviceAppState))
    {
        m_rDeviceAppStates.enSpeechAppState = enSpeechAppState;
        m_rDeviceAppStates.enPhoneAppState = e8SPI_PHONE_UNKNOWN;
        m_rDeviceAppStates.enNavAppState = e8SPI_NAV_UNKNOWN;
        
        vAcquireDevAppStateLock();
        m_rRsrcMngrCb.fvSetDeviceAppState(m_rDeviceAppStates.enSpeechAppState,
                 m_rDeviceAppStates.enPhoneAppState, m_rDeviceAppStates.enNavAppState);
        vReleaseDevAppStateLock();
        
        m_rRsrcMngrCb.fvPostDeviceAppState(m_rDeviceAppStates.enSpeechAppState,
                m_rDeviceAppStates.enPhoneAppState, m_rDeviceAppStates.enNavAppState, corEmptyUsrContext);
    }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vMySPINPTTAvailableCb()
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vMySPINPTTAvailableCb(t_Bool bIsPTTAvail)
{
    // Todo check where this callback needs to be used once app side implementation is done
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vPostBTStateUpdate(...
 ***************************************************************************/
t_Void spi_tclMySPINResourceMngr::vPostBTStateUpdate()
{
   if((m_rDeviceAppStates.enSpeechAppState == e8SPI_SPEECH_SPEAKING) || (m_rDeviceAppStates.enSpeechAppState == e8SPI_SPEECH_RECOGNIZING))
   {
      vUpdateSpeechAppState(e8SPI_SPEECH_END);
   }
}
//lint restore
///////////////////////////////////////////////////////////////////////////////
// <EOF>
