/***********************************************************************/
/*!
 * \file   spi_tclMySPINVideoResourceMngr.h
 * \brief  MySPIN Video resource manager
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    MySPIN Video resource manager
 AUTHOR:         Shiva Kumar Gurija
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 04.11.2015  | Shiva Kumar Gurija    | Initial Version
 12.04.2016  | Chaitra Srinivasa     | Adding comments
 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLMYSPINVIDEORESOURCEMNGR_H_
#define _SPI_TCLMYSPINVIDEORESOURCEMNGR_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "spi_tclMySPINRespVideo.h"
#include "spi_tclMySPINRespSession.h"
#include "Lock.h"
#include "SPITypes.h"
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/
class spi_tclMySPINResourceMngr;

/****************************************************************************/
/*!
 * \class   spi_tclMySPINVideoResourceMngr
 * \brief   MySPIN Video resource manager
 *
 *           This class implements the logic to when to request for Video Focus
 *           and how to respond to the VideoFocus request from the Phone.
 *
 ****************************************************************************/
class spi_tclMySPINVideoResourceMngr: public spi_tclMySPINRespVideo, public spi_tclMySPINRespSession
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINVideoResourceMngr::spi_tclMySPINVideoResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINVideoResourceMngr(spi_tclMySPINResourceMngr* poMySPINRsrcMngr)
       * \brief   parameterized  Constructor
       * \param   poMySPINRsrcMngr : [IN] MySPIN resource manager
       * \sa      ~spi_tclMySPINVideoResourceMngr()
       **************************************************************************/
      spi_tclMySPINVideoResourceMngr(spi_tclMySPINResourceMngr* poMySPINRsrcMngr);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINVideoResourceMngr::~spi_tclMySPINVideoResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclMySPINVideoResourceMngr()
       * \brief   Destructor
       * \sa      spi_tclMySPINVideoResourceMngr()
       **************************************************************************/
      ~spi_tclMySPINVideoResourceMngr();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINVideoResourceMngr::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitialize()
       * \brief   To Initialize all the Video resources
       * \retval  t_Bool
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINVideoResourceMngr::vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Void vUninitialize()
       * \brief    To Uninitialize  the Video resources
       * \retval  t_Void
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUnInitialize();

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINVideoResourceMngr::t_Void vRegForCallbacks()
       ***************************************************************************/
      /*!
       * \fn    t_Void vRegForCallbacks(const trMySPINRsrcMngrCallback& corfrMySPINRsrcCbs)
       * \brief Call back for registration
       * \param corfrMySPINRsrcCbs: [IN]Structure for MySPIN resource call back values
       * \retval t_Void
       **************************************************************************/
      t_Void vRegForCallbacks(const trMySPINRsrcMngrCallback& corfrMySPINRsrcCbs);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINVideoResourceMngr::vSetAccessoryDisplayContext()
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetAccessoryDisplayContext(const t_U32 cou32DevId,
       *             t_Bool bDisplayFlag, tenDisplayContext enDisplayContext)
       * \brief   To send accessory display context related info .
       * \pram    cou32DevId    : [IN] Uniquely identifies the target Device.
       * \param   bDisplayFlag  : [IN] Display flag
       * \pram    enDisplayContext : [IN] display context
       * \retval  t_Void
       **************************************************************************/
      t_Void vSetAccessoryDisplayContext(const t_U32 cou32DevId, t_Bool bDisplayFlag,
               tenDisplayContext enDisplayContext);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINVideoResourceMngr::vSelectDevice()
       ***************************************************************************/
      /*!
       * \fn      vSelectDevice(const trSelectDeviceRequest& corfrSelectReq)
       * \brief   To send accessory display context related info .
       * \pram    corfrSelectReq  : [IN] Selection request details.
       * \retval  t_Void
       **************************************************************************/
      t_Void vSelectDevice(const trSelectDeviceRequest& corfrSelectReq);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINVideoResourceMngr::vOnSPISelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSPISelectDeviceResult(t_U32 u32DevID,
       *             tenDeviceConnectionReq enDevConnReq,
       *             tenResponseCode enRespCode,
       *             tenErrorCode enErrorCode)
       * \brief   Called when SelectDevice operation is complete & with the result
       *           of the operation.
       * \param   u32DevID : [IN] Unique handle of selected device
       * \param   enDevConnReq: [IN]  Connection request type for the device
       * \param   enRespCode: [IN]  Response code enumeration
       * \param   enErrorCode: [IN]  Error code enumeration
       * \retval  None
       **************************************************************************/
      t_Void vOnSPISelectDeviceResult(t_U32 u32DevID, tenDeviceConnectionReq enDevConnReq, tenResponseCode enRespCode,
               tenErrorCode enErrorCode);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINVideoResourceMngr::vSetAccessoryDisplayMode(t_U32...
       ***************************************************************************/
      /*!
       * \fn     vSetAccessoryDisplayMode()
       * \brief  Accessory display mode update request.
       * \param  [IN] cu32DeviceHandle      : Uniquely identifies the target Device.
       * \param  [IN] corDisplayContext : Display context info
       * \param  [IN] corDisplayConstraint : DiDisplay constraint info
       * \param  [IN] coenDisplayInfo       : Display info flag
       * \retval  t_Void
       * \sa
       **************************************************************************/
      t_Void vSetAccessoryDisplayMode(const t_U32 cu32DeviceHandle, const trDisplayContext corDisplayContext,
               const trDisplayConstraint corDisplayConstraint, const tenDisplayInfo coenDisplayInfo);
               
      /***************************************************************************
      ** FUNCTION:  t_Bool spi_tclMySPINVideoResourceMngr::bGetAccVideoFocusState()
      ***************************************************************************/
      /*!
      * \fn      t_Bool bGetAccVideoFocusState(tenDisplayContext enDisplayContext,
      *                 t_Bool bDisplayFlag,tenMspinVideoFocusState& rfenVideoFocusState)
      * \brief   Method to get the current HMI requesting Video Focus state from the
      *          configuration file. 
      * \param   enDisplayContext : [IN] Accessory Display Context
      * \param   bDisplayFlag   : [IN] TRUE - HMI is requesting for the Video Focus
      *                          FALSE - HMI screen with the received context has lost focus
      * \param   rfenVideoFocusState : [OUT] HMI requested Video focus state
      * \retval  t_Bool - TRUE - if the received display context is available in the config
      *                   FALSE - if the received display context is not available in the config
      **************************************************************************/
      t_Bool bGetAccVideoFocusState(tenDisplayContext enDisplayContext,
         t_Bool bDisplayFlag, tenMspinVideoFocusState& rfenVideoFocusState);
      
      /***************************************************************************
      ** FUNCTION:  t_Bool spi_tclMySPINVideoResourceMngr::bGetMDVideoFocusState()
      ***************************************************************************/
      /*!
      * \fn      t_Bool bGetMDVideoFocusState(tenMspinVideoFocusState enCurMDFocusState,
      *                 tenMspinVideoFocusState enNewAccFocusState,
      *                 tenMspinVideoFocusState& rfenNewMDFocusState)
      * \brief   Method to get the New MD Focus state based on the Current Hu & MD focus states
      * \param   enCurMDFocusState       : [IN] MD Current Focus State
      * \param   enNewAccFocusState      : [IN] Accessory Current Focus State
      * \param   rfenNewMDFocusState : [OUT] MD New Focus State
      * \retval  t_Bool - TRUE - if the received focus states are available in the config
      *                   FALSE - if the received ocus states are not available in the config
      **************************************************************************/
      t_Bool bGetMDVideoFocusState(tenMspinVideoFocusState enCurMDFocusState,
         tenMspinVideoFocusState enNewAccFocusState,
         tenMspinVideoFocusState& rfenNewMDFocusState);
      
      /***************************************************************************
      ** FUNCTION:  t_Bool spi_tclMySPINVideoResourceMngr::bGetAccRespType()
      ***************************************************************************/
      /*!
      * \fn      t_Bool bGetAccRespType(tenMspinVideoResponse& rfenRespType)
      * \brief   Method to get the Accessory Response for the MD Focus request
      *          for PROJECTED_MODE
      * \param   rfenRespType    : [IN] Accessory Response for the Focus request
      * \retval  t_Bool - TRUE - if the current display context is available in the config
      **************************************************************************/
      t_Bool bGetAccRespType(tenDisplayContext enCurDisplayContext,
               tenMspinVideoFocusState enCurMDFocusState, tenMspinVideoResponse& rfenRespType);               

      /***************************************************************************
      ** FUNCTION:  t_Bool spi_tclMySPINVideoResourceMngr::vDeviceDisconStatusCb()
      ***************************************************************************/
      /*!
      * \fn      t_Bool vDeviceDisconStatusCb()
      * \brief   Method to get get deviceconnection status
      * \param   cou32DeviceHandle    : [IN] Device handle
      * \retval  t_Void
      **************************************************************************/
      t_Void vDeviceDisconStatusCb(const t_U32 cou32DeviceHandle);

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINVideoResourceMngr(const spi_tclMySPINVideoResourceMngr...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINVideoResourceMngr(
       *                             const spi_tclMySPINVideoResourceMngr& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINVideoResourceMngr()
       ***************************************************************************/
      spi_tclMySPINVideoResourceMngr(const spi_tclMySPINVideoResourceMngr& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINVideoResourceMngr& operator=( const spi_tcl...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINVideoResourceMngr& operator=(
       *                          const spi_tclMySPINVideoResourceMngr& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINVideoResourceMngr(const spi_tclMySPINVideoResourceMngr& otrSrc)
       ***************************************************************************/
      spi_tclMySPINVideoResourceMngr& operator=(const spi_tclMySPINVideoResourceMngr& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINVideoResourceMngr::spi_tclMySPINVideoResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINVideoResourceMngr()
       * \brief   Constructor
       * \sa      ~spi_tclMySPINVideoResourceMngr()
       **************************************************************************/
      spi_tclMySPINVideoResourceMngr();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINVideoResourceMngr::t_Void vSendSessionStatusUpdate(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSendSessionStatusUpdate(tenSessionStatus enSessionStatus)
       * \brief Method to send session status update
       * \param enSessionStatus: [IN]To store the status of the session
       * \retval t_Void
       * \sa
       **************************************************************************/
      t_Void vSendSessionStatusUpdate(tenSessionStatus enSessionStatus);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINVideoResourceMngr::t_Void vSendDeviceDispCntxtUpdate(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSendDeviceDispCntxtUpdate(t_Bool bDisplayFlag,
       *                                  tenDisplayContextReason enDisplayContextReason)
       * \brief Method to send device display context update
       * \param bDisplayFlag: [IN]Display flag
       * \param enDisplayContextReason : Reason for device display context update.
       * \retval t_Void
       * \sa
       **************************************************************************/
      t_Void vSendDeviceDispCntxtUpdate(t_Bool bDisplayFlag, tenDisplayContextReason enDisplayContextReason);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINVideoResourceMngr::t_Void vFirstFBRenderedCallback(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vFirstFBRenderedCallback(const t_U32 u32DeviceID)
       * \brief Call back for first rendered FB
       * \param u32DeviceID: [IN]Device ID
       * \retval t_Void
       * \sa
       **************************************************************************/
      t_Void vFirstFBRenderedCallback(const t_U32 u32DeviceID);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINVideoResourceMngr::t_Void vPlaybackStartOnLaunchCallback()
       ***************************************************************************/
      /*!
       * \fn    t_Void vPlaybackStartOnLaunchCallback(const t_U32 u32DeviceID)
       * \brief Call back to start play back on launch
       * \param u32DeviceID: [IN]Device ID
       * \retval t_Void
       * \sa
       **************************************************************************/
      t_Void vPlaybackStartOnLaunchCallback(const t_U32 u32DeviceID);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINVideoResourceMngr::t_Void vLauncherAppInactiveCb(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vLauncherAppInactiveCb(t_Bool bIsInActive)
       * \brief Call back for launcher app inactive
       * \param bIsInActive: [IN]To check whether app is inactive or not
       * \retval t_Void
       * \sa
       **************************************************************************/
      t_Void vLauncherAppInactiveCb(t_Bool bIsInActive);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINVideoResourceMngr::t_Void vAppTransitionCb(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vAppTransitionCb(t_Bool bIsActive)
       * \brief Call back for app transition
       * \param bIsActive: [IN]To check whether app is active or not
       * \retval t_Void
       * \sa
       **************************************************************************/
      t_Void vAppTransitionCb(t_Bool bIsActive);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINVideoResourceMngr::t_Void vInitiateCallCb(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vInitiateCallCb(t_String szTelePhoneNum,
       *                               t_String szDisplayText)
       * \brief Call back for initiating a call
       * \param szTelePhoneNum: [IN]String to store the telephone number
       * \param szDisplayText: [IN]String to store the displayed text
       * \retval t_Void
       * \sa
       **************************************************************************/
      t_Void vInitiateCallCb(t_String szTelePhoneNum, t_String szDisplayText);
      
      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclMySPINVideoResourceMngr::vSetVideoFocus()
      ***************************************************************************/
      /*!
      * \fn      t_Void vSetVideoFocus(tenMspinVideoFocus enVideoFocus)
      * \brief   Method to handle video focus
      * \param   cou32DevId : [IN] Device ID
      * \param   enVideoFocus : [IN] Video Focus Mode
      * \retval  t_Void
      **************************************************************************/
      t_Void vSetVideoFocus(const t_U32 cou32DevId,tenMspinVideoFocus enVideoFocus);      

      //MySPIN resource manager pointer
      spi_tclMySPINResourceMngr* m_poMySPINRsrcMngr;

      trMySPINRsrcMngrCallback m_rMySPINRsrcMngrCb;

      //Flasg to check if First Frame Buffer is rendered
      t_Bool m_bIsFirstFrameRendered;

      // To check if mySPIN session is started
      t_Bool m_bMySPINSessionActive;

      t_Bool m_bIsPlaybackRequested;

      //Lock to protect first frame buffer update message
      Lock m_fBUpateLock;
      
      //! Current Video Focus State of HU
      tenMspinVideoFocusState m_enCurMDFocusState;

      Lock m_oCurMDFocusStateLock;

      //! To contain constraint behavior
      tenDiPOConstraint m_enGrantConstraint;     

      //! Current Display context of HMI
      tenDisplayContext m_enCurAccDispCntxt;      
      
      //! Holds last state
      tenDiPOTransferType m_enPrevTransferType;      
      
      //! Lock for Initial Video Focus
      Lock  m_oVideoSetupLock;      
      
      //! Device ID
      t_U32 m_u32SelectedDeviceID;
      
      tenSessionStatus m_enSessionStatus;
      
      t_U32 m_u32SessionErrDevID;
   

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

}; //class spi_tclMySPINVideoResourceMngr

#endif //_SPI_TCLMYSPINVIDEORESOURCEMNGR_H_
///////////////////////////////////////////////////////////////////////////////
// <EOF>
