/***********************************************************************/
/*!
 * \file   spi_tclMySPINAudioResourceMngr.h
 * \brief  MySPIN Audio resource manager
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    MySPIN Audio resource manager
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 25.07.2016  | tch5kor    | Initial Version

 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLMYSPINAUDIORESOURCEMNGR_H_
#define _SPI_TCLMYSPINAUDIORESOURCEMNGR_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "spi_tclMySPINRespAudio.h"
#include "Lock.h"
#include "spi_tclMySPINRespAudio.h"
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/
class spi_tclMySPINResourceMngr;

/****************************************************************************/
/*!
 * \class   spi_tclMySPINAudioResourceMngr
 * \brief   MySPIN Audio resource manager
 *
 *           This class implements the logic to when to accept/reject audio request for phone.
 *
 ****************************************************************************/
class spi_tclMySPINAudioResourceMngr: public spi_tclMySPINRespAudio
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAudioResourceMngr::spi_tclMySPINAudioResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINAudioResourceMngr(spi_tclMySPINResourceMngr* poMySPINRsrcMngr)
       * \brief   parameterized  Constructor
       * \param   poMySPINRsrcMngr : [IN] MySPIN resource manager
       * \sa      ~spi_tclMySPINAudioResourceMngr()
       **************************************************************************/
      spi_tclMySPINAudioResourceMngr(spi_tclMySPINResourceMngr* poMySPINRsrcMngr);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAudioResourceMngr::~spi_tclMySPINAudioResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclMySPINAudioResourceMngr()
       * \brief   Destructor
       * \sa      spi_tclMySPINAudioResourceMngr()
       **************************************************************************/
      ~spi_tclMySPINAudioResourceMngr();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINAudioResourceMngr::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitialize()
       * \brief   To Initialize all the Video resources
       * \retval  t_Bool
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINAudioResourceMngr::vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Void vUninitialize()
       * \brief    To Uninitialize  the Video resources
       * \retval  t_Void
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUnInitialize();

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINAudioResourceMngr::t_Void vRegForCallbacks()
       ***************************************************************************/
      /*!
       * \fn    t_Void vRegForCallbacks(const trMySPINRsrcMngrCallback& corfrMySPINRsrcCbs)
       * \brief Call back for registration
       * \param corfrMySPINRsrcCbs: [IN]Structure for MySPIN resource call back values
       * \retval t_Void
       **************************************************************************/
      t_Void vRegForCallbacks(const trMySPINRsrcMngrCallback& corfrMySPINRsrcCbs);

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclMySPINAudioResourceMngr::vSetAccessoryAudioContext(...)
      ***************************************************************************/
      /*!
      * \fn     vSetAccessoryAudioContext(const t_U32 cou32DevId, const t_U8 cu8AudioCntxt
      *           t_Bool bDisplayFlag)
      * \brief   To send accessory audio context related info .
      * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
      * \param   cu8AudioCntxt : [IN] Audio Context
      * \pram    bReqFlag : [IN] Request/ Release flag
      * \retval  t_Void
      **************************************************************************/
      t_Void vSetAccessoryAudioContext(const t_U32 cou32DevId, const tenAudioContext coenAudioCntxt, t_Bool bReqFlag);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINAudioResourceMngr::vOnSPISelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSPISelectDeviceResult(t_U32 u32DevID,
       *             tenDeviceConnectionReq enDevConnReq,
       *             tenResponseCode enRespCode,
       *             tenErrorCode enErrorCode)
       * \brief   Called when SelectDevice operation is complete & with the result
       *           of the operation.
       * \param   u32DevID : [IN] Unique handle of selected device
       * \param   enDevConnReq: [IN]  Connection request type for the device
       * \param   enRespCode: [IN]  Response code enumeration
       * \param   enErrorCode: [IN]  Error code enumeration
       * \retval  None
       **************************************************************************/
      t_Void vOnSPISelectDeviceResult(t_U32 u32DevID, tenDeviceConnectionReq enDevConnReq, tenResponseCode enRespCode,
               tenErrorCode enErrorCode);
      
      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAudioResourceMngr::t_Void vSetAccessoryAppState(...)
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetAccessoryAppState(tenPhoneAppState)
       * \brief   Method to set accessory app state
       * \retval  t_Void
       ***************************************************************************/
      t_Void vSetAccessoryAppState(tenPhoneAppState enPhoneAppState);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAudioResourceMngr::t_Void vSetMspinVRStatus(...)
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetMspinVRStatus(tenMspinVRStatus enIsVRActive)
       * \brief   Method to check whether myspin VR is active
       * \retval  t_Void
       ***************************************************************************/
      t_Void vSetMspinVRStatus(tenMspinVRStatus enIsVRActive);

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAudioResourceMngr(const spi_tclMySPINAudioResourceMngr...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINAudioResourceMngr(
       *                             const spi_tclMySPINAudioResourceMngr& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINVideoResourceMngr()
       ***************************************************************************/
      spi_tclMySPINAudioResourceMngr(const spi_tclMySPINAudioResourceMngr& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAudioResourceMngr& operator=( const spi_tcl...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINVideoResourceMngr& operator=(
       *                          const spi_tclMySPINVideoResourceMngr& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINVideoResourceMngr(const spi_tclMySPINVideoResourceMngr& otrSrc)
       ***************************************************************************/
      spi_tclMySPINAudioResourceMngr& operator=(const spi_tclMySPINAudioResourceMngr& corfoSrc);


      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINAudioResourceMngr::vAudioRequestCb(...
       ***************************************************************************/
      /*!
       * \fn     vAudioRequestCb(t_U32 u32DeviceId)
       * \brief  Callback for audio request from phone
       * \param  [u32DeviceId]: Unique device Id
       * \parma
       * \retval t_Void
       **************************************************************************/
      t_Void vAudioRequestCb(t_U32 u32DeviceId, tenAudioCtrlCommand enCommand, t_U32 u32RequestID,
               tenMySPINAudioType enType);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINAudioResourceMngr::vHandleAudioCmd(...
       ***************************************************************************/
      /*!
       * \fn     vHandleAudioCmd(trMySPINAudioCmd rMySPINAudioCmd)
       * \brief  Method to handle audio commands from phone
       * \param  [rMySPINAudioCmd]: Structure containing audio command information
       * \parma
       * \retval t_Void
       **************************************************************************/
      t_Void vHandleAudioCmd(trMySPINAudioCmd& rMySPINAudioCmd);
      


      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAudioResourceMngr::spi_tclMySPINAudioResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINAudioResourceMngr()
       * \brief   Constructor
       * \sa      ~spi_tclMySPINAudioResourceMngr()
       **************************************************************************/
      spi_tclMySPINAudioResourceMngr();

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINAudioResourceMngr::vHandleAudioCmd(...
       ***************************************************************************/
      /*!
       * \fn     vUpdateVRState()
       * \brief  Method to update Vr state
       * \param  cou32DevId : Device handle
       * \param  enBTVoiceSessionStatus : BT VR session status
       * \parma
       * \retval t_Void
       **************************************************************************/
      t_Void vUpdateVRState(const t_U32 cou32DevId, tenBTVoiceSessionStatus enBTVoiceSessionStatus);

      //MySPIN resource manager pointer
      spi_tclMySPINResourceMngr* m_poMySPINRsrcMngr;

      //IVI audio mapping
      std::map<tenAudioContext,tenIVIAudioType> m_audioMap;

      //Store Current Audio Context
      tenIVIAudioType m_curIVIAudioType;

      //Response Looup Map
      std::map<tMySPINAudioReqTuple,tMySPINResponseAudDirpair> m_AudioResponseMap;
      
      //Store the audio type of a particular request
      std::map<t_U32, tenMySPINAudioType> m_mapAudioType;
      
      //Lock for m_mapAudioType
      Lock m_oAudioType;
      
      tenPhoneAppState m_enPhoneAppState;
      
      tenMspinVRStatus m_enIsVRActive;

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

}; //class spi_tclMySPINVideoResourceMngr

#endif //_SPI_TCLMYSPINVIDEORESOURCEMNGR_H_
///////////////////////////////////////////////////////////////////////////////
// <EOF>
