/*!
 *******************************************************************************
 * \file             spi_tclMySPINDataService.h
 * \brief            MySPIN Data Service class
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    MySPIN Data Service class implements Data Service Info Management for
 MySPIN capable devices. This class must be derived from base Data Service class.
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification


 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLMYSPINLOCATION_H_
#define SPI_TCLMYSPINLOCATION_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "mySPINTypes.h"
#include "spi_tclDataServiceDevBase.h"
/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/
static t_U32 su32CurSelectedDevId = 0;
/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/


class spi_tclMySPINDataService :
   public spi_tclDataServiceDevBase  //! Base Connection Class
{
public:
   /***************************************************************************
    *********************************PUBLIC*************************************
    ***************************************************************************/

   /***************************************************************************
    ** FUNCTION:  spi_tclMySPINDataService::spi_tclMySPINDataService(const trDataServiceCb...))
    ***************************************************************************/
   /*!
    * \fn     spi_tclMySPINDataService(const trDataServiceCb& rfcorDataServiceCb)
    * \brief  Parameterised Constructor
    * \param  rfcorDataServiceCb: [IN] Structure containing callbacks to
    *            DataService Manager.
    * \sa     ~spi_tclMySPINDataService()
    **************************************************************************/
   spi_tclMySPINDataService(const trDataServiceCb& rfcorDataServiceCb);

   /***************************************************************************
    ** FUNCTION:  spi_tclMySPINDataService::~spi_tclMySPINDataService
    ***************************************************************************/
   /*!
    * \fn     ~spi_tclMySPINDataService()
    * \brief  Destructor
    * \sa     spi_tclMySPINDataService()
    **************************************************************************/
   virtual ~spi_tclMySPINDataService();


   /***** Start of Methods overridden from spi_tclDataServiceDevBase *********/

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclMySPINDataService::bInitialise();
   ***************************************************************************/
   /*!
   * \fn      bInitialise()
   * \brief   Method to initialises the service handler. (Performs initialisations which
   *          are not device specific.)
   *          Mandatory interface to be implemented.
   * \retval  t_Bool: TRUE - If ServiceHandler is initialised successfully, else FALSE.
   * \sa      bUninitialise()
   ***************************************************************************/
   virtual t_Bool bInitialise();

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclMySPINDataService::bUninitialise();
   ***************************************************************************/
   /*!
   * \fn      bUninitialise()
   * \brief   Method to uninitialise the service handler.
   *          Mandatory interface to be implemented.
   * \retval  t_Bool: TRUE - If ServiceHandler is uninitialised successfully, else FALSE.
   * \sa      bInitialise()
   ***************************************************************************/
   virtual t_Bool bUninitialise();

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclMySPINDataService::vOnSelectDeviceResult(t_U32...)
    ***************************************************************************/
   /*!
    * \fn      vOnSelectDeviceResult(t_U32 u32DeviceHandle, tenDeviceConnectionReq coenConnReq,
    *           tenResponseCode coenRespCode)
    * \brief   Called when a device is selected.
    *          Mandatory interface to be implemented.
    * \param   u32DeviceHandle: [IN] Unique handle of selected device
    * \param   coenConnReq    : [IN] Identifies the Connection Request.
    * \param   coenRespCode   : [IN] Response code. Success/Failure
    * \retval  None
    * \sa      vOnDeselectDevice()
    **************************************************************************/
   virtual t_Void vOnSelectDeviceResult(t_U32 u32DeviceHandle, tenDeviceConnectionReq coenConnReq,
           tenResponseCode coenRespCode);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclMySPINDataService::vOnDeselectDeviceResult(t_U32...)
    ***************************************************************************/
   /*!
    * \fn      vOnDeselectDeviceResult(t_U32 u32DeviceHandle)
    * \brief   Called when currently selected device is de-selected.
    *          Mandatory interface to be implemented.
    * \param   [IN] u32DeviceHandle: Unique handle of selected device
    * \retval  None
    * \sa      vOnSelectDevice()
    **************************************************************************/
   virtual t_Void vOnDeselectDeviceResult(t_U32 u32DeviceHandle);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclMySPINDataService::vOnDeselectDeviceResult(t_U32...)
    ***************************************************************************/
   /*!
    * \fn      vOnDeselectDeviceResult(t_U32 u32DeviceHandle)
    * \brief   Called when currently selected device is de-selected.
    *          Mandatory interface to be implemented.
    * \param   [IN] u32DeviceHandle: Unique handle of selected device
    * \retval  None
    * \sa      vOnSelectDevice()
    **************************************************************************/
   t_Void vStartLocationData(const std::vector<tenNmeaSentenceType>& rfcoNmeaSentencesList,
         t_U8 u8RequestedBy);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclMySPINDataService::vOnDeselectDeviceResult(t_U32...)
    ***************************************************************************/
   /*!
    * \fn      vOnDeselectDeviceResult(t_U32 u32DeviceHandle)
    * \brief   Called when currently selected device is de-selected.
    *          Mandatory interface to be implemented.
    * \param   [IN] u32DeviceHandle: Unique handle of selected device
    * \retval  None
    * \sa      vOnSelectDevice()
    **************************************************************************/
   t_Void vStopLocationData(const std::vector<tenNmeaSentenceType>& rfcoNmeaSentencesList,
         t_U8 u8RequestedBy);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclMySPINDataService::vOnData(
                 const trVehicleData& rfcoVehicleData)
   ***************************************************************************/
   /*!
   * \fn      vOnData(const trVehicleData& rfcoVehicleData)
   * \brief   Method to receive Vehicle data.
   *          Optional interface to be implemented.
   * \param   rfcoVehicleData: [IN] Vehicle data
   * \retval  None
   ***************************************************************************/
   t_Void vOnData(const trVehicleData& rfcoVehicleData, t_Bool bSolicited);


   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclMySPINDataService::vOnData(const trSensorData&...)
   ***************************************************************************/
   /*!
   * \fn      vOnData(const trSensorData& rfcorSensorData)
   * \brief   Method to receive Sensor data.
   *          Optional interface to be implemented.
   * \param   rfcorSensorData: [IN] Sensor data
   * \retval  None
   ***************************************************************************/
   t_Void vOnData(const trSensorData& rfcorSensorData);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclMySPINDataService::vOnData(const trSensorData&...)
   ***************************************************************************/
   /*!
   * \fn      vOnData(const trSensorData& rfcorSensorData)
   * \brief   Method to receive Sensor data.
   *          Optional interface to be implemented.
   * \param   rfcorSensorData: [IN] Sensor data
   * \retval  None
   ***************************************************************************/
   t_Void vOnVehDataCB(t_U32 u32DeviceHandle, t_Bool bStart, t_U8 u8VehDataType);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclMySPINDataService::vOnData(const trGPSData& rfcorGpsData)
   ***************************************************************************/
   /*!
   * \fn      vOnData(const trGPSData& rfcorGpsData)
   * \brief   Method to receive GPS data.
   *          Optional interface to be implemented.
   * \param   rfcorGpsData: [IN] GPS data
   * \retval  None
   ***************************************************************************/
   t_Void vOnData(const trGPSData& rfcorGpsData);

   t_Void vSelectDevice(const t_U32 cou32DevId,
            tenDeviceConnectionReq enConnReq);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclMySPINDataService::vSetLocDataAvailablility(t_Bool...)
   ***************************************************************************/
   /*!
   * \fn      vSetLocDataAvailablility(t_Bool bLocDataAvailable)
   * \brief   Interface to set the availability of LocationData
   * \param   rfrDataServiceConfigInfo: the structure consists of values TRUE
   *           for location data, dead reckoning data, environment data,
   *           gear status, accelerometer data and gyroscope data if available,
   *           FALSE if not.
   * \retval  None
   **************************************************************************/
   virtual t_Void vSetSensorDataAvailablility(
         const trDataServiceConfigData& rfrDataServiceConfigInfo);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclMySPINDataService::vPostGPRMCDataStatusValues()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostGPRMCDataStatusValues()
    * \brief   Called when GPRMC Data Status Values are sent by Nav Data Client Handler.
    *          Mandatory interface to be implemented.
    * \param   [IN]u32DeviceId : Device ID
    * \param   [IN]u8GPRMCDataStatusValues : GPRMC Data Status Values i.e. A, V, X
    * \sa      None
    **************************************************************************/
   t_Void vPostGPRMCDataStatusValues(t_U32 u32DeviceId,t_U8 u8GPRMCDataStatusValues);

private:

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDataServiceDevBase::vOnData(const trSensorData&...)
   ***************************************************************************/
   /*!
   * \fn      vOnData(const trSensorData& rfcorSensorData)
   * \brief   Method to receive Sensor data.
   *          Optional interface to be implemented.
   * \param   rfcorSensorData: [IN] Sensor data
   * \retval  None
   ***************************************************************************/
   t_Void vPostSetLocDataSubscription(t_Bool bSubscriptionOn);

   /***************************************************************************
    ** DataService callbacks structure
    ***************************************************************************/
   trDataServiceCb            m_rDataServiceCb;

   /***************************************************************************
    ** List of NMEA sentences to be transferred in LocationData
    ***************************************************************************/
   std::vector<tenNmeaSentenceType>   m_NmeaSentencesList;

   //! Member to store who requested location data
   t_U8 m_u8RequestedBy;

   tvVehicleDataRequestCb m_vVehicleDataRequestCb;

   //Member to store vehicle data
   trVehicleData m_rVehicleData;

   //Member to store sensor data
   trSensorData m_rSensorData;
   
   //Variable to specify whether location data subscribed or not
   t_Bool m_bReqLocDataSubscription;
   
   t_Bool m_bIsNativeNavigationEnabled;

   /***************************************************************************
    ** Structure containing coordinate system
    ***************************************************************************/
   tenGeoCoordinateSystemType m_enGeoCoordinateSystemType;

   /****************************************************************************
   ** Config info
   *****************************************************************************/
   trDataServiceConfigData m_rMySPINDataServiceConfigData;
};
#endif // SPI_TCLMYSPINLOCATION_H_
