/*!
 *******************************************************************************
 * \file         spi_tclMySPINConnMngr.cpp
 * \brief        mySPIN Connection class
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    
 AUTHOR:         grikor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 12.04.2016  | Chaitra Srinivasa     | Trace message clean up
 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "mySPINTypes.h"
#include "spi_tclMySPINConnection.h"
#include "spi_tclMySPINAOAPConnection.h"
#include "spi_tclMySPINIAPConnection.h"
#include "spi_tclMySPINConnMngr.h"
#include "spi_tclMediator.h"
#include "spi_tclMySPINManager.h"
//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_CONNECTIVITY
#include "trcGenProj/Header/spi_tclMySPINConnMngr.cpp.trc.h"
#endif
#endif

static t_U16 m_u16VehicleType = 0xffff;
static t_String m_szVehicleManufacturerName;
static t_String m_szVehicleManufacturerScope;
/***************************************************************************
 *********************************PUBLIC*************************************
 ***************************************************************************/

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINConnMngr::spi_tclMySPINConnMngr
 ***************************************************************************/
spi_tclMySPINConnMngr::spi_tclMySPINConnMngr(): m_enMySPINError(e8MSPIN_ERROR_UNKNOWN)
{
   ETG_TRACE_USR1((" spi_tclMySPINConnMngr::spi_tclMySPINConnMngr()"));

   for (t_U8 u8Ind = 0; u8Ind < NUM_MYSPIN_CONN_HNDLRS; u8Ind++)
   {
      m_apoMySPINConnHndlrs[u8Ind] = NULL;
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINConnMngr::~spi_tclMySPINConnMngr
 ***************************************************************************/
spi_tclMySPINConnMngr::~spi_tclMySPINConnMngr()
{
   ETG_TRACE_USR1((" spi_tclMySPINConnMngr::~spi_tclMySPINConnMngr()"));

   m_mapDevInfo.clear();

   m_mapOTGDevice.clear();

   for (t_U8 u8Ind = 0; u8Ind < NUM_MYSPIN_CONN_HNDLRS; u8Ind++)
   {
      m_apoMySPINConnHndlrs[u8Ind] = NULL;
   }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINConnMngr::vRegisterCallbacks
 ***************************************************************************/
t_Void spi_tclMySPINConnMngr::vRegisterCallbacks(trConnCallbacks &rfrConnCallbacks)
{
   m_rConnCbs = rfrConnCallbacks;
}

/***************************************************************************
 ** FUNCTION: t_Bool spi_tclConnection::bInitializeConnection
 ***************************************************************************/
t_Bool spi_tclMySPINConnMngr::bInitializeConnection()
{
   ETG_TRACE_USR1((" spi_tclMySPINConnMngr::bInitializeConnection"));

   t_Bool bRet = false;

   m_apoMySPINConnHndlrs[e8DEVTYPE_AOAP] = new (std::nothrow) spi_tclMySPINAOAPConnection();
   SPI_NORMAL_ASSERT(NULL == m_apoMySPINConnHndlrs[e8DEVTYPE_AOAP]);

   m_apoMySPINConnHndlrs[e8DEVTYPE_IAP] = new (std::nothrow) spi_tclMySPINIAPConnection();
   SPI_NORMAL_ASSERT(NULL == m_apoMySPINConnHndlrs[e8DEVTYPE_IAP]);

   trMySPINConnCbs rMySPINConnCbs;

   rMySPINConnCbs.fvSelectDeviceResult = std::bind(&spi_tclMySPINConnMngr::vSelectDeviceResultCb,
            this,
            SPI_FUNC_PLACEHOLDERS_3);

   rMySPINConnCbs.fvSelectDeviceError = std::bind(&spi_tclMySPINConnMngr::vSetSelectErrorCb,
            this,
            SPI_FUNC_PLACEHOLDERS_2);

   for (t_U8 u8Ind = 0; u8Ind < NUM_MYSPIN_CONN_HNDLRS; u8Ind++)
   {
      if (NULL != m_apoMySPINConnHndlrs[u8Ind])
      {
         bRet = m_apoMySPINConnHndlrs[u8Ind]->bInitializeConnection() || bRet;
         m_apoMySPINConnHndlrs[u8Ind]->vRegisterCallbacks(rMySPINConnCbs);
      }

   }
   spi_tclMySPINManager* poMySPINMngr = spi_tclMySPINManager::getInstance();
   if (NULL != poMySPINMngr)
   {
      bRet = poMySPINMngr->bRegisterObject((spi_tclMySPINRespSession*) this);
   }
   return bRet;
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclConnection::vUnInitializeConnection
 ***************************************************************************/
t_Void spi_tclMySPINConnMngr::vUnInitializeConnection()
{
   ETG_TRACE_USR1((" spi_tclMySPINConnMngr::vUnInitializeConnection"));

   for (t_U8 u8Ind = 0; u8Ind < NUM_MYSPIN_CONN_HNDLRS; u8Ind++)
   {
      if (NULL != m_apoMySPINConnHndlrs[u8Ind])
      {
         m_apoMySPINConnHndlrs[u8Ind]->vUnInitializeConnection();
      }
      RELEASE_MEM(m_apoMySPINConnHndlrs[u8Ind]);
   }
   m_enMySPINError = e8MSPIN_ERROR_UNKNOWN;
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINConnMngr::vOnLoadSettings
 ***************************************************************************/
t_Void spi_tclMySPINConnMngr::vOnLoadSettings(trHeadUnitInfo &rfrheadUnitInfo, tenCertificateType enCertificateType)
{
   SPI_INTENTIONALLY_UNUSED(enCertificateType)
   ETG_TRACE_USR1((" spi_tclMySPINConnMngr::vOnLoadSettings"));

   for (t_U8 u8Ind = 0; u8Ind < NUM_MYSPIN_CONN_HNDLRS; u8Ind++)
   {
      if ((NULL != m_apoMySPINConnHndlrs[u8Ind]) && (NULL != m_poConnSettings))
      {
         vSetVehicleManufactureInfo(0);
         trVehicleInfo rVehicleInfo;
         rVehicleInfo.szManufacturer = m_szVehicleManufacturerName;
         rVehicleInfo.szVehicleVariant = m_szVehicleManufacturerScope;
         m_apoMySPINConnHndlrs[u8Ind]->vSetConnsettingsInstance(m_poConnSettings);
         m_apoMySPINConnHndlrs[u8Ind]->vOnLoadSettings(rfrheadUnitInfo,rVehicleInfo,m_u16VehicleType);
      }

   }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINConnMngr::vOnSaveSettings
 ***************************************************************************/
t_Void spi_tclMySPINConnMngr::vOnSaveSettings()
{

}

/***************************************************************************
 ** FUNCTION: t_Bool spi_tclMySPINConnMngr::bSetDevProjUsage
 ***************************************************************************/
t_Bool spi_tclMySPINConnMngr::bSetDevProjUsage(tenEnabledInfo enServiceStatus)
{
   SPI_INTENTIONALLY_UNUSED(enServiceStatus)
   ETG_TRACE_USR1((" spi_tclMySPINConnMngr::bSetDevProjUsage"));

   //@todo - it' un used for now
   return true;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINConnMngr::vOnSelectDevice()
 ***************************************************************************/
t_Void spi_tclMySPINConnMngr::vOnSelectDevice(const t_U32 cou32DevID, tenDeviceConnectionType enDevConnType,
         tenDeviceConnectionReq enDevSelectType, tenEnabledInfo enDAPUsage, tenEnabledInfo enCDBUsage,
         tenSelectReason enSelectionReason, const trUserContext corfUsrCntxt, tenDeviceType enDeviceType)
{
   SPI_INTENTIONALLY_UNUSED(enDAPUsage);
   SPI_INTENTIONALLY_UNUSED(enCDBUsage);

   ETG_TRACE_USR2(("[DESC]::Received Device selection request for 0x%x. Select Type-%d, SelectReason -%d", cou32DevID, ETG_ENUM(CONNECTION_REQ,
            enDevSelectType), ETG_ENUM(SELECT_REASON, enSelectionReason)));

   t_Bool bSendInvalidSelectDevResult = true;
   tenDeviceSubCategory enDevSubCat = static_cast<tenDeviceSubCategory> (enDeviceType);
   if (e8_UNKNOWN_DEVICE == enDeviceType)enDevSubCat = e8DEVTYPE_AOAP;
   ETG_TRACE_USR2(("Device Type:[%d]",enDeviceType));
   ETG_TRACE_USR2(("Device Subcategory:[%d]",enDevSubCat));
   t_U8 u8Index = static_cast<t_U8> (enDevSubCat);

   ETG_TRACE_USR2(("Index :[%d]",u8Index));
   trMySPINDevInfo rMySPINDevInfo;
   rMySPINDevInfo.u32ProductID = m_rDeviceSwitchInfo.u32ProductID;
   rMySPINDevInfo.u32VendorID = m_rDeviceSwitchInfo.u32VendorID;
   rMySPINDevInfo.szSerial = m_rDeviceSwitchInfo.szSerialNumber;

   if (true == bValidateConnHndlr(u8Index))
   {
      m_apoMySPINConnHndlrs[enDevSubCat]->vOnSelectDevice(cou32DevID,
               enDevConnType,
               enDevSelectType,
               corfUsrCntxt,
               rMySPINDevInfo);

      bSendInvalidSelectDevResult = false;
   }
   else
   {
      ETG_TRACE_ERR(("[ERR]:Select Device received for invalid device"));
   }

   if ((true == bSendInvalidSelectDevResult) && (NULL != m_rConnCbs.fvSelectDeviceResult))
   {
      (m_rConnCbs.fvSelectDeviceResult)(e8INVALID_DEV_HANDLE);
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINConnMngr::vOnSelectDeviceResult()
 ***************************************************************************/
t_Void spi_tclMySPINConnMngr::vOnSelectDeviceResult(const t_U32 cou32DevID,
         const tenDeviceConnectionReq enDevSelectType, const tenResponseCode coenRespCode, tenDeviceCategory enDevCat,
         tenSelectReason enSelectionReason, tenDeviceType enDeviceType)
{
   ETG_TRACE_USR2(("[DESC]::Select Device Result recieved for 0x%x. Select Type-%d, Response Code -%d", cou32DevID, ETG_ENUM(CONNECTION_REQ,
            enDevSelectType), ETG_ENUM(RESPONSE_CODE, coenRespCode)));

   SPI_INTENTIONALLY_UNUSED(enDevCat);
   SPI_INTENTIONALLY_UNUSED(enSelectionReason);

   tenDeviceSubCategory enDevSubCat = static_cast<tenDeviceSubCategory> (enDeviceType);
   t_U8 u8Index = static_cast<t_U8> (enDevSubCat);
   
   if((e8DEVCONNREQ_SELECT == enDevSelectType) && (e8SUCCESS == coenRespCode) && (NULL != m_rConnCbs.fvSessionTransport))
   {
       m_rConnCbs.fvSessionTransport(cou32DevID, enDevCat, e8_SESSION_TRANSPORT_USB);
       vSetVehicleManufactureInfo(cou32DevID);
   }
   else if(((e8DEVCONNREQ_SELECT == enDevSelectType) && (e8FAILURE == coenRespCode)) || 
          (e8DEVCONNREQ_DESELECT == enDevSelectType))
   {
       m_enMySPINError = e8MSPIN_ERROR_UNKNOWN;
   }

   if (true == bValidateConnHndlr(u8Index))
   {
      m_apoMySPINConnHndlrs[enDevSubCat]->vOnSelectDeviceResult(cou32DevID, enDevSelectType, coenRespCode);
   }

}

/***************************************************************************
 ** FUNCTION:  t_Bool  spi_tclMySPINConnMngr::bValidateClient()
 ***************************************************************************/
t_Bool spi_tclMySPINConnMngr::bValidateConnHndlr(t_U8 u8Index)
{
   //Assert if the Index is greater than the array size
   SPI_NORMAL_ASSERT( u8Index == MYSPIN_CONN_HNDLRS);

   return ((u8Index < MYSPIN_CONN_HNDLRS) && (NULL != m_apoMySPINConnHndlrs[u8Index]));
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINConnMngr::vSetDeviceSwitchInfo
 ***************************************************************************/
t_Void spi_tclMySPINConnMngr::vSetDeviceSwitchInfo(trDeviceSwitchInfo &rfrDeviceSwitchInfo)
{
   ETG_TRACE_USR1(("MySPIN Device Switch Info set to VendorID = 0x%x ProductID = 0x%x, SerialNumber = %s", rfrDeviceSwitchInfo.u32VendorID, rfrDeviceSwitchInfo.u32ProductID, rfrDeviceSwitchInfo.szSerialNumber.c_str()));

   m_rDeviceSwitchInfo = rfrDeviceSwitchInfo;

   //Set the switch progress info for IAP devices
   if (true == bValidateConnHndlr(e8DEVTYPE_IAP))
   {
      m_apoMySPINConnHndlrs[e8DEVTYPE_IAP]->vSetDeviceSelectionState(m_rDeviceSwitchInfo.bSwitchInProgress);
   }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINConnMngr::vSelectDeviceResultCb()
 ***************************************************************************/
t_Void spi_tclMySPINConnMngr::vSelectDeviceResultCb(t_U32 u32DevID, tenDeviceSubCategory enDevSubCat,
         tenErrorCode enErrorCode)
{
   ETG_TRACE_USR2(("[DESC]::Connection Select Device Response for the MySPIN Device:0x%x DevSubCat-%d ErrorCode-%d", u32DevID, ETG_ENUM(MSPIN_DEV_TYPE,
            enDevSubCat), ETG_ENUM(ERROR_CODE, enErrorCode)));

   if (NULL != m_rConnCbs.fvSelectDeviceResult)
   {
      (m_rConnCbs.fvSelectDeviceResult)(enErrorCode);
   }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINConnMngr::vSetSelectErrorCb()
 ***************************************************************************/
t_Void spi_tclMySPINConnMngr::vSetSelectErrorCb(t_U32 u32DevID, tenErrorCode enErrorCode)
{
   ETG_TRACE_USR2(("[DESC]::Error in Device 0x%x selection. ErrorCode-%d", u32DevID, ETG_ENUM(ERROR_CODE, enErrorCode)));
   // Unused for now.
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINConnMngr::vSetRoleSwitchRequestedInfo()
 ***************************************************************************/
t_Void spi_tclMySPINConnMngr::vSetRoleSwitchRequestedInfo(const t_U32 cou32DeviceHandle)
{
   SPI_INTENTIONALLY_UNUSED(cou32DeviceHandle)
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINConnMngr::vMySPINSessionErrorCb()
 ***************************************************************************/
t_Void spi_tclMySPINConnMngr::vMySPINSessionErrorCb(const t_U32 cou32DeviceHandle, tenMySPINError enErrorCode)
{
   //Get Device Subcategory
   tenDeviceSubCategory enDeviceSubCategory;
   spi_tclMySPINManager::vGetDeviceSubCategory(enDeviceSubCategory);

   ETG_TRACE_USR2(("[DESC]::Received Error - [%d] , Device SubCategory [%d]", ETG_ENUM(MSPIN_ERROR_CODE, enErrorCode), ETG_ENUM(MSPIN_DEV_SUBCAT,
            enDeviceSubCategory)));

   if (true == bValidateConnHndlr(e8DEVTYPE_IAP))
   {
      m_apoMySPINConnHndlrs[e8DEVTYPE_IAP]->vMySPINSessionErrorCb(enErrorCode);
   }

   if ((e8MSPIN_ERROR_PROTOCOL_STOP == enErrorCode) || (e8MSPIN_ERROR_INITIALIZATION_ABORT == enErrorCode))
   {
      if(e8DEVTYPE_AOAP == enDeviceSubCategory)
      {
         ETG_TRACE_USR1(("[DESC]:: Trigger Deselection"));
         //When the phone sends any error send trigger to deselect the device,in case retry is not required
         spi_tclMediator *poMediator = spi_tclMediator::getInstance();
         poMediator->vPostAutoDeviceSelection(cou32DeviceHandle, e8DEVCONNREQ_DESELECT);
      }
      else if(e8DEVTYPE_IAP == enDeviceSubCategory)
      {
         m_enMySPINError = enErrorCode;
      }
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINConnMngr::vOnSetSelectionProgressState(
 ***************************************************************************/
t_Void spi_tclMySPINConnMngr::vOnSetSelectionProgressState(tenDeviceSelectionState enDeviceSelectionState)
{
   ETG_TRACE_USR2(("spi_tclMySPINConnMngr::vOnSetSelectionProgressState entered with result = %d", ETG_ENUM(tenDeviceSelectionState, enDeviceSelectionState)));
   
   if (true == bValidateConnHndlr(e8DEVTYPE_IAP))
   {
      m_apoMySPINConnHndlrs[e8DEVTYPE_IAP]->vOnSetSelectionProgressState(enDeviceSelectionState);
   }
}

/***************************************************************************
** FUNCTION:  spi_tclMySPINConnection::vSetVehicleManufactureInfo
***************************************************************************/
t_Void spi_tclMySPINConnMngr::vSetVehicleManufactureInfo(const t_U32 cou32DeviceHandle)
{
   spi_tclMySPINManager* poMySPINMngr = spi_tclMySPINManager::getInstance();
   if(NULL != poMySPINMngr)
   {
       spi_tclMySPINCmdVehicleData * poCmdVehData = poMySPINMngr->poGetVehDataInstance();
       if (NULL != poCmdVehData )
       {
           if (NULL != m_poConnSettings)
           {
               trVehicleInfo rfrVehicleInfo;
               m_poConnSettings->vGetVehicleInfoDataMySPIN(rfrVehicleInfo);
               m_u16VehicleType = m_poConnSettings->u16ReadVehicleTypeFromKDS();
               m_szVehicleManufacturerName = rfrVehicleInfo.szManufacturer;
               m_szVehicleManufacturerScope = rfrVehicleInfo.szVehicleVariant;
               
           }
           if(0 != cou32DeviceHandle)
           {
               poCmdVehData->vSetVehicleManufactureInfo(cou32DeviceHandle, m_u16VehicleType, m_szVehicleManufacturerName, m_szVehicleManufacturerScope);
           }
       }
   }
}
