/***********************************************************************/
/*!
 * \file  spi_tclMySPINAppMngr.cpp
 * \brief MySpin Application Manager
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    MySpin Application Manager
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH

 HISTORY:
 Date        | Author                | Modification
 02.11.2015  | tch5kor               | Initial Version
 12.04.2016  | Chaitra Srinivasa     | Trace message cleanup
 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "spi_tclMySPINAppMngr.h"
#include "spi_tclMySPINManager.h"
#include "spi_tclExtCompManager.h"
#include "spi_tclExtCmdNativeTransport.h"

#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_APPMNGR
#include "trcGenProj/Header/spi_tclMySPINAppMngr.cpp.trc.h"
#endif
#endif

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/
static t_U32 su32CurSelectedDevId = 0;
/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINAppMngr::spi_tclMySPINAppMngr()
 ***************************************************************************/
spi_tclMySPINAppMngr::spi_tclMySPINAppMngr()
{
   ETG_TRACE_USR1(("spi_tclMySPINAppMngr() entered "));
}
/***************************************************************************
 ** FUNCTION:  spi_tclMySPINAppMngr::~spi_tclMySPINAppMngr()
 ***************************************************************************/
spi_tclMySPINAppMngr::~spi_tclMySPINAppMngr()
{
   ETG_TRACE_USR1(("~spi_tclMySPINAppMngr() entered "));
   su32CurSelectedDevId = 0; // to ensure the static variable is cleared during quick ignition cycles etc.
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclMySPINAppMngr::bInitialize()
 ***************************************************************************/
t_Bool spi_tclMySPINAppMngr::bInitialize()
{
   ETG_TRACE_USR1(("spi_tclMySPINAppMngr::bInitialize() entered "));
   //! Add initialization if needed
   t_Bool bRet = true;

   return bRet;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINAppMngr::vUninitialize()
 ***************************************************************************/
t_Void spi_tclMySPINAppMngr::vUnInitialize()
{
   ETG_TRACE_USR1(("spi_tclMySPINAppMngr::vUnInitialize() entered "));
}

/***************************************************************************
 ** FUNCTION:  t_Void  spi_tclMySPINAppMngr::vRegisterAppMngrCallbacks()
 ***************************************************************************/
t_Void spi_tclMySPINAppMngr::vRegisterAppMngrCallbacks(const trAppMngrCallbacks& corfrAppMngrCbs)
{
   ETG_TRACE_USR1(("spi_tclMySPINAppMngr::vRegisterAppMngrCallbacks\n"));
   //Copy call back structure
   m_rAppMngrCallbacks = corfrAppMngrCbs;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINAppMngr::vSelectDevice()
 ***************************************************************************/
t_Void spi_tclMySPINAppMngr::vSelectDevice(const trSelectDeviceRequest& corfrSelectReq)
{

   /*lint -esym(40,fpvSelectDeviceResult)fpvSelectDeviceResult Undeclared identifier */
   ETG_TRACE_USR2(("[DESC]::vSelectDevice: Dev-0x%x, ConnReq - %d", corfrSelectReq.m_u32DeviceHandle, ETG_ENUM(CONNECTION_REQ, corfrSelectReq.m_enDevConnReq)));

   //Always return true, there is nothing major to send device selection failure
   if (NULL != m_rAppMngrCallbacks.fpvSelectDeviceResult)
   {
      (m_rAppMngrCallbacks.fpvSelectDeviceResult)(true);
   }
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclMySPINAppMngr::bLaunchApp()
 ***************************************************************************/
t_Void spi_tclMySPINAppMngr::vLaunchApp(const t_U32 cou32DevId,
         t_U32 u32AppHandle,
         const trUserContext& rfrcUsrCntxt,
         tenDiPOAppType enDiPOAppType,
         t_String szTelephoneNumber,
         tenEcnrSetting enEcnrSetting)
{
   ETG_TRACE_USR2(("[DESC]::vLaunchApp:Dev-0x%x App-0x%x,Apptype: %d",
            cou32DevId, u32AppHandle,ETG_ENUM(DIPO_APP_TYPE,enDiPOAppType)));

   SPI_INTENTIONALLY_UNUSED(enEcnrSetting);
   SPI_INTENTIONALLY_UNUSED(szTelephoneNumber);

   tenErrorCode enErrorCode = e8NO_ERRORS;

   tenSessionStatus enSessionStatus = e8_SESSION_UNKNOWN;
   spi_tclMySPINManager::vGetSessionStatus(enSessionStatus);
   ETG_TRACE_USR4(("[PARAM]::vLaunchApp-Session Status [%d] ", enSessionStatus));

   spi_tclMySPINManager* poMySPINMngr = spi_tclMySPINManager::getInstance();

   if ((e8_SESSION_ACTIVE != enSessionStatus) && (NULL != poMySPINMngr))
   {

      tenDeviceSubCategory enDeviceSubCategory = e8DEVTYPE_UNKNWON;
      spi_tclMySPINManager::vGetDeviceSubCategory(enDeviceSubCategory);
      ETG_TRACE_USR4(("[PARAM]::vLaunchApp-Device Subcategory [%d] ", ETG_ENUM(MSPIN_DEV_SUBCAT, enDeviceSubCategory)));

      switch (enDeviceSubCategory)
      {
         case e8DEVTYPE_AOAP:
         {
            spi_tclMySPINCmdInput* poMySPINCmdInput = poMySPINMngr->poGetInputInstance();
            if (NULL != poMySPINCmdInput)
            {
               //! Invoking Home key would trigger the Launcher app to come to foreground.
               poMySPINCmdInput->vSendKeyEvent(cou32DevId, e8KEY_PRESS, e32DEV_HOME);
               poMySPINCmdInput->vSendKeyEvent(cou32DevId, e8KEY_RELEASE, e32DEV_HOME);
               enErrorCode = e8NO_ERRORS;
            }
         }
            break;
         case e8DEVTYPE_IAP:
         {
            spi_tclExtCompManager *poExtCompMgr = spi_tclExtCompManager::getInstance();
            spi_tclExtCmdNativeTransportIntf *poExtCmdNativeTransportIntf = NULL;
            if(NULL != poExtCompMgr)
            {
                poExtCmdNativeTransportIntf = poExtCompMgr->poGetCmdNativeTransportIntfInst();
            }
            if((NULL != poExtCmdNativeTransportIntf) && (NULL != m_poAppSettings))
            {
                trEAPAppInfo rEAPAppInfo;
                trMySPINIapAppInfo rMySPINIapAppInfo;
                m_poAppSettings->vGetMySPINIapAppInfo(rMySPINIapAppInfo);
                rEAPAppInfo.bLaunchType = rMySPINIapAppInfo.enIapLaunchType;
                rEAPAppInfo.szAppName = rMySPINIapAppInfo.szAppName;
                rEAPAppInfo.szBundleID = rMySPINIapAppInfo.szBundleSeedId;
                rEAPAppInfo.szProtocol = rMySPINIapAppInfo.szProtocol;
                t_Bool bLaunchApp = poExtCmdNativeTransportIntf->bLaunchApp(cou32DevId,e8DEV_TYPE_MYSPIN,rEAPAppInfo);
                enErrorCode = (bLaunchApp) ? e8NO_ERRORS : e8INTERNAL_ERROR;
            }
         }
            break;
         default:
         {
            ETG_TRACE_ERR(("[ERROR]Unknown Device sub-category"));
            break;
         }
      }

   }

   if (m_rAppMngrCallbacks.fpvLaunchAppResult)
   {
      (m_rAppMngrCallbacks.fpvLaunchAppResult)(cou32DevId, u32AppHandle, e8DIPO_NOT_USED, enErrorCode, rfrcUsrCntxt);
   }

}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINAppMngr::vTerminateApp()
 ***************************************************************************/
t_Void spi_tclMySPINAppMngr::vTerminateApp(const t_U32 cou32devId, const t_U32 cou32AppId,
         const trUserContext& rfrcUsrCntxt)
{
   SPI_INTENTIONALLY_UNUSED(rfrcUsrCntxt)
   ETG_TRACE_USR2(("[DESC]::vTerminateApp:Dev-0x%x App-0x%x \n", cou32devId, cou32AppId));
   //! Add code
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINAppMngr::vGetAppDetailsList()
 ***************************************************************************/
t_Void spi_tclMySPINAppMngr::vGetAppDetailsList(const t_U32 cou32DevId, t_U32& u32NumAppInfoList, std::vector<
         trAppDetails>& corfvecrAppDetailsList)
{
   SPI_INTENTIONALLY_UNUSED(cou32DevId)
   SPI_INTENTIONALLY_UNUSED(u32NumAppInfoList)
   trAppDetails rAppDetails;
   rAppDetails.u32AppHandle = 1;
   rAppDetails.szAppName = "Launcher";

   corfvecrAppDetailsList.push_back(rAppDetails);

}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINAppMngr::vGetAppIconData()
 ***************************************************************************/
t_Void spi_tclMySPINAppMngr::vGetAppIconData(t_String szAppIconUrl, const trUserContext& rfrcUsrCntxt)
{
	SPI_INTENTIONALLY_UNUSED(szAppIconUrl)
   //Post response to HMI
   if (NULL != m_rAppMngrCallbacks.fpvCbAppIconDataResult)
   {
      (m_rAppMngrCallbacks.fpvCbAppIconDataResult)(e8ICON_INVALID, NULL, 0, rfrcUsrCntxt);
   }
}

t_Bool spi_tclMySPINAppMngr::bCheckAppValidity(const t_U32 cou32DevId, const t_U32 cou32AppId)
{
	SPI_INTENTIONALLY_UNUSED(cou32DevId)
	SPI_INTENTIONALLY_UNUSED(cou32AppId)
   return true;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINAppMngr::vSetVehicleConfig()
 ***************************************************************************/
t_Void spi_tclMySPINAppMngr::vOnSelectDeviceResult(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq,
         const tenResponseCode coenRespCode)
{
   ETG_TRACE_USR1((" spi_tclMySPINAppMngr::vOnSelectDeviceResult "));

   su32CurSelectedDevId = ((e8DEVCONNREQ_SELECT == coenConnReq) && (e8SUCCESS == coenRespCode)) ? cou32DevId : 0;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINAppMngr::vSetVehicleConfig()
 ***************************************************************************/
t_Void spi_tclMySPINAppMngr::vSetVehicleConfig(tenVehicleConfiguration enVehicleConfig, t_Bool bSetConfig)
{
   SPI_INTENTIONALLY_UNUSED(bSetConfig);

   spi_tclMySPINManager* poMySPINMngr = spi_tclMySPINManager::getInstance();
   if (NULL != poMySPINMngr)
   {
      spi_tclMySPINCmdVehicleData * poCmdVehData = poMySPINMngr->poGetVehDataInstance();
      if ((NULL != poCmdVehData) && ((e8_DAY_MODE == enVehicleConfig) || (e8_NIGHT_MODE == enVehicleConfig)))
      {
         poCmdVehData->vSetNightMode(su32CurSelectedDevId, enVehicleConfig);
      }
   }
}
/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINAppMngr::bGetAudioHandlingCaps()
 ***************************************************************************/
t_Bool spi_tclMySPINAppMngr::bGetAudioHandlingCaps()
{

   t_Bool bIsAdvAudioCapable = false;
   tenAppCapability enAppCapability = e8_CAPABILITY_NONE;
   spi_tclMySPINManager* poMySPINMngr = spi_tclMySPINManager::getInstance();
   if (NULL != poMySPINMngr)
   {
      spi_tclMySPINCmdSession* poCmdSession = poMySPINMngr->poGetSessionInstance();

      if (NULL != poCmdSession)
      {
         poCmdSession->vGetAppCapability(enAppCapability);
      }
   }
   bIsAdvAudioCapable = (e8_CAPABILITY_AUDIO_HANDLING == enAppCapability);
   return bIsAdvAudioCapable;

}
//lint restore
///////////////////////////////////////////////////////////////////////////////
// <EOF>

