/***********************************************************************/
/*!
 * \file  spi_tclMySPINAppMngr.h
 * \brief MySpin Application Manager
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    MySpin Application Manager
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 02.11.2015  | tch5kor               | Initial Version
 05.04.2016  | Chaitra Srinivasa     | Adding comments
 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLMYSPINAPPMNGR_H_
#define _SPI_TCLMYSPINAPPMNGR_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_tclAppMngrDefines.h"
#include "spi_tclAppMngrDev.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class spi_tclAppManager
 * \brief MySpin Application Manager
 ****************************************************************************/
class spi_tclMySPINAppMngr: public spi_tclAppMngrDev
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAppMngr::spi_tclMySPINAppMngr(spi_tclRespInterface* poSpiRespIntf)
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINAppMngr(spi_tclRespInterface* poSpiRespIntf)
       * \brief   Parameterized Constructor
       * \param   poSpiRespIntf : [IN] Response Interface pointer object
       * \sa      ~spi_tclMySPINAppMngr()
       **************************************************************************/
      spi_tclMySPINAppMngr();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAppMngr::~spi_tclMySPINAppMngr()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclMySPINAppMngr()
       * \brief   Destructor
       * \sa      spi_tclMySPINAppMngr()
       **************************************************************************/
      ~spi_tclMySPINAppMngr();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINAppMngr::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitialize()
       * \brief   To Initialize all the MySpin App Mngr related things
       * \retval  t_Bool
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINAppMngr::vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Void vUninitialize()
       * \brief   To Uninitialize all the MySpin App Mngr related things
       * \retval  t_Void
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUnInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclMySPINAppMngr::vRegisterAppMngrCallbacks()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRegisterAppMngrCallbacks(const trAppMngrCallbacks& corfrAppMngrCbs)
       * \brief   To Register for the asynchronous responses that are required from App Mngr
       * \param   corfrAppMngrCbs : [IN] Application Manager callabcks structure
       * \retval  t_Void
       **************************************************************************/
      t_Void vRegisterAppMngrCallbacks(const trAppMngrCallbacks& corfrAppMngrCbs);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINAppMngr::vSelectDevice()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vSelectDevice(const t_U32 cou32DevId,
       *          const tenDeviceConnectionReq coenConnReq)
       * \brief   To update the changes in the app list of the selected device
	   * \param  corfrSelectReq : Device selection request details
       * \retval  t_Void
       **************************************************************************/
      t_Void vSelectDevice(const trSelectDeviceRequest& corfrSelectReq);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINAppMngr::vLaunchApp()
       ***************************************************************************/
      /*!
       * \fn      t_Void vLaunchApp
       * \brief   To Launch the requested app
       * \param    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \param   u32AppHandle : [IN]  Uniquely identifies an Application on
       *              the target Device. This value will be obtained from AppList Interface.
       *          rfrcUsrCntxt : [IN] user Context
       * \retval  t_Void
       * \sa      vTerminateApp()
       **************************************************************************/
      t_Void vLaunchApp(const t_U32 cou32DevId,
             t_U32 u32AppHandle,
             const trUserContext& rfrcUsrCntxt,
             tenDiPOAppType enDiPOAppType,
             t_String szTelephoneNumber,
             tenEcnrSetting enEcnrSetting);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINAppMngr::vTerminateApp()
       ***************************************************************************/
      /*!
       * \fn      t_Void vTerminateApp
       * \brief   To Terminate an Application asynchronously.
       * \param   rUserContext : [IN] Context Message
       * \param   u32DeviceId  : [IN] Device Id
       * \param   u32AppId     : [IN] Application Id
       * \retval  t_Void
       * \sa      t_Bool bLaunchApp(t_U32 u32DeviceId, t_U32 u32AppId)
       **************************************************************************/
      t_Void vTerminateApp(const t_U32 cou32DevId, const t_U32 cou32AppId, const trUserContext& rfrcUsrCntxt);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINAppMngr::vGetAppDetailsList()
       ***************************************************************************/
      /*!
       * \fn     virtual t_Void vGetDeviceInfoList(const t_U32 cou32DevId,
       *         t_U32& u32NumAppInfoList,
       *         std::vector<trAppDetails>& corfvecrAppDetailsList)
       * \brief  It provides a list of applications supported by a device.
       * \param  cou32DevId  : [IN] Device Handle
       * \param  u32NumAppInfoList : [OUT] Number of Applications in the List
       * \param  corfvecrAppDetailsList : [OUT] List of applicationinfo's of the
       *                                 Applications supported by the device
       * \retval  t_Void
       **************************************************************************/
      t_Void vGetAppDetailsList(const t_U32 cou32DevId, t_U32& u32NumAppInfoList,
               std::vector<trAppDetails>& corfvecrAppDetailsList);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINAppMngr::vGetAppIconData()
       ***************************************************************************/
      /*!
       * \fn     virtual t_Void vGetAppIconData(t_String szAppIconUrl,
       *                                 const trUserContext& rfrcUsrCntxt)
       * \brief  Used to get the application icon data.
       * \param  szAppIconUrl  : [IN] String to store app icon url
       * \param  rfrcUsrCntxt : [IN] Used to store user context info
       * \retval  t_Void
       **************************************************************************/
      t_Void vGetAppIconData(t_String szAppIconUrl, const trUserContext& rfrcUsrCntxt);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINAppMngr::bCheckAppValidity()
       ***************************************************************************/
      /*!
       * \fn     virtual t_Void bCheckAppValidity(const t_U32 cou32DevId,
       *                                 const t_U32 cou32AppId)
       * \brief  Used to check the validity of an application.
       * \param  cou32DevId  : [IN] String to store app icon url
       * \param  cou32AppId : [IN] Used to store user context info
       * \retval  t_Void
       **************************************************************************/
      t_Bool bCheckAppValidity(const t_U32 cou32DevId, const t_U32 cou32AppId);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINAppMngr::vOnSelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenResponseCode coenRespCode)
       * \brief   To perform the actions that are required, after the select device is
       *           successful
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq,
               const tenResponseCode coenRespCode);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINAppMngr::vSetVehicleConfig()
       ***************************************************************************/
      /*!
       * \fn     t_Void vSetVehicleConfig(tenVehicleConfiguration enVehicleConfig,
       *          t_Bool bSetConfig,const trUserContext& corfrUsrCntxt)
       * \brief  Interface to set the Vehicle configurations.
       * \param  [IN] enVehicleConfig :  Identifies the Vehicle Configuration.
       * \param  [IN] bSetConfig      : Enable/Disable config
       * \param  [IN] corfrUsrCntxt   : User Context Details.
       * \retval t_Void
       **************************************************************************/
      t_Void vSetVehicleConfig(tenVehicleConfiguration enVehicleConfig, t_Bool bSetConfig);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINAppMngr::bGetAudioHandlingCaps()
       ***************************************************************************/
      /*!
       * \fn     t_Bool bGetAudioHandlingCaps()
       * \brief  Interface to get advanced audio capability
       * \param  [NONE]
       * \retval t_Bool
       **************************************************************************/
      t_Bool bGetAudioHandlingCaps();

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/
      //! call back structure tos end response to Main App lmgr
      trAppMngrCallbacks m_rAppMngrCallbacks;

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

}; //spi_tclMySPINAppMngr

#endif //_SPI_TCLMYSPINAPPMNGR_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>
