/***********************************************************************/
/*!
 * \file  spi_tclOnCarVideo.h
 * \brief  Implementation of the Class spi_tclOnCarVideo
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    class for OnCar Video
 AUTHOR:         Unmukt Jain (RBEI/ECO : jun5kor)
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                            | Modification
 01.02.2018  | Unmukt Jain                       | Initial Version

 \endverbatim
 *************************************************************************/

#ifndef SPI_TCLONCARVIDEO_H_
#define SPI_TCLONCARVIDEO_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "SPITypes.h"
#include "spi_tclVideoTypedefs.h"
#include "spi_tclVideoDevBase.h"
#include "spi_tclOnCarRespVideo.h"
#include "spi_tclOnCarCmdVideo.h"

//#include "spi_tclMySPINRespVideo.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class    spi_tclOnCarVideo
 * \brief    OnCar Video implementation
 *           This class interacts with OnCar Video wrapper to interact with
 *           OnCar API's
 ****************************************************************************/
class spi_tclOnCarVideo: public spi_tclVideoDevBase
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarVideo::spi_tclOnCarVideo()
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarVideo()
       * \brief   Default Constructor
       * \sa      ~spi_tclOnCarVideo()
       **************************************************************************/
       spi_tclOnCarVideo();

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarVideo::~spi_tclOnCarVideo()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclOnCarVideo()
       * \brief   Destructor
       * \sa      spi_tclOnCarVideo()
       **************************************************************************/
      ~spi_tclOnCarVideo();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclOnCarVideo::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitialize()
       * \brief   To Initialize all the Video related classes
       * \retval  t_Bool
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarVideo::vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Void vUninitialize()
       * \brief   To Uninitialize all the Video related classes
       * \retval  t_Void
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUninitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclOnCarVideo::vRegisterCallbacks()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRegisterCallbacks(const trVideoCallbacks& corfrVideoCallbacks)
       * \brief   To Register for the asynchronous responses that are required from
       *          OnCar Video
       * \param   corfrVideoCallbacks : [IN] Video callbacks structure
       * \retval  t_Void
       **************************************************************************/
      t_Void vRegisterCallbacks(const trVideoCallbacks& corfrVideoCallbacks);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarVideo::vSelectDevice()
       ***************************************************************************/
      /*!
       * \fn      t_Void vSelectDevice(const t_U32 cou32DevId,
       *          const tenDeviceConnectionReq coenConnReq)
       * \brief   To Initialize/UnInitialize Video setup for the currently selected device
       * \pram    cou32DevId : [IN] Unique Device Id
       * \param   coenConnReq : [IN] connected/disconnected
       * \retval  t_Void
       **************************************************************************/
      t_Void vSelectDevice(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq);

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclOnCarVideo::bLaunchVideo()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bLaunchVideo(const t_U32 cou32DevId,
       *                 const t_U32 cou32AppId,
       *                 const tenEnabledInfo coenSelection)
       * \brief   To Launch the Video for the requested app
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    cou32AppId  : [IN] Application Id
       * \pram    coenSelection  : [IN] Enable/disable the video
       * \retval  t_Bool
       **************************************************************************/
      t_Bool bLaunchVideo(const t_U32 cou32DevId, const t_U32 cou32AppId,
               const tenEnabledInfo coenSelection);

      /***************************************************************************
       ** FUNCTION:  t_U32  spi_tclOnCarVideo::vStartVideoRendering()
       ***************************************************************************/
      /*!
       * \fn      t_Void vStartVideoRendering(t_Bool bStartVideoRendering)
       * \brief   Method send request to OnCar Video either to start or stop
       *          Video Rendering
       * \pram    bStartVideoRendering : [IN] True - Start Video rendering
       *                                      False - Stop Video rendering
       * \retval  t_Void
       **************************************************************************/
      t_Void vStartVideoRendering(t_Bool bStartVideoRendering);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclOnCarVideo::vGetVideoSettings()
       ***************************************************************************/
      /*!
       * \fn     t_Void vGetVideoSettings(const t_U32 cou32DevId,
       *                                  trVideoAttributes& rfrVideoAttributes
       * \brief  To get the current Video Settings.
       * \param  cou32DevId         : [IN] Uniquely identifies the target Device.
       * \param  rfrVideoAttributes : [OUT]includes screen size & orientation.
       * \retval t_Void
       * \sa
       **************************************************************************/
      t_Void vGetVideoSettings(const t_U32 cou32DevId, trVideoAttributes& rfrVideoAttributes);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclOnCarVideo::vSetOrientationMode()
       ***************************************************************************/
      /*!
       * \fn     t_Void vSetOrientationMode(const t_U32 cou32DevId,
       *                                    const tenOrientationMode coenOrientationMode,
       *                                    const trUserContext& corfrUsrCntxt)= 0
       * \brief  Interface to set the orientation mode of the projected display.
       * \param  cou32DevId          : [IN] Uniquely identifies the target Device.
       * \param  coenOrientationMode : [IN] Orientation Mode Value.
       * \param  corfrUsrCntxt       : [IN] User Context
       * \retval t_Void
       **************************************************************************/
      t_Void vSetOrientationMode(const t_U32 cou32DevId, const tenOrientationMode coenOrientationMode,
               const trUserContext& corfrUsrCntxt);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarVideo::vOnSelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenResponseCode coenRespCode)
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq,
               const tenResponseCode coenRespCode);

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/
      /***************************************************************************
      ** FUNCTION:  t_Bool spi_tclOnCarVideo::bInitVideoSession()
      ***************************************************************************/
      /*!
      * \fn      t_Bool bInitVideoSession(t_U32 u32DevID))
      * \brief   Method to initialize the Video resources that are required for session
      * \pram    u32DevID  : [IN] Uniquely identifies the target Device.
      * \retval  t_Bool
      **************************************************************************/
      t_Bool bInitVideoSession(t_U32 u32DevID);

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclOnCarVideo::vUnInitVideoSession()
      ***************************************************************************/
      /*!
      * \fn      t_Void vUnInitVideoSession(t_U32 u32DevID)
      * \brief   Method to uninitialize the Video resources that were allocated for session
      * \pram    u32DevID  : [IN] Uniquely identifies the target Device.
      * \retval  t_Void
      **************************************************************************/
      t_Void vUnInitVideoSession(t_U32 u32DevID);

      spi_tclOnCarCmdVideo* m_poCmdVideo;

      //! Currently selected device
      t_U32 m_u32SelectedDeviceID;

      trVideoCallbacks m_rVideoCallbacks;

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

}; //spi_tclOnCarVideo

#endif // SPI_TCLONCARVIDEO_H_
///////////////////////////////////////////////////////////////////////////////
// <EOF>
