
/***********************************************************************/
/*!
* \file    spi_tclOnCarVideoDispatcher.cpp
* \brief   Message Dispatcher for Video Messages
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Video Messages
AUTHOR:         Unmukt Jain
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
20.02.2018  | Unmukt Jain           | Initial Version
\endverbatim
*************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespRegister.h"
#include "spi_tclOnCarRespVideo.h"
#include "spi_tclOnCarVideoDispatcher.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
      #include "trcGenProj/Header/spi_tclOnCarVideoDispatcher.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleVideoMsg(this);                  \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
** FUNCTION:  OnCarVideoMsgBase::OnCarVideoMsgBase
***************************************************************************/
OnCarVideoMsgBase::OnCarVideoMsgBase()
{
   ETG_TRACE_USR1(("OnCarVideoMsgBase() entered "));
   vSetServiceID(e32MODULEID_ONCARVIDEO);
}

//! Class OnCarStartVideoPlaybackMsg
/***************************************************************************
 ** FUNCTION:  OnCarStartVideoPlaybackMsg::OnCarStartVideoPlaybackMsg
 ***************************************************************************/
OnCarStartVideoPlaybackMsg::OnCarStartVideoPlaybackMsg()
{
   ETG_TRACE_USR1(("OnCarStartVideoPlaybackMsg::OnCarStartVideoPlaybackMsg Entered\n"));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  OnCarStartVideoPlaybackMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCarStartVideoPlaybackMsg,spi_tclOnCarVideoDispatcher);

/***************************************************************************
 ** FUNCTION:  OnCarStartVideoPlaybackMsg::vAllocateMsg
 ***************************************************************************/
t_Void OnCarStartVideoPlaybackMsg::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  OnCarStartVideoPlaybackMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void OnCarStartVideoPlaybackMsg::vDeAllocateMsg()
{

}

//! Class OnCarStopVideoPlaybackMsg
/***************************************************************************
 ** FUNCTION:  OnCarStopVideoPlaybackMsg::OnCarStopVideoPlaybackMsg
 ***************************************************************************/
OnCarStopVideoPlaybackMsg::OnCarStopVideoPlaybackMsg()
{
   ETG_TRACE_USR1(("OnCarStopVideoPlaybackMsg::OnCarStopVideoPlaybackMsg Entered\n"));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  OnCarStopVideoPlaybackMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCarStopVideoPlaybackMsg,spi_tclOnCarVideoDispatcher);

/***************************************************************************
 ** FUNCTION:  OnCarStopVideoPlaybackMsg::vAllocateMsg
 ***************************************************************************/
t_Void OnCarStopVideoPlaybackMsg::vAllocateMsg()
{

}
/***************************************************************************
 ** FUNCTION:  OnCarStopVideoPlaybackMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void OnCarStopVideoPlaybackMsg::vDeAllocateMsg()
{

}

//! Class OnCarRequestVideoFocusMsg
/***************************************************************************
 ** FUNCTION:  OnCarRequestVideoFocusMsg::OnCarRequestVideoFocusMsg
 ***************************************************************************/
OnCarRequestVideoFocusMsg::OnCarRequestVideoFocusMsg():m_enOnCarVideoFocus(e8_ONCAR_VIDEOFOCUS_UNKNOWN),
                                                      m_enOnCarVideoFocusReason(e8_ONCAR_VIDEOFOCUS_REASON_BACKGROUND)
{
   ETG_TRACE_USR1(("OnCarRequestVideoFocusMsg::OnCarRequestVideoFocusMsg Entered\n"));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  OnCarRequestVideoFocusMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCarRequestVideoFocusMsg,spi_tclOnCarVideoDispatcher);

/***************************************************************************
 ** FUNCTION:  OnCarRequestVideoFocusMsg::vAllocateMsg
 ***************************************************************************/
t_Void OnCarRequestVideoFocusMsg::vAllocateMsg()
{

}
/***************************************************************************
 ** FUNCTION:  OnCarRequestVideoFocusMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void OnCarRequestVideoFocusMsg::vDeAllocateMsg()
{

}

//! Class OnCarVideoErrorMsg
/***************************************************************************
 ** FUNCTION:  OnCarVideoErrorMsg::OnCarVideoErrorMsg
 ***************************************************************************/
OnCarVideoErrorMsg::OnCarVideoErrorMsg():m_enOnCarSinkError(e32_ONCAR_SINK_NO_ERROR)
{
   ETG_TRACE_USR1(("OnCarVideoErrorMsg::OnCarVideoErrorMsg Entered\n"));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  OnCarVideoErrorMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCarVideoErrorMsg,spi_tclOnCarVideoDispatcher);

/***************************************************************************
 ** FUNCTION:  OnCarVideoErrorMsg::vAllocateMsg
 ***************************************************************************/
t_Void OnCarVideoErrorMsg::vAllocateMsg()
{

}
/***************************************************************************
 ** FUNCTION:  OnCarVideoErrorMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void OnCarVideoErrorMsg::vDeAllocateMsg()
{

}

//! Class OnCarSupportedResolutionMsg

/***************************************************************************
 ** FUNCTION:  OnCarSupportedResolutionMsg::OnCarSupportedResolutionMsg
 ***************************************************************************/
OnCarSupportedResolutionMsg::OnCarSupportedResolutionMsg():m_u32Width(0),m_u32Height(0)
{
   ETG_TRACE_USR1(("OnCarSupportedResolutionMsg::OnCarSupportedResolutionMsg Entered"));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  OnCarSupportedResolutionMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCarSupportedResolutionMsg,spi_tclOnCarVideoDispatcher);

/***************************************************************************
 ** FUNCTION:  OnCarSupportedResolutionMsg::vAllocateMsg
 ***************************************************************************/
t_Void OnCarSupportedResolutionMsg::vAllocateMsg()
{

}
/***************************************************************************
 ** FUNCTION:  OnCarVideoErrorMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void OnCarSupportedResolutionMsg::vDeAllocateMsg()
{

}

//! Class spi_tclOnCarVideoDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclOnCarVideoDispatcher::spi_tclOnCarVideoDispatcher
 ***************************************************************************/
spi_tclOnCarVideoDispatcher::spi_tclOnCarVideoDispatcher()
{
   ETG_TRACE_USR1(("spi_tclOnCarVideoDispatcher::spi_tclOnCarVideoDispatcher entered"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarVideoDispatcher::~spi_tclOnCarVideoDispatcher
 ***************************************************************************/
spi_tclOnCarVideoDispatcher::~spi_tclOnCarVideoDispatcher()
{
   ETG_TRACE_USR1(("spi_tclOnCarVideoDispatcher::~spi_tclOnCarVideoDispatcher entered"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarStartVideoPlaybackMsg* poOnCarStartVideoPlaybackMsg)
 ***************************************************************************/
t_Void spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarStartVideoPlaybackMsg* poOnCarStartVideoPlaybackMsg) const
{
   ETG_TRACE_USR1(("spi_tclOnCarVideoDispatcher::vHandleVideoMsg entered"));
   if (NULL != poOnCarStartVideoPlaybackMsg)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespVideo,
            e16ONCAR_VIDEO_REGID,
               vPostOnCarStartVideoPlaybackMsg());
   } // if (NULL != poOnCarStartVideoPlaybackMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarStopVideoPlaybackMsg* poOnCarStopVideoPlaybackMsg)
 ***************************************************************************/
t_Void spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarStopVideoPlaybackMsg* poOnCarStopVideoPlaybackMsg) const
{
   ETG_TRACE_USR1(("spi_tclOnCarVideoDispatcher::vHandleVideoMsg entered"));
   if (NULL != poOnCarStopVideoPlaybackMsg)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespVideo,
            e16ONCAR_VIDEO_REGID,
               vPostOnCarStopVideoPlaybackMsg());
   } // if (NULL != poOnCarStopVideoPlaybackMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarRequestVideoFocusMsg* poOnCarRequestVideoFocusMsg)
 ***************************************************************************/
t_Void spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarRequestVideoFocusMsg* poOnCarRequestVideoFocusMsg) const
{
   ETG_TRACE_USR1(("spi_tclOnCarVideoDispatcher::vHandleVideoMsg entered"));
   if (NULL != poOnCarRequestVideoFocusMsg)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespVideo,
            e16ONCAR_VIDEO_REGID,
               vPostOnCarRequestVideoFocusMsg(poOnCarRequestVideoFocusMsg->m_enOnCarVideoFocus,poOnCarRequestVideoFocusMsg->m_enOnCarVideoFocusReason));
   } // if (NULL != poOnCarRequestVideoFocusMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarVideoErrorMsg* poOnCarVideoErrorMsg)
 ***************************************************************************/
t_Void spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarVideoErrorMsg* poOnCarVideoErrorMsg) const
{
   ETG_TRACE_USR1(("spi_tclOnCarVideoDispatcher::vHandleVideoMsg entered"));
   if (NULL != poOnCarVideoErrorMsg)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespVideo,
            e16ONCAR_VIDEO_REGID,
               vPostOnCarVideoErrorMsg(poOnCarVideoErrorMsg->m_enOnCarSinkError));
   } // if (NULL != poOnCarVideoErrorMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarSupportedResolutionMsg* poOnCarSupportedResolutionMsg)
 ***************************************************************************/
t_Void spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarSupportedResolutionMsg* poOnCarSupportedResolutionMsg) const
{
   ETG_TRACE_USR1(("spi_tclOnCarVideoDispatcher::vHandleVideoMsg entered"));
   if (NULL != poOnCarSupportedResolutionMsg)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespVideo,
            e16ONCAR_VIDEO_REGID,
               vPostOnCarSupportedResolutionMsg(poOnCarSupportedResolutionMsg->m_u32Width,
                                                poOnCarSupportedResolutionMsg->m_u32Height));
   } // if (NULL != poOnCarSupportedResolutionMsg)
}
///////////////////////////////////////////////////////////////////////////////
// <EOF>
