/*!
 *******************************************************************************
 * \file              spi_tclOnCarVideoCbs.cpp
 * \brief             Video Endpoint callbacks handler for OnCar
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Video Endpoint callbacks handler for OnCar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 09.03.2018 |  Unmukt Jain                 | Initial Version

 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclOnCarMsgQInterface.h"
#include "spi_tclOnCarVideoDispatcher.h"
#include "SPI_OnCarTypes.h"
#include "spi_tclOnCarVideoCbs.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_ONCARWRAPPER
#include "trcGenProj/Header/spi_tclOnCarVideoCbs.cpp.trc.h"
#endif
#endif


/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarVideoCbs::startVideoPlaybackRequestCallback(...)
***************************************************************************/
void spi_tclOnCarVideoCbs::startVideoPlaybackRequestCallback()
{
   ETG_TRACE_USR1(("spi_tclOnCarVideoCbs::startVideoPlaybackRequestCallback entered"));
   OnCarStartVideoPlaybackMsg oOnCarStartVideoPlaybackMsg;
   spi_tclOnCarMsgQInterface *poMsgQinterface = spi_tclOnCarMsgQInterface::getInstance();
   if (NULL != poMsgQinterface)
   {
      poMsgQinterface->bWriteMsgToQ(&oOnCarStartVideoPlaybackMsg, sizeof(oOnCarStartVideoPlaybackMsg));
   }//if (NULL != poMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarVideoCbs::videoErrorCallback(...)
***************************************************************************/
void spi_tclOnCarVideoCbs::videoErrorCallback(ONCARSINKERROR error)
{
   ETG_TRACE_ERR(("[ERR]:spi_tclOnCarVideoCbs::videoErrorCallback entered error=%d",error));
   tenOnCarSinkError enOnCarSinkError = e32_ONCAR_SINK_NO_ERROR;
   enOnCarSinkError = static_cast<tenOnCarSinkError>(error);

   OnCarVideoErrorMsg oOnCarVideoErrorMsg;
   oOnCarVideoErrorMsg.m_enOnCarSinkError = enOnCarSinkError;
   spi_tclOnCarMsgQInterface *poMsgQinterface = spi_tclOnCarMsgQInterface::getInstance();
   if (NULL != poMsgQinterface)
   {
      poMsgQinterface->bWriteMsgToQ(&oOnCarVideoErrorMsg, sizeof(oOnCarVideoErrorMsg));
   }//if (NULL != poMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarVideoCbs::stopVideoPlaybackRequestCallback(...)
***************************************************************************/
void spi_tclOnCarVideoCbs::stopVideoPlaybackRequestCallback()
{
   ETG_TRACE_USR1(("spi_tclOnCarVideoCbs::stopVideoPlaybackRequestCallback entered"));
   OnCarStopVideoPlaybackMsg oOnCarStopVideoPlaybackMsg;
   spi_tclOnCarMsgQInterface *poMsgQinterface = spi_tclOnCarMsgQInterface::getInstance();
   if (NULL != poMsgQinterface)
   {
      poMsgQinterface->bWriteMsgToQ(&oOnCarStopVideoPlaybackMsg, sizeof(oOnCarStopVideoPlaybackMsg));
   }//if (NULL != poMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarVideoCbs::requestVideoFocusCallback(...)
***************************************************************************/
void spi_tclOnCarVideoCbs::requestVideoFocusCallback(const VIDEOFOCUS focus,const VIDEOFOCUS_REASON reason)
{
   ETG_TRACE_USR1(("spi_tclOnCarVideoCbs::requestVideoFocusCallback entered focus=%d reason=%d",focus,reason));
   tenOnCarVideoFocus enOnCarVideoFocus = e8_ONCAR_VIDEOFOCUS_UNKNOWN ;
   enOnCarVideoFocus = static_cast<tenOnCarVideoFocus>(focus);
   tenOnCarVideoFocusReason enOnCarVideoFocusReason = e8_ONCAR_VIDEOFOCUS_REASON_BACKGROUND;
   enOnCarVideoFocusReason = static_cast<tenOnCarVideoFocusReason>(reason);
   OnCarRequestVideoFocusMsg oOnCarRequestVideoFocusMsg;
   oOnCarRequestVideoFocusMsg.m_enOnCarVideoFocus = enOnCarVideoFocus;
   oOnCarRequestVideoFocusMsg.m_enOnCarVideoFocusReason = enOnCarVideoFocusReason;
   spi_tclOnCarMsgQInterface *poMsgQinterface = spi_tclOnCarMsgQInterface::getInstance();
   if (NULL != poMsgQinterface)
   {
      poMsgQinterface->bWriteMsgToQ(&oOnCarRequestVideoFocusMsg, sizeof(oOnCarRequestVideoFocusMsg));
   }//if (NULL != poMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarVideoCbs::supportedResolution(...)
***************************************************************************/
void spi_tclOnCarVideoCbs::supportedResolution(uint32_t width,uint32_t height)
{
   ETG_TRACE_USR1(("spi_tclOnCarVideoCbs::supportedResolution entered with width=%d, height=%d",width,height));
   OnCarSupportedResolutionMsg oOnCarSupportedResolutionMsg;
   oOnCarSupportedResolutionMsg.m_u32Width = width;
   oOnCarSupportedResolutionMsg.m_u32Height = height;
   spi_tclOnCarMsgQInterface *poMsgQinterface = spi_tclOnCarMsgQInterface::getInstance();
   if (NULL != poMsgQinterface)
   {
      poMsgQinterface->bWriteMsgToQ(&oOnCarSupportedResolutionMsg, sizeof(oOnCarSupportedResolutionMsg));
   }//if (NULL != poMsgQinterface)
}

