/***********************************************************************/
/*!
* \file   spi_tclOnCarCmdVideo.cpp
* \brief  Wrapper class for OnCar Video Sink
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Wrapper class for OnCar Video Sink
AUTHOR:         Dhiraj Asopa
COPYRIGHT:      &copy; RBEI

HISTORY:
Date         | Author                    | Modification
16.04.2018   | Dhiraj Asopa              | Initial Version

\endverbatim
*************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_tclOnCarCmdVideo.h"
#include "spi_tclOnCarDataIntf.h"
#ifdef _LINUXX86MAKE_ //for unit testing
  #include "Mock_OnCarVideoEndpoint.h"
  #include "Mock_OnCarAPI.h"
#else
  #include "OnCarAPI.h"
#endif



//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_ONCARWRAPPER
#include "trcGenProj/Header/spi_tclOnCarCmdVideo.cpp.trc.h"
#endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
/***************************************************************************
** FUNCTION:  spi_tclOnCarCmdVideo::spi_tclOnCarCmdVideo()
***************************************************************************/
spi_tclOnCarCmdVideo::spi_tclOnCarCmdVideo(): m_poOnCarVideoEndpoint(NULL)
{
   ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::spi_tclOnCarCmdVideo entered "));
}

/***************************************************************************
** FUNCTION:  spi_tclOnCarCmdVideo::~spi_tclOnCarCmdVideo()
***************************************************************************/
spi_tclOnCarCmdVideo::~spi_tclOnCarCmdVideo()
{
   ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::~spi_tclOnCarCmdVideo() entered "));
   m_oEndpointLock.s16Lock();
   m_spoVideoCbs = nullptr;
   m_oEndpointLock.vUnlock();
   ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::~spi_tclOnCarCmdVideo() left "));
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclOnCarCmdVideo::bInitialize()
***************************************************************************/
t_Bool spi_tclOnCarCmdVideo::bInitialize(const trOnCarVideoConfig& corfrOnCarVideoConfig)
{
   ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::bInitialize() entered"));
   m_oEndpointLock.s16Lock();
   t_Bool bRegSuccess = false;
   spi_tclOnCarDataIntf *poOnCarDataIntf = spi_tclOnCarDataIntf::getInstance();
   OnCarAPI *poOnCarAPI = NULL;
   if(poOnCarDataIntf)
   {
      m_poOnCarVideoEndpoint = poOnCarDataIntf->poGetVideoEndpointInstance();
      poOnCarAPI = poOnCarDataIntf->poGetOnCarAPIInstance();
   }
   if((m_poOnCarVideoEndpoint)&& (poOnCarAPI))
   {
       vSetVideoConfig(corfrOnCarVideoConfig);
       m_spoVideoCbs = std::make_shared<spi_tclOnCarVideoCbs>();
       if(m_spoVideoCbs)
       {
          m_poOnCarVideoEndpoint->registerCallbacks(m_spoVideoCbs);
          m_poOnCarVideoEndpoint->init();
          bRegSuccess = poOnCarAPI->registerService(m_poOnCarVideoEndpoint);
          ETG_TRACE_USR2(("[DESC]:Video Endpoint intialization result: "
                "Registration success %d",ETG_ENUM(BOOL, bRegSuccess)));
       }
   }// if (NULL == m_poOnCarVideoEndpoint)
   m_oEndpointLock.vUnlock();
   ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::bInitialize() returned with bRetval=%d",bRegSuccess));
   return bRegSuccess;
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarCmdVideo::vDestroyVideoEndpointInstance()
***************************************************************************/
t_Void spi_tclOnCarCmdVideo::vDestroyVideoEndpointInstance()
{
   ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::vDestroyVideoEndpointInstance() entered "));
   spi_tclOnCarDataIntf *poOnCarDataIntf = spi_tclOnCarDataIntf::getInstance();
   m_oEndpointLock.s16Lock();
   if(NULL != m_poOnCarVideoEndpoint && NULL != poOnCarDataIntf)
   {
      poOnCarDataIntf->vDestroyEndpointInstance(m_poOnCarVideoEndpoint,e8_ONCAR_OBJECTFACTORY_VIDEO_ENDPOINT);
      m_poOnCarVideoEndpoint = NULL;
   }
   m_spoVideoCbs = nullptr;
   m_oEndpointLock.vUnlock();
   ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::vDestroyVideoEndpointInstance() left "));
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarCmdVideo::vUninitialize()
***************************************************************************/
t_Void spi_tclOnCarCmdVideo::vUninitialize()
{
   ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::vUninitialize() entered "));
   m_oEndpointLock.s16Lock();
   if(NULL != m_poOnCarVideoEndpoint)
   {
      m_poOnCarVideoEndpoint->deinit();
   }
   m_oEndpointLock.vUnlock();
   ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::vUninitialize() left "));
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarCmdVideo::vSetVideoConfig()
***************************************************************************/
t_Void spi_tclOnCarCmdVideo::vSetVideoConfig(const trOnCarVideoConfig& corfrOnCarVideoConfig )
{
   ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::vSetVideoConfig entered "));
   if(NULL != m_poOnCarVideoEndpoint)
   {
      VideoConfig oVideoConfig;
      oVideoConfig.fps = corfrOnCarVideoConfig.u16Fps;
      oVideoConfig.density = corfrOnCarVideoConfig.u16Density;
      oVideoConfig.pixelAspectRatio = corfrOnCarVideoConfig.u16PixelAspectRatio;
      oVideoConfig.projectionScreenHeight = corfrOnCarVideoConfig.u32ProjectionScreenHeight;
      oVideoConfig.projectionScreenWidth = corfrOnCarVideoConfig.u32ProjectionScreenWidth;
      oVideoConfig.videoPipeline = corfrOnCarVideoConfig.szVideoPipeline;

      ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::vSetVideoConfig:fps-%d",oVideoConfig.fps));
      ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::vSetVideoConfig:density-%d",oVideoConfig.density));
      ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::vSetVideoConfig:pixelAspectRatio-%d",oVideoConfig.pixelAspectRatio));
      ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::vSetVideoConfig:projectionScreenHeight-%d",oVideoConfig.projectionScreenHeight));
      ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::vSetVideoConfig:projectionScreenWidth-%d",oVideoConfig.projectionScreenWidth));
      ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::vSetVideoConfig:videoPipeline-%s",oVideoConfig.videoPipeline.c_str()));

      m_poOnCarVideoEndpoint->setVideoConfig(oVideoConfig);
   }//if (NULL != m_poOnCarVideoEndpoint)
   else
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclOnCarCmdVideo::vSetVideoConfig- Video Sink is NULL"));
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarCmdVideo::vSetVideoFocus()
***************************************************************************/
t_Void spi_tclOnCarCmdVideo::vSetVideoFocus(tenOnCarVideoFocus enVideoFocus)
{
   ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::vSetVideoFocus:VideoFocusMode-%d",enVideoFocus));
   m_oEndpointLock.s16Lock();
   if(NULL != m_poOnCarVideoEndpoint)
   {
      VIDEOFOCUS videofocus = static_cast<VIDEOFOCUS> (enVideoFocus);
      m_poOnCarVideoEndpoint->setVideoFocus(videofocus);

   }//if (NULL != m_poVideoSink)
   m_oEndpointLock.vUnlock();
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarCmdVideo::acknowledgeStartVideoRequest()
***************************************************************************/
t_Void spi_tclOnCarCmdVideo::acknowledgeStartVideoRequest()
{
   ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::acknowledgeStartVideoRequest entered "));
   m_oEndpointLock.s16Lock();
   if(NULL != m_poOnCarVideoEndpoint)
   {
	   m_poOnCarVideoEndpoint->acknowledgeStartVideoRequest();
   }
   m_oEndpointLock.vUnlock();
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarCmdVideo::acknowledgeStopVideoRequest()
***************************************************************************/
t_Void spi_tclOnCarCmdVideo::acknowledgeStopVideoRequest()
{
   ETG_TRACE_USR1(("spi_tclOnCarCmdVideo::acknowledgeStopVideoRequest entered "));
   m_oEndpointLock.s16Lock();
   if(NULL != m_poOnCarVideoEndpoint)
   {
	   m_poOnCarVideoEndpoint->acknowledgeStopVideoRequest();
   }
   m_oEndpointLock.vUnlock();
}


///////////////////////////////////////////////////////////////////////////////
// <EOF>
