/*!
 *******************************************************************************
 * \file              spi_tclOnCarSessionCbs.h
 * \brief             Class implementing callbacks from OnCarAPI
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Class implementing callbacks from OnCarAPI
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 08.03.2018 |  Dhiraj Asopa                | Initial Version

 \endverbatim
 ******************************************************************************/
/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/


#ifndef SPI_TCL_ONCAR_SESSION_CBS_H
#define SPI_TCL_ONCAR_SESSION_CBS_H

/* *************  includes  ************* */

#include "BaseTypes.h"
#include "OnCarAPI.h"

/* This class includes a general set of IOnCarSessionCallbacks that must be set up for the OnCarAPI */
class spi_tclOnCarSessionCbs : public IOnCarSessionCallbacks
{
public:
    spi_tclOnCarSessionCbs() { }

    ~spi_tclOnCarSessionCbs() { }

   //! Callbacks from OnCarAPI
    /***************************************************************************
     ** FUNCTION:  void spi_tclOnCarSessionCbs::onCarSessionStatusCallback()
     ***************************************************************************/
    /*!
     * \fn      onCarSessionStatusCallback
     * \brief   Called to notify the OnCar session status.
     * \param	state Enumeration of ONCARSESSION_STATE
   ***************************************************************************/
   void onCarSessionStatusCallback(const ONCARSESSION_STATE state);

   /***************************************************************************
    ** FUNCTION:  void spi_tclOnCarSessionCbs::onCarSessionErrorCallbacks()
    ***************************************************************************/
   /*!
    * \fn      onCarSessionErrorCallbacks
    * \brief   Called when error occurs during OnCar session.
    * \param   error Enumeration of ONCARSINKERROR
    **************************************************************************/
    void onCarSessionErrorCallbacks(const ONCARSINKERROR error);

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclOnCarSessionCbs::onCarSinkAppStateCallbacks()
    ***************************************************************************/
   /*!
    * \fn      onCarSinkAppStateCallbacks
    * \brief   Called by MD during OnCar Session to notify status of different application states like Navigation,speech etc.
    * \param NavigationAppState eONCARSINKAPPSTATE_PROJECTION if OnCar route guidance is active.
    * \param SpeechAppState eONCARSINKAPPSTATE_PROJECTION if OnCar voice sessoin is active. Note this is retained for future use. For now eONCARSINKAPPSTATE_NATIVE is *                       valid.
    * \param PhoneAppState eONCARSINKAPPSTATE_PROJECTION if OnCar Phone call is active.
    **************************************************************************/
    void onCarSinkAppStateCallbacks (const ONCARSINK_APP_STATE NavigationAppState,
                                     const ONCARSINK_APP_STATE SpeechAppState,
                                     const ONCARSINK_APP_STATE PhoneAppState);

private:
    /***************************************************************************
        ** FUNCTION: spi_tclOnCarSessionCbs(const spi_tclOnCarSessionCbs &rfcoObject)
        ***************************************************************************/
       /*!
        * \fn      spi_tclOnCarSessionCbs(const spi_tclOnCarSessionCbs &rfcoObject)
        * \brief   Copy constructor not implemented hence made private
        **************************************************************************/
       spi_tclOnCarSessionCbs(const spi_tclOnCarSessionCbs& rfcoObject);

       /***************************************************************************
        ** FUNCTION: const spi_tclOnCarSessionCbs & operator=(
        **                                 const spi_tclOnCarSessionCbs &rfcoObject);
        ***************************************************************************/
       /*!
        * \fn      const spi_tclOnCarSessionCbs & operator=(const spi_tclOnCarSessionCbs &rfcoObject);
        * \brief   assignment operator not implemented hence made private
        **************************************************************************/
       const spi_tclOnCarSessionCbs& operator=(const spi_tclOnCarSessionCbs& rfcoObject);
};


#endif /* SPI_TCL_ONCAR_SESSION_CBS_H */
