/***********************************************************************/
/*!
 * \file  spi_tclOnCarMetadataDispatcher.cpp
 * \brief Message Dispatcher for Metadata Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Metadata Messages
 AUTHOR:         Rishav Sardar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 31.05.2018  | Rishav Sardar         | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclOnCarMetadataDispatcher.h"
#include "spi_tclOnCarRespMetadata.h"
#include "RespRegister.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
      #include "trcGenProj/Header/spi_tclOnCarMetadataDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleMetadataMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  OnCarMetadataMsgBase::OnCarMetadataMsgBase
 ***************************************************************************/
OnCarMetadataMsgBase::OnCarMetadataMsgBase()
{
   ETG_TRACE_USR1(("[CONSTRUCTOR]:OnCarMetadataMsgBase::OnCarMetadataMsgBase() entered "));
   vSetServiceID(e32MODULEID_ONCARMETADATA);
   ETG_TRACE_USR1(("[CONSTRUCTOR]:OnCarMetadataMsgBase::OnCarMetadataMsgBase() left "));
}//!end of OnCarMetadataMsgBase()

/***************************************************************************
 ** FUNCTION:  OnCarMediaMetadataUpdateMsg::OnCarMediaMetadataUpdateMsg
 ***************************************************************************/
OnCarMediaMetadataUpdateMsg::OnCarMediaMetadataUpdateMsg():m_prOnCarMediaMetadata(NULL)
{
   ETG_TRACE_USR1(("[CONSTRUCTOR]:OnCarMediaMetadataUpdateMsg::OnCarMediaMetadataUpdateMsg() entered "));
   vAllocateMsg();
   ETG_TRACE_USR1(("[CONSTRUCTOR]:OnCarMediaMetadataUpdateMsg::OnCarMediaMetadataUpdateMsg() left "));
}//!end of OnCarMediaMetadataUpdateMsg()

/***************************************************************************
 ** FUNCTION:  OnCarMediaMetadataUpdateMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCarMediaMetadataUpdateMsg, spi_tclOnCarMetadataDispatcher);

/***************************************************************************
 ** FUNCTION:  OnCarMediaMetadataUpdateMsg::vAllocateMsg
 ***************************************************************************/
t_Void OnCarMediaMetadataUpdateMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]:OnCarMediaMetadataUpdateMsg::vAllocateMsg() entered "));
   m_prOnCarMediaMetadata = new trOnCarMediaMetadata;
   SPI_NORMAL_ASSERT(NULL == m_prOnCarMediaMetadata);
   ETG_TRACE_USR1(("[FUNC]:OnCarMediaMetadataUpdateMsg::vAllocateMsg() left "));
}//!end of vAllocateMsg()

/***************************************************************************
 ** FUNCTION:  OnCarMediaMetadataUpdateMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void OnCarMediaMetadataUpdateMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]:OnCarMediaMetadataUpdateMsg::vDeAllocateMsg() entered "));
   RELEASE_MEM(m_prOnCarMediaMetadata);
   ETG_TRACE_USR1(("[FUNC]:OnCarMediaMetadataUpdateMsg::vDeAllocateMsg() left "));
}//!end of vDeAllocateMsg()

/***************************************************************************
 ** FUNCTION:  OnCarMediaPlaybackStatusUpdateMsg::OnCarMediaPlaybackStatusUpdateMsg
 ***************************************************************************/
OnCarMediaPlaybackStatusUpdateMsg::OnCarMediaPlaybackStatusUpdateMsg():m_prOnCarMediaPlaybackStatus(NULL)
{
   ETG_TRACE_USR1(("[CONSTRUCTOR]:OnCarMediaPlaybackStatusUpdateMsg::OnCarMediaPlaybackStatusUpdateMsg() entered "));
   vAllocateMsg();
   ETG_TRACE_USR1(("[CONSTRUCTOR]:OnCarMediaPlaybackStatusUpdateMsg::OnCarMediaPlaybackStatusUpdateMsg() left "));
}//!end of OnCarMediaPlaybackStatusUpdateMsg()

/***************************************************************************
 ** FUNCTION:  OnCarMediaPlaybackStatusUpdateMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCarMediaPlaybackStatusUpdateMsg, spi_tclOnCarMetadataDispatcher);

/***************************************************************************
 ** FUNCTION:  OnCarMediaPlaybackStatusUpdateMsg::vAllocateMsg
 ***************************************************************************/
t_Void OnCarMediaPlaybackStatusUpdateMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]:OnCarMediaPlaybackStatusUpdateMsg::vAllocateMsg() entered "));
   m_prOnCarMediaPlaybackStatus = new trOnCarMediaPlaybackStatus;
   SPI_NORMAL_ASSERT(NULL == m_prOnCarMediaPlaybackStatus);
   ETG_TRACE_USR1(("[FUNC]:OnCarMediaPlaybackStatusUpdateMsg::vAllocateMsg() left "));
}//!end of vAllocateMsg()

/***************************************************************************
 ** FUNCTION:  OnCarMediaPlaybackStatusUpdateMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void OnCarMediaPlaybackStatusUpdateMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]:OnCarMediaPlaybackStatusUpdateMsg::vDeAllocateMsg() entered "));
   RELEASE_MEM(m_prOnCarMediaPlaybackStatus);
   ETG_TRACE_USR1(("[FUNC]:OnCarMediaPlaybackStatusUpdateMsg::vDeAllocateMsg() left "));
}//!end of vDeAllocateMsg()

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarMetadataDispatcher::spi_tclOnCarMetadataDispatcher
 ***************************************************************************/
spi_tclOnCarMetadataDispatcher::spi_tclOnCarMetadataDispatcher()
{
   ETG_TRACE_USR1(("[DESTRUCTOR]:spi_tclOnCarMetadataDispatcher::spi_tclOnCarMetadataDispatcher entered "));
   ETG_TRACE_USR1(("[DESTRUCTOR]:spi_tclOnCarMetadataDispatcher::spi_tclOnCarMetadataDispatcher entered "));
}//!end of spi_tclOnCarMetadataDispatcher()

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarMetadataDispatcher::~spi_tclOnCarMetadataDispatcher
 ***************************************************************************/
spi_tclOnCarMetadataDispatcher::~spi_tclOnCarMetadataDispatcher()
{
   ETG_TRACE_USR1(("[CONSTRUCTOR]:spi_tclOnCarMetadataDispatcher::~spi_tclOnCarMetadataDispatcher entered "));
   ETG_TRACE_USR1(("[CONSTRUCTOR]:spi_tclOnCarMetadataDispatcher::~spi_tclOnCarMetadataDispatcher entered "));
}//!end of ~spi_tclOnCarMetadataDispatcher()

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarMetadataDispatcher::vHandleMetadatMsg(OnCarMediaMetadataUpdateMsg...)
 ***************************************************************************/
t_Void spi_tclOnCarMetadataDispatcher::
vHandleMetadataMsg(OnCarMediaMetadataUpdateMsg* poMediaMetadataUpdate) const
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarMetadataDispatcher::vHandleMetadataMsg() entered "));
   if (poMediaMetadataUpdate)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespMetadata,
    		  e16ONCAR_METADATA_REGID,
         vPostOnCarMediaMetadataUpdate(poMediaMetadataUpdate->m_prOnCarMediaMetadata));
   }//if (poMediaMetadataUpdate)
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarMetadataDispatcher::vHandleMetadataMsg() left "));
}//!end of vHandleMetadataMsg()

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarMetadataDispatcher::vHandleMetadatMsg(OnCarMediaPlaybackStatusUpdateMsg...)
 ***************************************************************************/
t_Void spi_tclOnCarMetadataDispatcher::
vHandleMetadataMsg(OnCarMediaPlaybackStatusUpdateMsg* poMediaPlaybackStatusUpdate) const
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarMetadataDispatcher::vHandleMetadataMsg() entered "));
   if (poMediaPlaybackStatusUpdate)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespMetadata,
    		  e16ONCAR_METADATA_REGID,
         vPostOnCarMediaPlaybackStatusUpdate(poMediaPlaybackStatusUpdate->m_prOnCarMediaPlaybackStatus));
   }//if (MediaPlaybackStatusUpdate)
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarMetadataDispatcher::vHandleMetadataMsg() left "));
}//!end of vHandleMetadataMsg()

// <EOF>
