/*!
 *******************************************************************************
 * \file             spi_tclOnCarRespMetadata.h
 * \brief            OnCar Wrapper Response class for Metadata
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    OnCar Wrapper Response class for Metadata
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                 | Modifications
29.03.2018  | Rishav Sardar           | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLONCARRESPMETADATA_H_
#define _SPI_TCLONCARRESPMETADATA_H_

#include "SPI_OnCarTypes.h"
#include "RespBase.h"

class spi_tclOnCarRespMetadata: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclOnCarRespMetadata::spi_tclOnCarRespMetadata()
    ***************************************************************************/
   /*!
    * \fn      spi_tclOnCarRespMetadata()
    * \brief   Constructor
    * \sa      spi_tclOnCarRespMetadata()
    **************************************************************************/
    spi_tclOnCarRespMetadata(): RespBase(e16ONCAR_METADATA_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclOnCarRespMetadata::~spi_tclOnCarRespMetadata()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclOnCarRespMetadata()
    * \brief   Destructor
    * \sa      spi_tclOnCarRespMetadata()
    **************************************************************************/
   virtual ~spi_tclOnCarRespMetadata() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarRespMetadata::vPostOnCarMediaMetadataUpdate()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostOnCarMediaMetadataUpdate()
    * \brief   Called when media playback metadata is sent by OnCar device.
    *          Mandatory interface to be implemented.
    * \param   [IN] trOnCarMediaMetadata *rOnCarMediaMetadata
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostOnCarMediaMetadataUpdate(const trOnCarMediaMetadata* rOnCarMediaMetadata) = 0;

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarRespMetadata::vPostOnCarMediaPlaybackStatusUpdate()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostOnCarMediaPlaybackStatusUpdate()
    * \brief   Called when media playback status is sent by OnCar device.
    *          Mandatory interface to be implemented.
    * \param   [IN] trOnCarMediaPlaybackStatus* rOnCarMediaPlaybackStatus
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostOnCarMediaPlaybackStatusUpdate(const trOnCarMediaPlaybackStatus* rOnCarMediaPlaybackStatus) = 0;

};

#endif /* _SPI_TCLONCARRESPMETADATA_H_ */
