/***********************************************************************/
/*!
 * \file  spi_tclOnCarMetadataDispatcher.h
 * \brief Message Dispatcher for Metadata Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Bluetooth Messages
 AUTHOR:         Rishav Sardar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 31.05.2018  | Rishav Sardar         | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLONCARMETADATADISPATCHER_H_
#define _SPI_TCLONCARMETADATADISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPI_OnCarTypes.h"

/**************Forward Declarations******************************************/
class spi_tclOnCarMetadataDispatcher;

/****************************************************************************/
/*!
 * \class OnCarMetadataMsgBase
 * \brief Base Message type for all Metadata messages
 ****************************************************************************/
class OnCarMetadataMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  OnCarMetadataMsgBase::OnCarMetadataMsgBase
    ***************************************************************************/
   /*!
    * \fn      OnCarMetadataMsgBase()
    * \brief   Default constructor
    **************************************************************************/
    OnCarMetadataMsgBase();

   /***************************************************************************
    ** FUNCTION:  OnCarMetadataMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclOnCarMetadataDispatcher* poMetadataDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poMetadataDispatcher : pointer to Message dispatcher for Metadata
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclOnCarMetadataDispatcher* poMetadataDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  OnCarMetadataMsgBase::~OnCarMetadataMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~OnCarMetadataMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~OnCarMetadataMsgBase()
   {

   }
};

/****************************************************************************/
/*!
 * \class OnCarMediaMetadataUpdateMsg
 * \brief Media Metadata Update Request msg
 ****************************************************************************/
class OnCarMediaMetadataUpdateMsg: public OnCarMetadataMsgBase
{
   public:

    trOnCarMediaMetadata *m_prOnCarMediaMetadata;

   /***************************************************************************
    ** FUNCTION:  OnCarMediaMetadataUpdateMsg::OnCarMediaMetadataUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      OnCarMediaMetadataUpdateMsg()
    * \brief   Default constructor
    **************************************************************************/
    OnCarMediaMetadataUpdateMsg();

   /***************************************************************************
    ** FUNCTION:  OnCarMediaMetadataUpdateMsg::~OnCarMediaMetadataUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      ~OnCarMediaMetadataUpdateMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~OnCarMediaMetadataUpdateMsg(){}

   /***************************************************************************
    ** FUNCTION:  OnCarMediaMetadataUpdateMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclOnCarMetadataDispatcher* poMetadataDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poMetadataDispatcher : pointer to Message dispatcher for Metadata
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclOnCarMetadataDispatcher* poMetadataDispatcher);

   /***************************************************************************
    ** FUNCTION:  OnCarMediaMetadataUpdateMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  OnCarMediaMetadataUpdateMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class OnCarMediaPlaybackStatusUpdateMsg
 * \brief Media Playback Status Update Request msg
 ****************************************************************************/
class OnCarMediaPlaybackStatusUpdateMsg: public OnCarMetadataMsgBase
{
   public:

    trOnCarMediaPlaybackStatus *m_prOnCarMediaPlaybackStatus;

   /***************************************************************************
    ** FUNCTION:  OnCarMediaPlaybackStatusUpdateMsg::OnCarMediaPlaybackStatusUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      OnCarMediaPlaybackStatusUpdateMsg()
    * \brief   Default constructor
    **************************************************************************/
    OnCarMediaPlaybackStatusUpdateMsg();

   /***************************************************************************
    ** FUNCTION:  OnCarMediaPlaybackStatusUpdateMsg::~OnCarMediaPlaybackStatusUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      ~OnCarMediaPlaybackStatusUpdateMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~OnCarMediaPlaybackStatusUpdateMsg(){}

   /***************************************************************************
    ** FUNCTION:  OnCarMediaPlaybackStatusUpdateMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclOnCarMetadataDispatcher* poMetadataDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poMetadataDispatcher : pointer to Message dispatcher for Metadata
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclOnCarMetadataDispatcher* poMetadataDispatcher);

   /***************************************************************************
    ** FUNCTION:  OnCarMediaPlaybackStatusUpdateMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  OnCarMediaPlaybackStatusUpdateMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class spi_tclOnCarMetadataDispatcher
 * \brief Message Dispatcher for Metadata Messages
 ****************************************************************************/
class spi_tclOnCarMetadataDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclOnCarMetadataDispatcher::spi_tclOnCarMetadataDispatcher
    ***************************************************************************/
   /*!
    * \fn      spi_tclOnCarMetadataDispatcher()
    * \brief   Default constructor
    **************************************************************************/
    spi_tclOnCarMetadataDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclOnCarMetadataDispatcher::~spi_tclOnCarMetadataDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclOnCarMetadataDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclOnCarMetadataDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclOnCarspi_tclOnCarMetadataDispatcher::vHandleMetadataMsg(OnCarMediaPlaybackStatusUpdateMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleMetadataMsg(OnCarMediaPlaybackStatusUpdateMsg* poMediaPlaybackStatusUpdate)
    * \brief   Handles Messages of OnCarMediaPlaybackStatusUpdateMsg type
    * \param   poMediaPlaybackStatusUpdate : pointer to OnCarMediaPlaybackStatusUpdateMsg.
    **************************************************************************/
   t_Void vHandleMetadataMsg(OnCarMediaPlaybackStatusUpdateMsg* poMediaPlaybackStatusUpdate) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclOnCarspi_tclOnCarMetadataDispatcher::vHandleMetadataMsg(OnCarMediaMetadataUpdateMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleMetadataMsg(OnCarMediaMetadataUpdateMsg* poMediaMetadataUpdate)
    * \brief   Handles Messages of OnCarMediaMetadataUpdateMsg type
    * \param   poMediaMetadataUpdate : pointer to OnCarMediaMetadataUpdateMsg.
    **************************************************************************/
   t_Void vHandleMetadataMsg(OnCarMediaMetadataUpdateMsg* poMediaMetadataUpdate) const;

};

#endif /* _SPI_TCLONCARMETADATADISPATCHER_H_ */
