/*!
 *******************************************************************************
 * \file              spi_tclOnCarMetadataCbs.h
 * \brief             Metadata Endpoint callbacks handler for OnCar
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Metadata Endpoint callbacks handler for OnCar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 20.03.2018 |  Rishav Sardar               | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef _SPI_TCLONCARMETADATACBS_H_
#define _SPI_TCLONCARMETADATACBS_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "OnCarMetadataEndpoint.h"
#include "BaseTypes.h"

/* This class includes a general set of IOnCarMediaMetadataCallbacks that must be set up for the Metadata Endpoint */
class spi_tclOnCarMetadataCbs : public IOnCarMediaMetadataCallbacks
{
public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclOnCarMetadataCbs::spi_tclOnCarMetadataCbs()
    ***************************************************************************/
   /*!
    * \fn      spi_tclOnCarMetadataCbs()
    * \brief   Constructor
    * \sa      ~spi_tclOnCarMetadataCbs()
    **************************************************************************/
	spi_tclOnCarMetadataCbs() { }

    /***************************************************************************
     ** FUNCTION:  virtual spi_tclOnCarMetadataCbs::~spi_tclOnCarMetadataCbs()
     ***************************************************************************/
    /*!
     * \fn      virtual ~spi_tclOnCarMetadataCbs()
     * \brief   Destructor
     * \sa      spi_tclOnCarMetadataCbs()
     **************************************************************************/
    virtual ~spi_tclOnCarMetadataCbs() {}

    /**********Start of functions overridden from IOnCarMediaMetadataCallbacks**********/

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarMetadataCbs::onCarMediaMetadataUpdate()
    ***************************************************************************/
    /*!
     *Called when media playback metadata message comes through.
	 * @param metadata structure of OnCarMediaMetadata type.
    */
    void onCarMediaMetadataUpdate(const OnCarMediaMetadata &metadata);

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarMetadataCbs::onCarMediaPlaybackStatusUpdate()
    ***************************************************************************/
    /*!
     * Called when media playback status message comes through.
	 * @param playbackstatus structure of OnCarMediaPlaybackStatus type.
    */
    void onCarMediaPlaybackStatusUpdate(const OnCarMediaPlaybackStatus &playbackstatus);

    /***********End of functions overridden from IOnCarVideoSinkCallbacks**********/


private:

    /***************************************************************************
     ** FUNCTION: spi_tclOnCarMetadataCbs(const spi_tclOnCarMetadataCbs &rfcoObject)
     ***************************************************************************/
    /*!
     * \fn      spi_tclOnCarMetadataCbs(const spi_tclOnCarMetadataCbs &rfcoObject)
     * \brief   Copy constructor not implemented hence made private
     **************************************************************************/
    spi_tclOnCarMetadataCbs(const spi_tclOnCarMetadataCbs& rfcoObject);

    /***************************************************************************
     ** FUNCTION: const spi_tclOnCarMetadataCbs & operator=(
     **                                 const spi_tclOnCarMetadataCbs &rfcoObject);
     ***************************************************************************/
    /*!
     * \fn      const spi_tclOnCarMetadataCbs & operator=(const spi_tclOnCarMetadataCbs &rfcoObject);
     * \brief   assignment operator not implemented hence made private
     **************************************************************************/
    const spi_tclOnCarMetadataCbs& operator=(const spi_tclOnCarMetadataCbs& rfcoObject);
};


#endif /* _SPI_TCLONCARMETADATACBS_H_ */
