/***********************************************************************/
/*!
 * \file  spi_tclOnCarInputDispatcher.cpp
 * \brief Message Dispatcher for Input Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Input Messages
 AUTHOR:         Rishav Sardar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 16.05.2018  | Rishav Sardar         | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclOnCarInputDispatcher.h"
#include "spi_tclOnCarRespInput.h"
#include "RespRegister.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
      #include "trcGenProj/Header/spi_tclOnCarInputDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleInputMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  OnCarInputMsgBase::OnCarInputMsgBase
 ***************************************************************************/
OnCarInputMsgBase::OnCarInputMsgBase()
{
   ETG_TRACE_USR1(("[CONSTRUCTOR]:OnCarInputMsgBase::OnCarInputMsgBase() entered "));
   vSetServiceID(e32MODULEID_ONCARINPUT);
   ETG_TRACE_USR1(("[CONSTRUCTOR]:OnCarInputMsgBase::OnCarInputMsgBase() left "));
}//!end of OnCarInputMsgBase()

/***************************************************************************
 ** FUNCTION:  OnCarNotifyErrorRequestMsg::OnCarNotifyErrorRequestMsg
 ***************************************************************************/
OnCarNotifyErrorRequestMsg::OnCarNotifyErrorRequestMsg():
        enOnCarSinkError(e32_ONCAR_SINK_NO_ERROR)
{
   ETG_TRACE_USR1(("[CONSTRUCTOR]:OnCarNotifyErrorRequestMsg::OnCarNotifyErrorRequestMsg() entered "));
   vAllocateMsg();
   ETG_TRACE_USR1(("[CONSTRUCTOR]:OnCarNotifyErrorRequestMsg::OnCarNotifyErrorRequestMsg() left "));
}//!end of OnCarNotifyErrorRequestMsg()

/***************************************************************************
 ** FUNCTION:  OnCarNotifyErrorRequestMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCarNotifyErrorRequestMsg, spi_tclOnCarInputDispatcher);

/***************************************************************************
 ** FUNCTION:  OnCarNotifyErrorRequestMsg::vAllocateMsg
 ***************************************************************************/
t_Void OnCarNotifyErrorRequestMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]:OnCarNotifyErrorRequestMsg::vAllocateMsg() entered "));
   ETG_TRACE_USR1(("[FUNC]:OnCarNotifyErrorRequestMsg::vAllocateMsg() left "));
}//!end of vAllocateMsg()

/***************************************************************************
 ** FUNCTION:  OnCarNotifyErrorRequestMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void OnCarNotifyErrorRequestMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]:OnCarNotifyErrorRequestMsg::vDeAllocateMsg() entered "));
   ETG_TRACE_USR1(("[FUNC]:OnCarNotifyErrorRequestMsg::vDeAllocateMsg() left "));
}//!end of vReportKnobkey()

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarInputDispatcher::spi_tclOnCarInputDispatcher
 ***************************************************************************/
spi_tclOnCarInputDispatcher::spi_tclOnCarInputDispatcher()
{
   ETG_TRACE_USR1(("[CONSTRUCTOR]:spi_tclOnCarInputDispatcher::spi_tclOnCarInputDispatcher() entered "));
   ETG_TRACE_USR1(("[CONSTRUCTOR]:spi_tclOnCarInputDispatcher::spi_tclOnCarInputDispatcher() left "));
}//!end of spi_tclOnCarInputDispatcher()

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarInputDispatcher::~spi_tclOnCarInputDispatcher
 ***************************************************************************/
spi_tclOnCarInputDispatcher::~spi_tclOnCarInputDispatcher()
{
    ETG_TRACE_USR1(("[DESTRUCTOR]:spi_tclOnCarInputDispatcher::spi_tclOnCarInputDispatcher() entered "));
    ETG_TRACE_USR1(("[DESTRUCTOR]:spi_tclOnCarInputDispatcher::spi_tclOnCarInputDispatcher() left "));
}//!end of vReportKnobkey()

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarInputDispatcher::vHandleInputMsg(OnCarNotifyErrorRequestMsg...)
 ***************************************************************************/
t_Void spi_tclOnCarInputDispatcher::
       vHandleInputMsg(OnCarNotifyErrorRequestMsg* poInputDispatcher)const
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarInputDispatcher::vHandleInputMsg() entered "));
   if (poInputDispatcher)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespInput,
             e16ONCAR_INPUT_REGID,
             vPostNotifyErrorRequest(poInputDispatcher->enOnCarSinkError));
   }//if (poInputDispatcher)
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarInputDispatcher::vHandleInputMsg() left "));
}//!end of vReportKnobkey()

// <EOF>
