/*!
 *******************************************************************************
 * \file              spi_tclOnCarInputCbs.cpp
 * \brief             Input Endpoint callbacks handler for OnCar
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Input Endpoint callbacks handler for OnCar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 20.03.2018 |  Rishav Sardar               | Initial Version

 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclOnCarMsgQInterface.h"
#include "spi_tclOnCarInputDispatcher.h"
#include "spi_tclOnCarInputCbs.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_ONCARWRAPPER
#include "trcGenProj/Header/spi_tclOnCarInputCbs.cpp.trc.h"
#endif
#endif


/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarInputCbs::startVideoPlaybackRequestCallback(...)
***************************************************************************/
void spi_tclOnCarInputCbs::notifyErrorCallback(ONCARSINKERROR error)
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarInputCbs::notifyErrorCallback() entered : ONCARSINKERROR = %d",error));
   spi_tclOnCarMsgQInterface* poMsgQInterface = spi_tclOnCarMsgQInterface::getInstance();
    if (poMsgQInterface)
    {
        OnCarNotifyErrorRequestMsg oNotifyErrorRequestMsg;
        oNotifyErrorRequestMsg.enOnCarSinkError = static_cast<tenOnCarSinkError>(error);
        poMsgQInterface->bWriteMsgToQ(&oNotifyErrorRequestMsg, sizeof(oNotifyErrorRequestMsg));
    }//if (poMsgQInterface)
    ETG_TRACE_USR1(("[FUNC]:spi_tclOnCarInputCbs::notifyErrorCallback() left "));
}//!end of notifyErrorCallback()


