/***********************************************************************/
/*!
 * \file  spi_tclOnCarMsgQThreadable.cpp
 * \brief implements threading based on MsgQthreader for OnCar Wrappers
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    implements threading based on MsgQthreader for OnCar Wrappers
 AUTHOR:         jun5kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 05.02.2018  | Unmukt Jain           | Initial version


 \endverbatim
 *************************************************************************/

#include "spi_tclOnCarMsgQThreadable.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclOnCarMsgQThreadable.cpp.trc.h"
#endif
#endif

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarMsgQThreadable::spi_tclOnCarMsgQThreadable()
 ***************************************************************************/
spi_tclOnCarMsgQThreadable::spi_tclOnCarMsgQThreadable()
{
   ETG_TRACE_USR1((" spi_tclOnCarMsgQThreadable::spi_tclOnCarMsgQThreadable() entered "));

   m_poOnCarVideoDispatcher = new(std::nothrow) spi_tclOnCarVideoDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poOnCarVideoDispatcher);

   m_poOnCarBTDispatcher = new(std::nothrow) spi_tclOnCarBTDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poOnCarBTDispatcher);

   m_poOnCarAudioDispatcher = new(std::nothrow) spi_tclOnCarAudioDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poOnCarAudioDispatcher);

   m_poOnCarSessionDispatcher = new(std::nothrow) spi_tclOnCarSessionDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poOnCarSessionDispatcher);

   m_poOnCarInputDispatcher = new(std::nothrow) spi_tclOnCarInputDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poOnCarInputDispatcher);

   m_poOnCarMetadataDispatcher = new(std::nothrow) spi_tclOnCarMetadataDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poOnCarMetadataDispatcher);

}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarMsgQThreadable::~spi_tclOnCarMsgQThreadable()
 ***************************************************************************/

spi_tclOnCarMsgQThreadable::~spi_tclOnCarMsgQThreadable()
{
   ETG_TRACE_USR1((" spi_tclOnCarMsgQThreadable::~spi_tclOnCarMsgQThreadable() entered "));
   RELEASE_MEM(m_poOnCarVideoDispatcher);
   RELEASE_MEM(m_poOnCarBTDispatcher);
   RELEASE_MEM(m_poOnCarAudioDispatcher);
   RELEASE_MEM(m_poOnCarSessionDispatcher);
   RELEASE_MEM(m_poOnCarInputDispatcher);
   RELEASE_MEM(m_poOnCarMetadataDispatcher);
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarMsgQThreadable::vExecute
 ***************************************************************************/

t_Void spi_tclOnCarMsgQThreadable::vExecute(tShlMessage *poMessage)
{
   ETG_TRACE_USR1((" spi_tclOnCarMsgQThreadable::vExecute entered"));
   if ((NULL != poMessage) && (NULL != poMessage->pvBuffer))
   {
      trMsgBase *prMsgBase = static_cast<trMsgBase*> (poMessage->pvBuffer);
      if (NULL != prMsgBase)
      {
         t_U32 u32ServiceID = prMsgBase->u32GetServiceID();
         ETG_TRACE_USR1(("ServiceID %d \n", u32ServiceID));

         //! Handle message to corresponding dispatcher based on Service ID
         switch (u32ServiceID)
         {
            case e32MODULEID_ONCARVIDEO:
            {
               OnCarVideoMsgBase *poVideoMsgBase = static_cast<OnCarVideoMsgBase*> (poMessage->pvBuffer);
               if (NULL != poVideoMsgBase)
               {
                  poVideoMsgBase->vDispatchMsg(m_poOnCarVideoDispatcher);
               }
            }
               break;
            case e32MODULEID_ONCARBLUETOOTH:
            {
               OnCarBTMsgBase *poBTMsgBase = static_cast<OnCarBTMsgBase*> (poMessage->pvBuffer);
               if (NULL != poBTMsgBase)
               {
                   poBTMsgBase->vDispatchMsg(m_poOnCarBTDispatcher);
               }
            }
               break;
            case e32MODULEID_ONCARSESSION:
            {
               OnCarSessionMsgBase *poSessionMsgBase = static_cast<OnCarSessionMsgBase*> (poMessage->pvBuffer);
               if (NULL != poSessionMsgBase)
               {
                  poSessionMsgBase->vDispatchMsg(m_poOnCarSessionDispatcher);
               }
            }
               break;
            case e32MODULEID_ONCARAUDIO:
            {
               OnCarAudioMsgBase *poAudioMsgBase = static_cast<OnCarAudioMsgBase*> (poMessage->pvBuffer);
               if (NULL != poAudioMsgBase)
               {
                  poAudioMsgBase->vDispatchMsg(m_poOnCarAudioDispatcher);
               }
            }
               break;
            case e32MODULEID_ONCARINPUT:
            {
               OnCarInputMsgBase *poInputMsgBase = static_cast<OnCarInputMsgBase*> (poMessage->pvBuffer);
               if (NULL != poInputMsgBase)
               {
                   poInputMsgBase->vDispatchMsg(m_poOnCarInputDispatcher);
               }
            }
               break;
            case e32MODULEID_ONCARMETADATA:
            {
               OnCarMetadataMsgBase *poMetadataMsgBase = static_cast<OnCarMetadataMsgBase*> (poMessage->pvBuffer);
               if (NULL != poMetadataMsgBase)
               {
                   poMetadataMsgBase->vDispatchMsg(m_poOnCarMetadataDispatcher);
               }
            }
               break;
            default:
            {
               ETG_TRACE_ERR(("[ERR]:Unknown ServiceID %d ", u32ServiceID));
            }
               break;
         }
      }

      t_U8 *pu8Buffer = static_cast<t_PU8> (poMessage->pvBuffer);
      RELEASE_ARRAY_MEM(pu8Buffer);
   }
   RELEASE_MEM(poMessage);
}

/***************************************************************************
 ** FUNCTION:  tShlMessage* spi_tclOnCarMsgQThreadable::poGetMsgBuffer()
 ***************************************************************************/
tShlMessage* spi_tclOnCarMsgQThreadable::poGetMsgBuffer(size_t siBuffer)
{
   ETG_TRACE_USR1((" spi_tclOnCarMsgQThreadable::poGetMsgBuffer entered \n"));
   tShlMessage* poMessage = new tShlMessage;

   if (NULL != poMessage)
   {
      if (0 < siBuffer)
      {
         //! Allocate the requested memory
         poMessage->pvBuffer = new(std::nothrow) t_U8[siBuffer];
      }
      else
      {
         poMessage->pvBuffer = NULL;
      } // if(0 < siBuffer)

      if (NULL != poMessage->pvBuffer)
      {
         poMessage->size = siBuffer;
      }
      else
      {
         //! Free the message as internal allocation failed.
         delete poMessage;
         poMessage = NULL;
      }
   }

   return poMessage;
}
