/***********************************************************************/
/*!
 * \file  spi_tclOnCarMsgQInterface.cpp
 * \brief interface for writing data to Q to use the MsgQ based
 *        threading model for OnCar Wrapper
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    interface for writing data to Q to use the MsgQ based
 threading model for OnCar Wrapper
 AUTHOR:         jun5kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 05.02.2018  | Unmukt Jain           | Initial version


 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "spi_tclOnCarMsgQInterface.h"
#include "MessageQueue.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclOnCarMsgQInterface.cpp.trc.h"
#endif
#endif

using namespace shl::thread;

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarMsgQInterface::spi_tclOnCarMsgQInterface()
 ***************************************************************************/
spi_tclOnCarMsgQInterface::spi_tclOnCarMsgQInterface() :
   m_poOnCarMsgQThreadable(NULL), m_poOnCarMsgQThreader(NULL)
{
   ETG_TRACE_USR1(("spi_tclOnCarMsgQInterface::spi_tclOnCarMsgQInterface entered "));

   m_poOnCarMsgQThreadable = new spi_tclOnCarMsgQThreadable();
   SPI_NORMAL_ASSERT(NULL == m_poOnCarMsgQThreadable);

   m_poOnCarMsgQThreader = new MsgQThreader(m_poOnCarMsgQThreadable);
   SPI_NORMAL_ASSERT(NULL == m_poOnCarMsgQThreader);

   if (NULL != m_poOnCarMsgQThreader)
   {
       m_poOnCarMsgQThreader->bRunThread();
       m_poOnCarMsgQThreader->vSetThreadName("OnCarRespQ");
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarMsgQInterface::~spi_tclOnCarMsgQInterface()
 ***************************************************************************/
spi_tclOnCarMsgQInterface::~spi_tclOnCarMsgQInterface()
{
   ETG_TRACE_USR1((" spi_tclOnCarMsgQInterface::~spi_tclOnCarMsgQInterface() entered \n"));

   if (NULL != m_poOnCarMsgQThreader)
   {
      //Terminate the Message Queue threader before deleting it.
      MessageQueue *poMsgQ = m_poOnCarMsgQThreader->poGetMessageQueu();
      trMsgBase oMsgQTermMsg;
      poMsgQ->s16Push(static_cast<t_Void*> (&oMsgQTermMsg), 0, 1, e8_TCL_THREAD_TERMINATE_MESSAGE);

      //Wait for the message queue thread to join.
      Threader::vWaitForTermination(m_poOnCarMsgQThreader->pGetThreadID());
   }

   RELEASE_MEM(m_poOnCarMsgQThreader);
   RELEASE_MEM(m_poOnCarMsgQThreadable);
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarMsgQInterface::bWriteMsgToQ
 ***************************************************************************/
t_Bool spi_tclOnCarMsgQInterface::bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize)
{
   ETG_TRACE_USR1((" spi_tclOnCarMsgQInterface::bWriteMsgToQ entered \n"));
   t_Bool bRetQ = false;

   if (NULL != m_poOnCarMsgQThreader)
   {
      //! Get the MsgQ form threader and push the message to Q
      MessageQueue *poMsgQ = m_poOnCarMsgQThreader->poGetMessageQueu();
      if ((NULL != poMsgQ) && (NULL != prMsgBase))
      {
         t_S32 s32RetMsgQ = poMsgQ->s16Push(static_cast<t_Void*> (prMsgBase), u32MsgSize);
         bRetQ = (0 == s32RetMsgQ);
      } // if ((NULL != poMsgQ) && (NULL != prMsgBase))
   } //if (NULL != m_poAAPMsgQThreader)

   if (false == bRetQ)
   {
      ETG_TRACE_ERR(("Write to MsgQ failed  \n"));
   }

   return bRetQ;
}
