/***********************************************************************/
/*!
 * \file   spi_tclOnCarManager.cpp
 * \brief  Implementation of the Class spi_tclOnCarManager
 *************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         jun5kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date            | Author                | Modification
 01.02.2018      | Unmukt Jain           | Initial Version

 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "OnCarTypes.h"
#include "spi_tclOnCarManager.h"

#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_ONCARWRAPPER
#include "trcGenProj/Header/spi_tclOnCarManager.cpp.trc.h"
#endif
#endif

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/
//tenDeviceSubCategory spi_tclMySPINManager::m_enDeviceSubCategory = e8DEVTYPE_UNKNWON;
//tenSessionStatus spi_tclMySPINManager::m_enSessionStatus = e8_SESSION_UNKNOWN;

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarManager::spi_tclOnCarManager()
 ***************************************************************************/
spi_tclOnCarManager::spi_tclOnCarManager():
m_poCmdSession(nullptr),
m_poCmdBluetooth(nullptr),
m_poCmdVideo(nullptr),
m_poCmdAudio(nullptr),
m_poCmdInput(nullptr),
m_poCmdMetadata(nullptr),
m_poCmdSensor(nullptr)
{
   ETG_TRACE_USR1(("spi_tclOnCarManager::spi_tclOnCarManager()"));

   m_poCmdSession = new(std::nothrow) spi_tclOnCarCmdSession();
   SPI_NORMAL_ASSERT(NULL == m_poCmdSession);

   m_poCmdBluetooth = new(std::nothrow) spi_tclOnCarCmdBluetooth();
   SPI_NORMAL_ASSERT(NULL == m_poCmdBluetooth);

   m_poCmdVideo = new(std::nothrow) spi_tclOnCarCmdVideo();
   SPI_NORMAL_ASSERT(NULL == m_poCmdVideo);

   m_poCmdAudio = new(std::nothrow) spi_tclOnCarCmdAudio();
   SPI_NORMAL_ASSERT(NULL == m_poCmdAudio);

   m_poCmdInput = new(std::nothrow) spi_tclOnCarCmdInput();
   SPI_NORMAL_ASSERT(NULL == m_poCmdInput);
   m_poCmdMetadata = new(std::nothrow) spi_tclOnCarCmdMetadata();
   SPI_NORMAL_ASSERT(NULL == m_poCmdMetadata);
   
   m_poCmdSensor = new(std::nothrow) spi_tclOnCarCmdSensor();
   SPI_NORMAL_ASSERT(NULL == m_poCmdSensor);
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarManager::~spi_tclOnCarManager()
 ***************************************************************************/
spi_tclOnCarManager::~spi_tclOnCarManager()
{
   ETG_TRACE_USR1(("spi_tclOnCarManager::~spi_tclOnCarManager()"));
   RELEASE_MEM(m_poCmdSession);
   RELEASE_MEM(m_poCmdBluetooth);
   RELEASE_MEM(m_poCmdVideo);
   RELEASE_MEM(m_poCmdAudio);
   RELEASE_MEM(m_poCmdInput);
   RELEASE_MEM(m_poCmdMetadata);
   RELEASE_MEM(m_poCmdSensor);
}

/***************************************************************************
 ** FUNCTION: spi_tclOnCarCmdAudio* spi_tclOnCarManager::poGetAudioInstance()
 **************************************************************************/
spi_tclOnCarCmdAudio* spi_tclOnCarManager::poGetAudioInstance()
{
   return m_poCmdAudio;
}

/**************************************************************************
 ** FUNCTION:  spi_tclOnCarCmdInput* spi_tclOnCarManager::poGetInputInstance()
 **************************************************************************/
spi_tclOnCarCmdInput* spi_tclOnCarManager::poGetInputInstance()
{
   return m_poCmdInput;
}

/**************************************************************************
 ** FUNCTION:  spi_tclOnCarCmdSession* spi_tclOnCarManager::poGetSessionInstance()
 **************************************************************************/
spi_tclOnCarCmdSession* spi_tclOnCarManager::poGetSessionInstance()
{
   return m_poCmdSession;
}

/**************************************************************************
 ** FUNCTION:  spi_tclOnCarCmdBluetooth* spi_tclOnCarManager::poGetBluetoothInstance()
 **************************************************************************/
spi_tclOnCarCmdBluetooth* spi_tclOnCarManager::poGetBluetoothInstance()
{
   return m_poCmdBluetooth;
}

/**************************************************************************
 ** FUNCTION:  spi_tclOnCarCmdVideo* spi_tclOnCarManager::poGetVideoInstance()
 **************************************************************************/
spi_tclOnCarCmdVideo* spi_tclOnCarManager::poGetVideoInstance()
{
   return m_poCmdVideo;
}
/**************************************************************************
 ** FUNCTION:  spi_tclOnCarCmdMetadata* spi_tclOnCarManager::poGetMetadataInstance()
 **************************************************************************/
spi_tclOnCarCmdMetadata* spi_tclOnCarManager::poGetMetadataInstance()
{
   return m_poCmdMetadata;
}

/**************************************************************************
 ** FUNCTION:  spi_tclOnCarCmdSensor* spi_tclOnCarManager::poGetSensorInstance()
 **************************************************************************/
spi_tclOnCarCmdSensor* spi_tclOnCarManager::poGetSensorInstance()
{
   return m_poCmdSensor;
}

/**************************************************************************
 ** FUNCTION: spi_tclMySPINCmdVehicleData* spi_tclMySPINManager::poGetVehDataInstance()
 **************************************************************************
spi_tclMySPINCmdVehicleData* spi_tclMySPINManager::poGetVehDataInstance()
{
   ETG_TRACE_USR1(("spi_tclMySPINManager::poGetVehDataInstance()"));

   return m_poCmdVehicleData;
}

*/

/**************************************************************************
 ** FUNCTION: t_Bool spi_tclOnCarManager::bRegisterObject()
 **************************************************************************/
t_Bool spi_tclOnCarManager::bRegisterObject(RespBase *poRespBase)
{
   ETG_TRACE_USR1(("spi_tclOnCarManager::bRegisterObject  Entered "));
   RespRegister *pRespRegister = RespRegister::getInstance();
   t_Bool bRetReg = false;
   if (NULL != pRespRegister)
   {
      bRetReg = pRespRegister->bRegisterObject(poRespBase);
   }
   return bRetReg;
}

/**************************************************************************
 ** FUNCTION: t_Bool spi_tclOnCarManager::bUnRegisterObject()
 **************************************************************************/
t_Bool spi_tclOnCarManager::bUnRegisterObject(RespBase *poRespBase)
{
   ETG_TRACE_USR1(("spi_tclOnCarManager::bUnRegisterObject  Entered"));
   RespRegister *pRespRegister = RespRegister::getInstance();
   t_Bool bRetReg = false;
   if (NULL != pRespRegister)
   {
      bRetReg = pRespRegister->bUnregisterObject(poRespBase);
   }
   return bRetReg;
}
